/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.Utils;

public class DigestOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    protected Digest digest;

    public DigestOutputStream(Digest digest) {
        this.algorithmName = digest.getAlgorithmName();
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.digest = digest;
    }

    public void write(int n) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update((byte)n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update(byArray, n, n2);
    }

    public final byte[] getDigest() {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return byArray;
    }
}

