/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ChangesFilter {
    private final String index;
    private final boolean sendIndexEventsOnlyForModifiedSources;
    private final Set<String> serverUUIDs;

    public static String getKey(String index) {
        return "[" + index + "]";
    }

    public ChangesFilter(String index, boolean sendIndexEventsOnlyForModifiedSources) {
        this.index = index;
        this.sendIndexEventsOnlyForModifiedSources = sendIndexEventsOnlyForModifiedSources;
        this.serverUUIDs = new HashSet<String>();
    }

    public ChangesFilter(Map<String, Object> map) {
        this.index = (String)map.get("index");
        this.sendIndexEventsOnlyForModifiedSources = (Boolean)map.get("sendIndexEventsOnlyForModifiedSources");
        this.serverUUIDs = map.containsKey("serverUUIDs") ? new HashSet((List)map.get("serverUUIDs")) : new HashSet();
    }

    public String getKey() {
        return ChangesFilter.getKey(this.index);
    }

    public String getIndex() {
        return this.index;
    }

    public boolean isSendIndexEventsOnlyForModifiedSources() {
        return this.sendIndexEventsOnlyForModifiedSources;
    }

    public boolean addServerUUID(String serverUUID) {
        if (serverUUID != null && !this.serverUUIDs.contains(serverUUID)) {
            this.serverUUIDs.add(serverUUID);
            return true;
        }
        return false;
    }

    public void removeServerUUID(String serverUUID) {
        if (serverUUID != null) {
            this.serverUUIDs.remove(serverUUID);
        }
    }

    public boolean hasServerUUIDs() {
        return !this.serverUUIDs.isEmpty();
    }

    public boolean belongsToServerUUID(String serverUUID) {
        return this.serverUUIDs.contains(serverUUID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangesFilter that = (ChangesFilter)o;
        return this.index.equals(that.index);
    }

    public int hashCode() {
        return this.index.hashCode();
    }

    public void addToBuilder(XContentBuilder builder) throws IOException {
        builder.startObject().field("index", this.index).field("sendIndexEventsOnlyForModifiedSources", this.sendIndexEventsOnlyForModifiedSources).field("serverUUIDs", this.serverUUIDs);
        builder.endObject();
    }

    public String toString() {
        return "ChangesFilter{index='" + this.index + '\'' + ", sendIndexEventsOnlyForModifiedSources=" + this.sendIndexEventsOnlyForModifiedSources + ", serverUUIDs=" + this.serverUUIDs + '}';
    }
}

