/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class MasterServerInfo {
    private static final Logger LOG = Loggers.getLogger(MasterServerInfo.class, (String[])new String[]{"es-bpc-plugin"});
    public static final String NONE = "<<NONE>>";
    private String serverUUID;
    private long setAtUtcMilli;

    public MasterServerInfo(String serverUUID) {
        this.serverUUID = serverUUID;
        this.setAtUtcMilli = TimestampUtil.getNowInUtcEpochMilli();
    }

    public MasterServerInfo(Map<String, Object> map) {
        if (map != null) {
            this.serverUUID = (String)map.get("serverUUID");
            this.setAtUtcMilli = (Long)map.get("setAtUtcMilli");
        }
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public long getSetAtUtcMilli() {
        return this.setAtUtcMilli;
    }

    public LocalDateTime getSetAt() {
        return TimestampUtil.asLocalDateTime(this.setAtUtcMilli);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MasterServerInfo that = (MasterServerInfo)o;
        return Objects.equals(this.serverUUID, that.serverUUID);
    }

    public int hashCode() {
        return Objects.hash(this.serverUUID);
    }

    public String asJsonString() {
        try {
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)new BytesStreamOutput());
            builder.startObject().field("serverUUID", this.serverUUID).field("setAtUtcMilli", this.setAtUtcMilli);
            builder.endObject();
            return Strings.toString((XContentBuilder)builder);
        }
        catch (IOException ex) {
            LOG.error("Failed to create the master server info JSON.", (Throwable)ex);
            return null;
        }
    }

    public String toString() {
        return "MasterServerInfo{serverUUID='" + this.serverUUID + '\'' + ", setAtUtcMilli=" + this.setAtUtcMilli + '}';
    }
}

