/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.interplugin;

import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestBodyMissingException;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestParamMissingException;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestUtil;
import de.virtimo.bpc.elasticsearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestBroadcastMessageReceivedAction
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestBroadcastMessageReceivedAction.class, (String[])new String[]{"es-bpc-plugin"});

    public RestBroadcastMessageReceivedAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.POST, "/_bpc/broadcast", (RestHandler)this);
    }

    public String getName() {
        return "broadcast_message_received_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        try {
            String fromNode = RequestUtil.getMandatoryQueryParamAsString(request, "fromNode");
            String websocketId = RequestUtil.getMandatoryQueryParamAsString(request, "websocketId");
            String serverUUID = RequestUtil.getMandatoryQueryParamAsString(request, "serverUUID");
            String topic = RequestUtil.getMandatoryQueryParamAsString(request, "topic");
            LOG.debug("fromNode=" + fromNode + ", websocketId=" + websocketId + ", serverUUID=" + serverUUID + ", topic=" + topic);
            String broadcastMessage = RequestUtil.getMandatoryBodyAsString(request);
            if ("broadcast_to_all".equalsIgnoreCase(topic)) {
                Manager.getInstance().getConnections().sendWebsocketMessage(broadcastMessage, null);
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "OK"));
            }
            if ("broadcast_to_all_except_sender".equalsIgnoreCase(topic)) {
                Manager.getInstance().getConnections().sendWebsocketMessage(broadcastMessage, Collections.singletonList(serverUUID));
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "OK"));
            }
            if ("broadcast_to".equalsIgnoreCase(topic)) {
                String serverUUIDs = broadcastMessage.substring(0, broadcastMessage.indexOf(":::"));
                String extractedMsg = broadcastMessage.substring((serverUUIDs + ":::").length());
                Manager.getInstance().getConnections().sendWebsocketMessageToServerUUIDs(extractedMsg, StringUtil.explode(serverUUIDs, "@@@"));
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "OK"));
            }
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "The 'topic' query parameter value '" + topic + "' is invalid."));
        }
        catch (RequestBodyMissingException | RequestParamMissingException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, ex.getMessage()));
        }
    }
}

