/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.Manager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ClusterSettings
extends AbstractLifecycleComponent {
    private static final Logger LOG = Loggers.getLogger(ClusterSettings.class, (String[])new String[]{"es-bpc-plugin"});
    public static String TRANSIENT_SETTINGS_PREFIX = "es-bpc-plugin";
    private static ClusterSettings INSTANCE = null;
    private Settings settings;
    private Provider<Client> clientProvider;

    @Inject
    public ClusterSettings(Settings settings, Provider<Client> clientProvider) {
        LOG.debug("ClusterSettings settings=" + settings + ", clientProvider=" + clientProvider);
        this.settings = settings;
        this.clientProvider = clientProvider;
    }

    public static ClusterSettings getInstance() {
        return INSTANCE;
    }

    protected void doStart() {
        INSTANCE = this;
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }

    public static String structuredSettingName(String name) {
        if (name.startsWith(TRANSIENT_SETTINGS_PREFIX + ".")) {
            return name;
        }
        return TRANSIENT_SETTINGS_PREFIX + "." + name;
    }

    public static String extractSettingName(String structuredSettingName) {
        if (structuredSettingName.startsWith(TRANSIENT_SETTINGS_PREFIX + ".")) {
            return structuredSettingName.substring((TRANSIENT_SETTINGS_PREFIX + ".").length());
        }
        return structuredSettingName;
    }

    public void setTransientSetting(String name, Object value) throws Exception {
        LOG.debug("setTransientSetting name=" + name + ", value=" + value);
        String structuredSettingName = ClusterSettings.structuredSettingName(name);
        boolean xpackSecurityEnabled = this.settings.getAsBoolean("xpack.security.enabled", Boolean.valueOf(false));
        if (xpackSecurityEnabled) {
            String path = "/_cluster/settings";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("flat_settings", "true");
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject().startObject("transient").field(structuredSettingName, value).endObject().endObject();
            String jsonMsg = Strings.toString((XContentBuilder)builder);
            Manager.getInstance().getNodeBroadcaster().httpPutJsonToLocalNode(path, params, jsonMsg);
        } else {
            HashMap<String, Object> s = new HashMap<String, Object>();
            s.put(structuredSettingName, value);
            ClusterUpdateSettingsRequest settingsUpdateRequest = new ClusterUpdateSettingsRequest();
            settingsUpdateRequest.transientSettings(s);
            ClusterUpdateSettingsResponse clusterUpdateSettingsResponse = (ClusterUpdateSettingsResponse)((Client)this.clientProvider.get()).admin().cluster().updateSettings(settingsUpdateRequest).get();
            if (clusterUpdateSettingsResponse.isAcknowledged()) {
                LOG.debug("Transient cluster setting '" + structuredSettingName + "' set to '" + value + "'");
            } else {
                LOG.debug("Failed to set the transient setting '" + structuredSettingName + "' to '" + value + "'");
            }
        }
    }

    public Object getTransientSetting(String name) throws ExecutionException, InterruptedException {
        LOG.debug("getTransientSetting name=" + name);
        return this.getTransientSettings().get(ClusterSettings.extractSettingName(name));
    }

    public Map<String, Object> getTransientSettings() throws ExecutionException, InterruptedException {
        LOG.debug("getTransientSettings");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest().metaData(true).customs(false).routingTable(false).nodes(false);
        ClusterStateResponse clusterStateResponse = (ClusterStateResponse)((Client)this.clientProvider.get()).admin().cluster().state(clusterStateRequest).get();
        Settings allTransientSettings = clusterStateResponse.getState().metaData().transientSettings();
        Settings esBpcPluginSettings = (Settings)allTransientSettings.getAsGroups().get(TRANSIENT_SETTINGS_PREFIX);
        if (esBpcPluginSettings != null && !esBpcPluginSettings.isEmpty()) {
            for (String name : esBpcPluginSettings.names()) {
                result.put(name, esBpcPluginSettings.get(name));
            }
        }
        return result;
    }
}

