/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.filters;

import de.virtimo.bpc.elasticsearch.plugin.ChangesFilter;
import de.virtimo.bpc.elasticsearch.plugin.Manager;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestGetFiltersAction
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestGetFiltersAction.class, (String[])new String[]{"es-bpc-plugin"});

    public RestGetFiltersAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/_bpc/filters", (RestHandler)this);
    }

    public String getName() {
        return "get_filters_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        String serverUUID = request.param("serverUUID", null);
        LOG.debug("serverUUID=" + serverUUID);
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject().startArray("filters");
        for (ChangesFilter filter : Manager.getInstance().getChangesFilters().getAll(serverUUID)) {
            builder.startObject().field("index", filter.getIndex()).field("sendIndexEventsOnlyForModifiedSources", filter.isSendIndexEventsOnlyForModifiedSources()).endObject();
        }
        builder.endArray().endObject();
        return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
    }
}

