/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.servers;

import de.virtimo.bpc.elasticsearch.plugin.BpcConnection;
import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.MasterServerInfo;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.servers.ConnectedServersUtil;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestGetConnectedMasterServerAction
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestGetConnectedMasterServerAction.class, (String[])new String[]{"es-bpc-plugin"});

    public RestGetConnectedMasterServerAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/_bpc/servers/master", (RestHandler)this);
    }

    public String getName() {
        return "get_master_server_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        MasterServerInfo masterServerInfo = Manager.getInstance().getMasterServerInfo();
        if (masterServerInfo == null) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_FOUND, "No master server found"));
        }
        BpcConnection connection = Manager.getInstance().getConnections().getConnectionByServerUUID(masterServerInfo.getServerUUID());
        if (connection == null) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_FOUND, "Failed to get the master server connection with the UUID: " + masterServerInfo.getServerUUID()));
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        ConnectedServersUtil.addConnection(builder, connection);
        return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
    }
}

