/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.servers;

import de.virtimo.bpc.elasticsearch.plugin.BpcConnection;
import de.virtimo.bpc.elasticsearch.plugin.ServerStateInfo;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ConnectedServersUtil {
    private static final Logger LOG = Loggers.getLogger(ConnectedServersUtil.class, (String[])new String[]{"es-bpc-plugin"});

    public static void addConnection(XContentBuilder builder, BpcConnection bpcConnection) throws IOException {
        LOG.debug("addConnection builder=..., bpcConnection=" + bpcConnection);
        if (bpcConnection != null) {
            String serverLoadedModules;
            builder.startObject();
            builder.field("nodeName", bpcConnection.getConnectedtNode());
            builder.field("websocketId", bpcConnection.getWebsocketId());
            ServerStateInfo serverStateInfo = bpcConnection.getServerStateInfo();
            if (serverStateInfo != null) {
                builder.field("serverUUID", serverStateInfo.getServerUUID());
                builder.field("serverHostname", serverStateInfo.getServerHostname());
                builder.field("serverAddress", serverStateInfo.getServerAddress());
                builder.field("serverHttpPort", serverStateInfo.getServerHttpPort());
                builder.field("serverHttpsPort", serverStateInfo.getServerHttpsPort());
                builder.field("bpcName", serverStateInfo.getBpcName());
                builder.field("bpcUrl", serverStateInfo.getBpcUrl());
                builder.field("maintenanceModeEnabled", serverStateInfo.isMaintenanceModeEnabled());
                builder.field("replicationEnabled", serverStateInfo.isReplicationEnabled());
                builder.field("lastStateUpdateInUtcMilli", serverStateInfo.getSendedAtUtcMilli());
                builder.field("lastStateUpdate", (Object)serverStateInfo.getSendedAt());
            }
            if ((serverLoadedModules = bpcConnection.getServerLoadedModules()) != null) {
                builder.field("loadedModules", serverLoadedModules);
            }
            builder.endObject();
        }
    }
}

