/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.model;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.SessionCookieConfig;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.MultipartDef;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.descriptor.web.ServletDef;
import org.apache.tomcat.util.descriptor.web.SessionConfig;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.descriptor.web.WebXmlParser;
import org.ops4j.pax.web.extender.war.internal.WarExtenderContext;
import org.ops4j.pax.web.extender.war.internal.WebApplicationHelper;
import org.ops4j.pax.web.extender.war.internal.model.BundleWebApplicationClassSpace;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.context.WebContainerContextWrapper;
import org.ops4j.pax.web.service.spi.model.ContextMetadataModel;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConstraintModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.model.events.WebApplicationEvent;
import org.ops4j.pax.web.service.spi.model.info.WebApplicationInfo;
import org.ops4j.pax.web.service.spi.model.views.WebAppWebContainerView;
import org.ops4j.pax.web.service.spi.servlet.DefaultSessionCookieConfig;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContextClassLoader;
import org.ops4j.pax.web.service.spi.task.Batch;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.spi.util.WebContainerManager;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.context.ServletContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWebApplication {
    public static final Logger LOG = LoggerFactory.getLogger(BundleWebApplication.class);
    private final Bundle bundle;
    private final WarExtenderContext extenderContext;
    private final WebContainerManager webContainerManager;
    private volatile ServiceReference<WebContainer> webContainerServiceRef;
    private final Lock refLock = new ReentrantLock();
    private final AtomicReference<State> deploymentState = new AtomicReference<State>(State.UNCONFIGURED);
    private CountDownLatch deployingLatch = null;
    private CountDownLatch allocatingLatch = null;
    private String contextPath;
    private WebXml mainWebXml = null;
    private BundleWebApplicationClassSpace classSpace = null;
    private OsgiServletContextClassLoader classLoader;
    private final Map<Bundle, URL> metainfResourceRoots = new LinkedHashMap<Bundle, URL>();
    private final Set<URL> faceletTagLibDescriptors = new LinkedHashSet<URL>();
    private final List<URL> serverSpecificDescriptors = new ArrayList<URL>();
    private final Map<ServletContainerInitializer, Set<Class<?>>> sciToHt = new LinkedHashMap();
    private Batch batch = null;
    private WebContainerContext httpContext = null;
    private OsgiContextModel allocatedOsgiContextModel = null;
    private ServletContextModel allocatedServletContextModel = null;

    public BundleWebApplication(Bundle bundle, WebContainerManager webContainerManager, WarExtenderContext extenderContext) {
        this.bundle = bundle;
        this.webContainerManager = webContainerManager;
        this.extenderContext = extenderContext;
    }

    public String toString() {
        return "Web Application \"" + this.contextPath + "\" for bundle " + this.bundle.getSymbolicName() + "/" + this.bundle.getVersion();
    }

    public void start() {
        State state = this.deploymentState.get();
        if (state != State.UNCONFIGURED) {
            return;
        }
        this.scheduleIfPossible(State.UNCONFIGURED, State.CONFIGURING, true);
    }

    public void stop() {
        ServiceReference<WebContainer> ref = this.webContainerServiceRef;
        WebAppWebContainerView view = (WebAppWebContainerView)this.webContainerManager.containerView(this.bundle, ref, WebAppWebContainerView.class);
        State state = this.deploymentState.get();
        switch (state) {
            case UNCONFIGURED: 
            case CONFIGURING: 
            case UNDEPLOYED: 
            case WAITING_FOR_WEB_CONTAINER: 
            case WAITING_FOR_CONTEXT: 
            case FAILED: {
                LOG.debug("Stopping {} in {} state. No need to cleanup anything.", (Object)this, (Object)state);
                break;
            }
            case ALLOCATING_CONTEXT: {
                try {
                    if (!this.allocatingLatch.await(10L, TimeUnit.SECONDS)) {
                        LOG.warn("Timeout waiting for end of context allocation for {}. Can't free the context, leaving it in inconsistent state.", (Object)this);
                        break;
                    }
                    if (view != null) {
                        LOG.info("Undeploying {} after its context has been allocated", (Object)this);
                        this.releaseContext(view, false);
                        break;
                    }
                    LOG.warn("Successful wait for context allocation for {}, but WebContainer is no longer available and we can't release the context.", (Object)this);
                }
                catch (InterruptedException e) {
                    LOG.warn("Thread interrupted while waiting for end of context allocation for {}. Can't free the context, leaving it in inconsistent state.", (Object)this);
                    Thread.currentThread().interrupt();
                }
                break;
            }
            case DEPLOYING: {
                try {
                    if (!this.deployingLatch.await(10L, TimeUnit.SECONDS)) {
                        LOG.warn("Timeout waiting for end of deployment of {}. Can't undeploy the application which may be left in inconsistent state.", (Object)this);
                        break;
                    }
                    if (view != null) {
                        LOG.info("Undeploying {} after waiting for its full deployment", (Object)this);
                        this.undeploy(view);
                        break;
                    }
                    LOG.warn("Successful wait for full deployment of {}, but WebContainer is no longer available and we can't undeploy it", (Object)this);
                }
                catch (InterruptedException e) {
                    LOG.warn("Thread interrupted while waiting for end of deployment of {}. Can't undeploy the application which may be left in inconsistent state.", (Object)this);
                    Thread.currentThread().interrupt();
                }
                break;
            }
            case DEPLOYED: {
                if (view != null) {
                    LOG.info("Undeploying fully deployed {}", (Object)this);
                    this.undeploy(view);
                    break;
                }
                LOG.info("Can't undeploy {} - WebContainer reference is no longer available", (Object)this);
                break;
            }
        }
        this.deploymentState.set(State.UNDEPLOYED);
        this.webContainerManager.releaseContainer(this.bundle, ref);
    }

    private boolean scheduleIfPossible(State expectedState, State newState, boolean synchronous) {
        if (expectedState != null) {
            if (this.deploymentState.compareAndSet(expectedState, newState)) {
                if (!synchronous) {
                    this.extenderContext.getPool().submit(this::deploy);
                } else {
                    this.deploy();
                }
                return true;
            }
            return false;
        }
        this.deploymentState.set(newState);
        if (!synchronous) {
            this.extenderContext.getPool().submit(this::deploy);
        } else {
            this.deploy();
        }
        return true;
    }

    public void webContainerAdded(ServiceReference<WebContainer> ref) {
        this.refLock.lock();
        try {
            this.webContainerServiceRef = ref;
            State state = this.deploymentState.get();
            if (state == State.UNCONFIGURED) {
                this.scheduleIfPossible(State.UNCONFIGURED, State.CONFIGURING, false);
            } else if (state == State.WAITING_FOR_WEB_CONTAINER) {
                this.scheduleIfPossible(State.WAITING_FOR_WEB_CONTAINER, State.ALLOCATING_CONTEXT, false);
            }
        }
        finally {
            this.refLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webContainerRemoved(ServiceReference<WebContainer> ref) {
        if (ref != this.webContainerServiceRef) {
            if (this.webContainerServiceRef != null) {
                throw new IllegalStateException("Removing unknown WebContainer reference " + ref + ", expecting " + this.webContainerServiceRef);
            }
            return;
        }
        LOG.info("WebContainer reference is gone. Cleaning up the state of " + this);
        this.refLock.lock();
        try {
            WebAppWebContainerView view = (WebAppWebContainerView)this.webContainerManager.containerView(this.bundle, this.webContainerServiceRef, WebAppWebContainerView.class);
            State state = this.deploymentState.get();
            if (view == null) {
                LOG.info("WebContainer reference {} was removed, {} should already be undeployed.", ref, (Object)this);
                this.deploymentState.set(State.UNCONFIGURED);
            } else {
                switch (state) {
                    case UNCONFIGURED: 
                    case CONFIGURING: 
                    case UNDEPLOYED: 
                    case WAITING_FOR_WEB_CONTAINER: 
                    case WAITING_FOR_CONTEXT: 
                    case FAILED: 
                    case UNDEPLOYING: {
                        this.deploymentState.set(State.UNCONFIGURED);
                        break;
                    }
                    case ALLOCATING_CONTEXT: {
                        try {
                            if (!this.allocatingLatch.await(10L, TimeUnit.SECONDS)) {
                                LOG.warn("Timeout waiting for end of context allocation for {}. Can't free the context, leaving it in inconsistent state.", (Object)this);
                            } else {
                                LOG.info("Undeploying {} after its context has been allocated", (Object)this);
                                this.releaseContext(view, false);
                            }
                        }
                        catch (InterruptedException e) {
                            LOG.warn("Thread interrupted while waiting for end of context allocation for {}. Can't free the context, leaving it in inconsistent state.", (Object)this);
                            Thread.currentThread().interrupt();
                        }
                        this.deploymentState.set(State.UNCONFIGURED);
                        break;
                    }
                    case DEPLOYING: {
                        try {
                            if (!this.deployingLatch.await(10L, TimeUnit.SECONDS)) {
                                LOG.warn("Timeout waiting for end of deployment of {}. Can't undeploy the application which may be left in inconsistent state (in previous WebContainer).", (Object)this);
                                break;
                            }
                            LOG.info("Undeploying {} from previous WebContainer after waiting for its full deployment", (Object)this);
                            this.undeploy(view);
                            this.deploymentState.set(State.UNCONFIGURED);
                        }
                        catch (InterruptedException e) {
                            LOG.warn("Thread interrupted while waiting for end of deployment of {}. Can't undeploy the application which may be left in inconsistent state.", (Object)this);
                            Thread.currentThread().interrupt();
                        }
                        break;
                    }
                    case DEPLOYED: {
                        LOG.info("Undeploying fully deployed {}", (Object)this);
                        this.undeploy(view);
                        this.deploymentState.set(State.UNCONFIGURED);
                        break;
                    }
                }
            }
            this.webContainerManager.releaseContainer(this.bundle, ref);
            this.webContainerServiceRef = null;
        }
        finally {
            this.refLock.unlock();
            BundleWebApplication bundleWebApplication = this;
            synchronized (bundleWebApplication) {
                this.batch = null;
                this.classSpace = null;
                this.sciToHt.clear();
                this.httpContext = null;
                this.allocatedOsgiContextModel = null;
                this.allocatedServletContextModel = null;
                this.classLoader = null;
                this.mainWebXml = null;
                this.faceletTagLibDescriptors.clear();
                this.serverSpecificDescriptors.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebAppWebContainerView currentWebContainer(State currentState) {
        this.refLock.lock();
        try {
            WebAppWebContainerView view = (WebAppWebContainerView)this.webContainerManager.containerView(this.bundle, this.webContainerServiceRef, WebAppWebContainerView.class);
            if (view == null && this.deploymentState.compareAndSet(currentState, State.WAITING_FOR_WEB_CONTAINER)) {
                LOG.debug("WebContainer service reference is not available. {} enters Grace Period state.", (Object)this);
                this.extenderContext.sendWebEvent(new WebApplicationEvent(WebApplicationEvent.State.WAITING, this.bundle, this.contextPath, null));
            }
            WebAppWebContainerView webAppWebContainerView = view;
            return webAppWebContainerView;
        }
        finally {
            this.refLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deploy() {
        try {
            WebAppWebContainerView view;
            if (this.bundle.getState() != 32 && this.bundle.getState() != 8) {
                return;
            }
            State state = this.deploymentState.get();
            if (state == State.CONFIGURING) {
                LOG.info("Configuring {}", (Object)this);
                this.extenderContext.sendWebEvent(new WebApplicationEvent(WebApplicationEvent.State.DEPLOYING, this.bundle, this.contextPath, null));
                OsgiServletContextClassLoader loader = new OsgiServletContextClassLoader();
                loader.addBundle(this.bundle);
                loader.addBundle(FrameworkUtil.getBundle(WebXmlParser.class));
                this.classLoader = loader;
                this.processMetadata();
                State st = this.deploymentState.get();
                if ((st == State.CONFIGURING || st == State.ALLOCATING_CONTEXT) && this.deploymentState.compareAndSet(st, State.ALLOCATING_CONTEXT)) {
                    if (this.allocatingLatch != null && this.allocatingLatch.getCount() > 0L) {
                        throw new IllegalStateException("[dev error] Previous context allocation attempt didn't finish properly. Existing latch found.");
                    }
                    this.allocatingLatch = new CountDownLatch(1);
                }
            }
            if ((state = this.deploymentState.get()) == State.ALLOCATING_CONTEXT || state == State.WAITING_FOR_CONTEXT) {
                LOG.debug("Checking if {} context path is available", (Object)this.contextPath);
                view = this.currentWebContainer(state);
                if (view == null) {
                    return;
                }
                WebAppWebContainerView.AllocationStatus status = view.allocateContext(this.bundle, this.contextPath);
                if (status != WebAppWebContainerView.AllocationStatus.ALLOCATED) {
                    if (status == WebAppWebContainerView.AllocationStatus.NOT_AVAILABLE) {
                        LOG.debug("Context path {} is already used. {} will wait for this context to be available.", (Object)this.contextPath, (Object)this);
                        if (this.deploymentState.compareAndSet(state, State.WAITING_FOR_CONTEXT)) {
                            WebApplicationEvent event = new WebApplicationEvent(WebApplicationEvent.State.FAILED, this.bundle, this.contextPath, null);
                            event.setAwaitingAllocation(true);
                            event.setCollisionIds(this.extenderContext.calculateCollisionIds(this.contextPath, this.bundle));
                            this.extenderContext.sendWebEvent(event);
                        }
                    } else if (status == WebAppWebContainerView.AllocationStatus.SERVICE_STOPPED) {
                        this.deploymentState.compareAndSet(state, State.WAITING_FOR_CONTEXT);
                    }
                    return;
                }
                this.allocatedServletContextModel = view.getServletContext(this.bundle, this.contextPath);
                this.allocatedOsgiContextModel = view.getOsgiContext(this.bundle, this.contextPath);
                LOG.info("Allocated context for {}: {}", (Object)this.contextPath, (Object)this.allocatedOsgiContextModel);
                this.buildModel();
                if (this.deploymentState.compareAndSet(state, State.DEPLOYING)) {
                    this.allocatingLatch.countDown();
                    if (this.deployingLatch != null && this.deployingLatch.getCount() > 0L) {
                        throw new IllegalStateException("[dev error] Previous deployment attempt didn't finish properly. Existing latch found.");
                    }
                    this.deployingLatch = new CountDownLatch(1);
                }
            }
            if ((state = this.deploymentState.get()) == State.DEPLOYING) {
                LOG.debug("Registering {} in WebContainer", (Object)this.contextPath);
                view = this.currentWebContainer(state);
                if (view == null) {
                    return;
                }
                view.sendBatch(this.batch);
                if (this.deploymentState.compareAndSet(state, State.DEPLOYED)) {
                    this.extenderContext.sendWebEvent(new WebApplicationEvent(WebApplicationEvent.State.DEPLOYED, this.bundle, this.contextPath, (HttpContext)this.httpContext));
                }
            }
        }
        catch (Throwable t) {
            this.deploymentState.set(State.FAILED);
            LOG.error("Problem processing {}: {}", new Object[]{this, t.getMessage(), t});
            this.extenderContext.sendWebEvent(new WebApplicationEvent(WebApplicationEvent.State.FAILED, this.bundle, this.contextPath, null, t));
        }
        finally {
            if (this.allocatingLatch != null) {
                this.allocatingLatch.countDown();
            }
            if (this.deployingLatch != null) {
                this.deployingLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy(WebAppWebContainerView view) {
        if (view == null) {
            throw new IllegalArgumentException("Can't undeploy " + this + " without valid WebContainer");
        }
        try {
            this.deploymentState.set(State.UNDEPLOYING);
            this.extenderContext.sendWebEvent(new WebApplicationEvent(WebApplicationEvent.State.UNDEPLOYING, this.bundle, this.contextPath, null));
            Batch uninstall = this.batch.uninstall("Undeployment of " + this);
            uninstall.setShortDescription("undeploy " + this.contextPath);
            view.sendBatch(uninstall);
            this.releaseContext(view, true);
            this.extenderContext.sendWebEvent(new WebApplicationEvent(WebApplicationEvent.State.UNDEPLOYED, this.bundle, this.contextPath, null));
            Batch toSchedule = new Batch("After undeployment of \"" + this.contextPath + "\"");
            for (Change c : uninstall.getOperations()) {
                if (c.getBatchCompletedAction() == null) continue;
                toSchedule.getOperations().add(c.getBatchCompletedAction());
            }
            if (!toSchedule.getOperations().isEmpty()) {
                LOG.info("Scheduling {}", (Object)toSchedule);
                view.sendBatch(toSchedule);
            }
        }
        catch (Exception e) {
            LOG.warn("Problem undeploying {}: {}", new Object[]{this, e.getMessage(), e});
            this.extenderContext.sendWebEvent(new WebApplicationEvent(WebApplicationEvent.State.FAILED, this.bundle, this.contextPath, null, (Throwable)e));
        }
        finally {
            this.batch = null;
            this.classSpace = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseContext(WebAppWebContainerView view, boolean propagateException) {
        if (view == null) {
            throw new IllegalArgumentException("Can't undeploy " + this + " without valid WebContainer");
        }
        try {
            view.releaseContext(this.bundle, this.contextPath);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof RejectedExecutionException) {
                LOG.debug("{} was not undeployed, config executor stopped.", (Object)this);
                return;
            }
            if (propagateException) {
                throw new RuntimeException(e);
            }
            LOG.warn("Problem releasing context for {}: {}", new Object[]{this, e.getMessage(), e});
        }
        finally {
            this.allocatedOsgiContextModel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMetadata() {
        long start = System.currentTimeMillis();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            WebXml defaultWebXml = this.extenderContext.getDefaultWebXml();
            LOG.debug("Searching for web.xml descriptor in {}", (Object)this.bundle);
            this.mainWebXml = this.extenderContext.findBundleWebXml(this.bundle);
            this.classSpace = new BundleWebApplicationClassSpace(this.bundle, this.extenderContext);
            try {
                Enumeration descriptors;
                LOG.debug("Searching for web fragments");
                this.classSpace.initialize(this.mainWebXml, this.classLoader);
                boolean ok = this.classSpace.isFragmentParsingOK();
                if (!ok) {
                    LOG.warn("There were problems when parsing web-fragment.xml descriptors. Scanning for ServletContainerInitializers and annotated classes won't be performed.");
                }
                if (ok) {
                    LOG.debug("Searching for ServletContainerInitializers (SCIs)");
                }
                List<ServletContainerInitializer> detectedSCIs = ok ? this.classSpace.loadSCIs() : Collections.emptyList();
                HashMap htToSci = new HashMap();
                for (ServletContainerInitializer sci : detectedSCIs) {
                    this.sciToHt.put(sci, new HashSet());
                }
                boolean thereAreHTClasses = false;
                boolean thereAreHTAnnotations = false;
                if (ok) {
                    for (ServletContainerInitializer servletContainerInitializer : detectedSCIs) {
                        HandlesTypes ht = servletContainerInitializer.getClass().getAnnotation(HandlesTypes.class);
                        if (ht == null || ht.value().length <= 0) continue;
                        for (Class c : ht.value()) {
                            htToSci.computeIfAbsent(c, _c -> new HashSet()).add(servletContainerInitializer);
                            if (!thereAreHTClasses && !c.isAnnotation()) {
                                thereAreHTClasses = true;
                            }
                            if (thereAreHTAnnotations || !c.isAnnotation()) continue;
                            thereAreHTAnnotations = true;
                        }
                    }
                }
                if (!(!ok || this.mainWebXml.isMetadataComplete() && htToSci.isEmpty())) {
                    LOG.debug("Scanning for annotated classes and/or types declared in @HandlesTypes SCI annotations");
                    this.classSpace.scanClasses(htToSci, this.sciToHt, thereAreHTClasses, thereAreHTAnnotations);
                }
                if (!this.mainWebXml.isMetadataComplete() && ok) {
                    ok = this.mainWebXml.merge(this.classSpace.getOrderedFragments());
                }
                this.mainWebXml.merge(Collections.singleton(defaultWebXml));
                if (ok) {
                    ServletDef jsp = (ServletDef)this.mainWebXml.getServlets().get("jsp");
                    Map map = jsp == null ? Collections.emptyMap() : jsp.getParameterMap();
                    Iterator it = this.mainWebXml.getServlets().entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String name = (String)entry.getKey();
                        ServletDef def = (ServletDef)entry.getValue();
                        if (def.getJspFile() == null) continue;
                        if (jsp == null) {
                            LOG.warn("A servlet named {} is used with jsp-file, but there's no \"jsp\" servlet configured. Removing.", (Object)def.getServletName());
                            it.remove();
                            this.mainWebXml.getServletMappings().entrySet().removeIf(e -> ((String)e.getValue()).equals(def.getServletName()));
                            continue;
                        }
                        String jspFile = def.getJspFile();
                        if (!jspFile.startsWith("/")) {
                            jspFile = "/" + jspFile;
                        }
                        def.setServletClass(jsp.getServletClass());
                        map.forEach((arg_0, arg_1) -> ((ServletDef)def).addInitParameter(arg_0, arg_1));
                        def.addInitParameter("jspFile", jspFile);
                        def.setJspFile(null);
                    }
                }
                try {
                    URL metainfResource;
                    for (URL uRL : this.classSpace.getWabClassPath()) {
                        metainfResource = new URL(uRL, "META-INF/resources/");
                        if (Utils.isDirectory((URL)metainfResource)) {
                            this.metainfResourceRoots.put(this.bundle, metainfResource);
                        }
                        this.faceletTagLibDescriptors.addAll(ClassPathUtil.findEntries((Bundle)this.bundle, (URL[])new URL[]{uRL}, (String)"META-INF", (String)"*.taglib.xml", (boolean)true));
                    }
                    for (Map.Entry entry : this.classSpace.getApplicationFragmentBundles().entrySet()) {
                        metainfResource = new URL((URL)entry.getValue(), "META-INF/resources/");
                        if (Utils.isDirectory((URL)metainfResource)) {
                            this.metainfResourceRoots.put((Bundle)entry.getKey(), metainfResource);
                        }
                        this.faceletTagLibDescriptors.addAll(ClassPathUtil.findEntries((Bundle)((Bundle)entry.getKey()), (URL[])new URL[]{(URL)entry.getValue()}, (String)"META-INF", (String)"*.taglib.xml", (boolean)true));
                    }
                }
                catch (MalformedURLException jsp) {
                    // empty catch block
                }
                if ((descriptors = this.bundle.findEntries("WEB-INF", "jetty-web.xml", false)) == null) {
                    descriptors = this.bundle.findEntries("WEB-INF", "web-jetty.xml", false);
                }
                if (descriptors != null) {
                    while (descriptors.hasMoreElements()) {
                        URL uRL = (URL)descriptors.nextElement();
                        LOG.debug("Found Jetty-specific descriptor: {}", (Object)uRL);
                        this.serverSpecificDescriptors.add(uRL);
                    }
                }
                if ((descriptors = this.bundle.findEntries("META-INF", "context.xml", false)) != null) {
                    while (descriptors.hasMoreElements()) {
                        URL uRL = (URL)descriptors.nextElement();
                        LOG.debug("Found Tomcat-specific descriptor: {}", (Object)uRL);
                        this.serverSpecificDescriptors.add(uRL);
                    }
                }
                List list = ClassPathUtil.findEntries((Bundle)this.bundle, (URL[])ClassPathUtil.getClassPathNonJars((Bundle)this.bundle), (String)"META-INF", (String)"context.xml", (boolean)false);
                for (URL url3 : list) {
                    LOG.debug("Found Tomcat-specific descriptor: {}", (Object)url3);
                    this.serverSpecificDescriptors.add(url3);
                }
                LOG.debug("Finished metadata and fragment processing for {} in {}ms", (Object)this.bundle, (Object)(System.currentTimeMillis() - start));
            }
            catch (IOException e3) {
                throw new RuntimeException(e3.getMessage(), e3);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void buildModel() {
        String connectors;
        Batch wabBatch = new Batch("Deployment of " + this);
        wabBatch.setShortDescription("deploy " + this.contextPath);
        wabBatch.beginTransaction(this.contextPath);
        ServletContextModel scm = this.allocatedServletContextModel;
        wabBatch.addServletContextModel(scm);
        OsgiContextModel ocm = this.allocatedOsgiContextModel;
        ocm.setWab(true);
        ocm.setServiceId(0L);
        ocm.setServiceRank(Integer.MAX_VALUE);
        ocm.setClassLoader(this.classLoader);
        ocm.getContextRegistrationProperties().put("osgi.http.whiteboard.context.path", this.contextPath);
        String virtualHosts = Utils.getManifestHeader((Bundle)this.bundle, (String)"Web-VirtualHosts");
        if (virtualHosts != null && !"".equals(virtualHosts.trim())) {
            String[] virtualHostsArray = Utils.asStringArray((String)"org.ops4j.pax.web.http.whiteboard.virtualhosts", (Object)virtualHosts, (boolean)true);
            for (int i = 0; i < virtualHostsArray.length; ++i) {
                String s = virtualHostsArray[i];
                if (!s.contains("/")) continue;
                virtualHostsArray[i] = s.replace("/", "@");
            }
            ocm.getVirtualHosts().addAll(Arrays.asList(virtualHostsArray));
            ocm.getContextRegistrationProperties().put("org.ops4j.pax.web.http.whiteboard.virtualhosts", virtualHostsArray);
        }
        if ((connectors = Utils.getManifestHeader((Bundle)this.bundle, (String)"Web-Connectors")) != null && !"".equals(connectors.trim())) {
            String[] connectorsArray = Utils.asStringArray((String)"org.ops4j.pax.web.http.whiteboard.connectors", (Object)connectors, (boolean)true);
            ocm.getConnectors().addAll(Arrays.asList(connectorsArray));
            ocm.getContextRegistrationProperties().put("org.ops4j.pax.web.http.whiteboard.connectors", connectorsArray);
        }
        WebApplicationHelper contextHelper = new WebApplicationHelper(this.bundle, this.metainfResourceRoots);
        this.httpContext = new WebContainerContextWrapper(this.bundle, (ServletContextHelper)contextHelper, this.contextPath, false);
        ocm.setHttpContext(this.httpContext);
        SessionConfig webXmlSessionConfig = this.mainWebXml.getSessionConfig();
        if (webXmlSessionConfig != null) {
            if (webXmlSessionConfig.getSessionTimeout() != null) {
                ocm.setSessionTimeout(webXmlSessionConfig.getSessionTimeout());
            }
            DefaultSessionCookieConfig scc = new DefaultSessionCookieConfig();
            ocm.setSessionCookieConfig((SessionCookieConfig)scc);
            if (webXmlSessionConfig.getCookieName() != null) {
                scc.setName(webXmlSessionConfig.getCookieName());
            }
            if (webXmlSessionConfig.getCookieDomain() != null) {
                scc.setDomain(webXmlSessionConfig.getCookieDomain());
            }
            if (webXmlSessionConfig.getCookiePath() != null) {
                scc.setPath(webXmlSessionConfig.getCookiePath());
            }
            if (webXmlSessionConfig.getCookieMaxAge() != null) {
                scc.setMaxAge(webXmlSessionConfig.getCookieMaxAge().intValue());
            }
            if (webXmlSessionConfig.getCookieHttpOnly() != null) {
                scc.setHttpOnly(webXmlSessionConfig.getCookieHttpOnly().booleanValue());
            }
            if (webXmlSessionConfig.getCookieSecure() != null) {
                scc.setSecure(webXmlSessionConfig.getCookieSecure().booleanValue());
            }
            if (webXmlSessionConfig.getCookieComment() != null) {
                scc.setComment(webXmlSessionConfig.getCookieComment());
            }
            if (webXmlSessionConfig.getSessionTrackingModes() != null) {
                ocm.getSessionConfiguration().getTrackingModes().addAll(webXmlSessionConfig.getSessionTrackingModes());
            }
        }
        ocm.getJspConfigDescriptor().getTaglibs().clear();
        ocm.getJspConfigDescriptor().getJspPropertyGroups().clear();
        JspConfigDescriptor jspConfig = this.mainWebXml.getJspConfigDescriptor();
        if (jspConfig != null) {
            ocm.addTagLibs(jspConfig.getTaglibs());
            for (JspPropertyGroupDescriptor group : jspConfig.getJspPropertyGroups()) {
                ocm.addJspPropertyGroupDescriptor(group);
            }
        }
        if (this.classSpace.getOrderedLibs() != null) {
            ocm.getInitialContextAttributes().put("javax.servlet.context.orderedLibs", this.classSpace.getOrderedLibs());
        }
        if (!this.faceletTagLibDescriptors.isEmpty()) {
            HashMap faceletsUrlMapping = new HashMap();
            String faceletsLibraries = this.faceletTagLibDescriptors.stream().map(u -> {
                String ef = u.toExternalForm();
                String path = ef.contains("!/") ? ef.substring(ef.indexOf("!/") + 2) : u.getPath();
                faceletsUrlMapping.putIfAbsent(path, u);
                return path;
            }).collect(Collectors.joining(";"));
            ocm.getContextParams().put("javax.faces.FACELETS_LIBRARIES", faceletsLibraries);
            ocm.getInitialContextAttributes().put("org.ops4j.pax.web.javax.faces.FACELETS_LIBRARIES", faceletsUrlMapping);
        }
        ocm.getContextParams().putAll(this.mainWebXml.getContextParams());
        LoginConfig loginConfig = this.mainWebXml.getLoginConfig();
        SecurityConfigurationModel securityConfiguration = ocm.getSecurityConfiguration();
        if (loginConfig != null) {
            LoginConfigModel lcm = new LoginConfigModel();
            lcm.setAuthMethod(loginConfig.getAuthMethod());
            lcm.setRealmName(loginConfig.getRealmName());
            lcm.setFormLoginPage(loginConfig.getLoginPage());
            lcm.setFormErrorPage(loginConfig.getErrorPage());
            securityConfiguration.setLoginConfig(lcm);
        }
        securityConfiguration.getSecurityRoles().addAll(this.mainWebXml.getSecurityRoles());
        for (SecurityConstraint sc : this.mainWebXml.getSecurityConstraints()) {
            SecurityConstraintModel constraint = new SecurityConstraintModel();
            constraint.setName(sc.getDisplayName());
            for (SecurityCollection wrc : sc.findCollections()) {
                SecurityConstraintModel.WebResourceCollection collection = new SecurityConstraintModel.WebResourceCollection();
                collection.setName(wrc.getName());
                collection.getMethods().addAll(Arrays.asList(wrc.findMethods()));
                collection.getOmittedMethods().addAll(Arrays.asList(wrc.findOmittedMethods()));
                collection.getPatterns().addAll(Arrays.asList(wrc.findPatterns()));
                constraint.getWebResourceCollections().add(collection);
            }
            constraint.setAuthRolesSet(sc.getAuthConstraint());
            constraint.getAuthRoles().addAll(Arrays.asList(sc.findAuthRoles()));
            securityConfiguration.getSecurityRoles().addAll(constraint.getAuthRoles());
            if (sc.getUserConstraint() != null && !"".equals(sc.getUserConstraint().trim())) {
                if (ServletSecurity.TransportGuarantee.NONE.toString().equals(sc.getUserConstraint())) {
                    constraint.setTransportGuarantee(ServletSecurity.TransportGuarantee.NONE);
                } else {
                    constraint.setTransportGuarantee(ServletSecurity.TransportGuarantee.CONFIDENTIAL);
                }
            }
            securityConfiguration.getSecurityConstraints().add(constraint);
        }
        ocm.getServerSpecificDescriptors().addAll(this.serverSpecificDescriptors);
        wabBatch.addOsgiContextModel(ocm, scm);
        wabBatch.associateOsgiContextModel(this.httpContext, ocm);
        ContextMetadataModel meta = new ContextMetadataModel();
        meta.setPublicId(this.mainWebXml.getPublicId());
        meta.setMajorVersion(this.mainWebXml.getMajorVersion());
        meta.setMinorVersion(this.mainWebXml.getMinorVersion());
        meta.setMetadataComplete(this.mainWebXml.isMetadataComplete());
        meta.setDistributable(this.mainWebXml.isDistributable());
        meta.setDisplayName(this.mainWebXml.getDisplayName());
        meta.setRequestCharacterEncoding(this.mainWebXml.getRequestCharacterEncoding());
        meta.setResponseCharacterEncoding(this.mainWebXml.getResponseCharacterEncoding());
        meta.setDenyUncoveredHttpMethods(this.mainWebXml.getDenyUncoveredHttpMethods());
        wabBatch.configureMetadata(meta, ocm);
        wabBatch.configureMimeAndEncodingMappings(this.mainWebXml.getMimeMappings(), this.mainWebXml.getLocaleEncodingMappings(), ocm);
        LinkedHashMap servletMappings = new LinkedHashMap();
        this.mainWebXml.getServletMappings().forEach((pattern, sn) -> servletMappings.computeIfAbsent(sn, n -> new LinkedList()).add(pattern));
        this.mainWebXml.getServlets().forEach((sn, def) -> {
            Class servletClass = null;
            try {
                if (def.getServletClass() != null) {
                    servletClass = this.classLoader.loadClass(def.getServletClass());
                }
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Can't load servlet class {} in the context of {}: {}", new Object[]{def.getServletClass(), this, e.getMessage(), e});
                return;
            }
            List<String> mappingsForServlet = (List<String>)servletMappings.get(sn);
            if (mappingsForServlet == null) {
                mappingsForServlet = Collections.emptyList();
            }
            String[] mappings = mappingsForServlet.toArray(new String[0]);
            ServletModel.Builder builder = new ServletModel.Builder().withRegisteringBundle(this.bundle).withServletName(sn).withServletClass(servletClass).withUrlPatterns(mappings).withAsyncSupported(def.getAsyncSupported()).withLoadOnStartup(def.getLoadOnStartup()).withInitParams(def.getParameterMap()).withOsgiContextModel(ocm);
            MultipartDef md = def.getMultipartDef();
            if (md != null) {
                long maxFileSize = md.getMaxFileSize() == null ? -1L : Long.parseLong(md.getMaxFileSize());
                long maxRequestSize = md.getMaxRequestSize() == null ? -1L : Long.parseLong(md.getMaxRequestSize());
                int fileSizeThreshold = md.getFileSizeThreshold() == null ? 0 : Integer.parseInt(md.getFileSizeThreshold());
                MultipartConfigElement mpConfig = new MultipartConfigElement(md.getLocation(), maxFileSize, maxRequestSize, fileSizeThreshold);
                builder.withMultipartConfigElement(mpConfig);
            }
            if (servletClass == null) {
                builder.resourceServlet(true);
            }
            if ("jsp".equals(sn)) {
                builder.jspServlet(true);
            }
            builder.setOverridable(def.isOverridable());
            if (servletClass != null) {
                ServletSecurity servletSecurity;
                this.collectDeclaredRoles(servletClass, securityConfiguration);
                RunAs runAs = servletClass.getAnnotation(RunAs.class);
                if (runAs != null) {
                    builder.setRunAs(runAs.value());
                }
                if ((servletSecurity = servletClass.getAnnotation(ServletSecurity.class)) != null) {
                    for (String urlPattern : mappingsForServlet) {
                        boolean foundConflict = false;
                        for (SecurityConstraintModel seccm : securityConfiguration.getSecurityConstraints()) {
                            for (SecurityConstraintModel.WebResourceCollection col : seccm.getWebResourceCollections()) {
                                if (!col.getPatterns().contains(urlPattern)) continue;
                                foundConflict = true;
                                break;
                            }
                            if (!foundConflict) continue;
                            break;
                        }
                        if (foundConflict) {
                            LOG.warn("Servlet {} annotated with @ServletSecurity has conflict with existing <security-constraints> from the descriptor(s) for the pattern \"{}\"", (Object)servletClass, (Object)urlPattern);
                            continue;
                        }
                        HttpMethodConstraint[] withMethods = servletSecurity.httpMethodConstraints();
                        ArrayList<String> omittedMethods = new ArrayList<String>();
                        for (HttpMethodConstraint c : withMethods) {
                            SecurityConstraintModel constraint = new SecurityConstraintModel();
                            SecurityConstraintModel.WebResourceCollection col = new SecurityConstraintModel.WebResourceCollection();
                            constraint.getWebResourceCollections().add(col);
                            constraint.setTransportGuarantee(c.transportGuarantee());
                            constraint.getAuthRoles().addAll(Arrays.asList(c.rolesAllowed()));
                            if (constraint.getAuthRoles().isEmpty()) {
                                constraint.setAuthRolesSet(c.emptyRoleSemantic() == ServletSecurity.EmptyRoleSemantic.DENY);
                            } else {
                                constraint.setAuthRolesSet(true);
                            }
                            col.getPatterns().add(urlPattern);
                            col.getMethods().add(c.value());
                            omittedMethods.add(c.value());
                            securityConfiguration.getSecurityConstraints().add(constraint);
                        }
                        HttpConstraint c = servletSecurity.value();
                        if (c == null) continue;
                        SecurityConstraintModel constraint = new SecurityConstraintModel();
                        SecurityConstraintModel.WebResourceCollection col = new SecurityConstraintModel.WebResourceCollection();
                        constraint.getWebResourceCollections().add(col);
                        constraint.setTransportGuarantee(c.transportGuarantee());
                        constraint.getAuthRoles().addAll(Arrays.asList(c.rolesAllowed()));
                        if (constraint.getAuthRoles().isEmpty()) {
                            constraint.setAuthRolesSet(c.value() == ServletSecurity.EmptyRoleSemantic.DENY);
                        } else {
                            constraint.setAuthRolesSet(true);
                        }
                        col.getPatterns().add(urlPattern);
                        col.getOmittedMethods().addAll(omittedMethods);
                        securityConfiguration.getSecurityConstraints().add(constraint);
                    }
                }
            }
            if (def.getSecurityRoleRefs() != null) {
                def.getSecurityRoleRefs().forEach(srr -> builder.addRoleLink(srr.getName(), srr.getLink()));
            }
            wabBatch.addServletModel(builder.build(), new OsgiContextModel[0]);
        });
        HashMap allFilterModels = new HashMap();
        TreeMap filterModels = new TreeMap();
        allFilterModels.put(this.contextPath, filterModels);
        HashMap filterMappings = new HashMap();
        this.mainWebXml.getFilterMappings().forEach(fm -> filterMappings.computeIfAbsent(fm.getFilterName(), n -> new LinkedList()).add(fm));
        this.mainWebXml.getFilters().forEach((fn, def) -> {
            Class filterClass = null;
            try {
                if (def.getFilterClass() != null) {
                    filterClass = this.classLoader.loadClass(def.getFilterClass());
                }
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Can't load filter class {} in the context of {}: {}", new Object[]{def.getFilterClass(), this, e.getMessage(), e});
                return;
            }
            FilterModel.Builder builder = new FilterModel.Builder().withRegisteringBundle(this.bundle).withFilterName(fn).withFilterClass(filterClass).withAsyncSupported(Boolean.valueOf("true".equals(def.getAsyncSupported()))).withInitParams(def.getParameterMap()).withOsgiContextModel(ocm);
            FilterModel fm = builder.build();
            for (FilterMap map : (List)filterMappings.get(fn)) {
                FilterModel.Mapping m = new FilterModel.Mapping();
                String[] dtn = map.getDispatcherNames();
                if (dtn == null || dtn.length == 0) {
                    m.setDispatcherTypes(new DispatcherType[]{DispatcherType.REQUEST});
                } else {
                    m.setDispatcherTypes((DispatcherType[])Arrays.stream(dtn).map(name -> DispatcherType.valueOf((String)name.toUpperCase(Locale.ROOT))).toArray(DispatcherType[]::new));
                }
                m.setServletNames(map.getServletNames());
                m.setUrlPatterns(map.getURLPatterns());
                fm.getMappingsPerDispatcherTypes().add(m);
            }
            if (filterClass != null) {
                this.collectDeclaredRoles(filterClass, securityConfiguration);
            }
            filterModels.put(fm, null);
            wabBatch.addFilterModel(fm, new OsgiContextModel[0]);
        });
        if (filterModels.size() > 0) {
            wabBatch.updateFilters(allFilterModels, false);
        }
        for (String listener : this.mainWebXml.getListeners()) {
            try {
                Class listenerClass = this.classLoader.loadClass(listener);
                EventListener eventListener = (EventListener)listenerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                EventListenerModel elm = new EventListenerModel(eventListener);
                elm.setRegisteringBundle(this.bundle);
                elm.addContextModel(ocm);
                this.collectDeclaredRoles(listenerClass, securityConfiguration);
                wabBatch.addEventListenerModel(elm, new OsgiContextModel[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Can't load listener class {} in the context of {}: {}", new Object[]{listener, this, e.getMessage(), e});
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.warn("Can't instantiate listener class {} in the context of {}: {}", new Object[]{listener, this, e.getMessage(), e});
            }
        }
        WelcomeFileModel wfm = new WelcomeFileModel(this.mainWebXml.getWelcomeFiles().toArray(new String[0]), false);
        wfm.setRegisteringBundle(this.bundle);
        wfm.addContextModel(ocm);
        wabBatch.addWelcomeFileModel(wfm, new OsgiContextModel[0]);
        HashMap allEpModels = new HashMap();
        TreeMap epModels = new TreeMap();
        allEpModels.put(this.contextPath, epModels);
        LinkedHashMap<String, List> locationToPage = new LinkedHashMap<String, List>();
        this.mainWebXml.getErrorPages().values().forEach(ep -> locationToPage.computeIfAbsent(ep.getLocation(), l -> new ArrayList()).add(ep.getName()));
        locationToPage.forEach((l, pages) -> {
            ErrorPageModel epm = new ErrorPageModel(pages.toArray(new String[0]), l);
            epm.setRegisteringBundle(this.bundle);
            epm.addContextModel(ocm);
            epm.performValidation();
            epModels.put(epm, null);
            wabBatch.addErrorPageModel(epm, new OsgiContextModel[0]);
        });
        if (epModels.size() > 0) {
            wabBatch.updateErrorPages(allEpModels);
        }
        this.sciToHt.forEach((sci, classes) -> {
            Class[] classesArray = classes.isEmpty() ? null : classes.toArray(new Class[0]);
            ContainerInitializerModel cim = new ContainerInitializerModel(sci, classesArray);
            cim.setRegisteringBundle(this.bundle);
            cim.addContextModel(ocm);
            wabBatch.addContainerInitializerModel(cim, new OsgiContextModel[0]);
        });
        wabBatch.commitTransaction(this.contextPath);
        this.batch = wabBatch;
    }

    private void collectDeclaredRoles(Class<?> clazz, SecurityConfigurationModel securityConfiguration) {
        DeclareRoles dr = clazz.getAnnotation(DeclareRoles.class);
        if (dr != null && dr.value() != null) {
            for (String role : dr.value()) {
                securityConfiguration.getSecurityRoles().add(role);
            }
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public State getDeploymentState() {
        return this.deploymentState.get();
    }

    public WebApplicationInfo asWebApplicationModel() {
        URL[] urls;
        WebApplicationInfo model = new WebApplicationInfo(this.allocatedOsgiContextModel);
        model.setBundle(this.bundle);
        model.setWab(true);
        model.setDeploymentState(this.deploymentState.get().getStateName());
        model.setContextPath(this.contextPath);
        model.getServletContainerInitializers().addAll(this.sciToHt.keySet().stream().map(sci -> sci.getClass().getName()).collect(Collectors.toList()));
        model.getMetaInfResources().addAll(this.metainfResourceRoots.values());
        model.getDescriptors().addAll(this.serverSpecificDescriptors);
        for (URL url : urls = ClassPathUtil.getClassPathNonJars((Bundle)this.bundle)) {
            model.getWabClassPath().add(url);
        }
        BundleWebApplicationClassSpace cs = this.classSpace;
        if (cs != null) {
            model.getWabClassPath().addAll(cs.getWabClassPath());
            model.getWabClassPathSkipped().addAll(cs.getWabClassPathNotScanned());
            model.getContainerFragmentBundles().addAll(cs.getContainerFragmentBundles());
            model.getApplicationFragmentBundles().addAll(cs.getApplicationFragmentBundles().keySet());
        }
        return model;
    }

    public static enum State {
        UNCONFIGURED("Not configured"),
        CONFIGURING("Configuring"),
        ALLOCATING_CONTEXT("Allocating"),
        DEPLOYING("Deploying"),
        DEPLOYED("Deployed"),
        WAITING_FOR_WEB_CONTAINER("Awaiting registration"),
        WAITING_FOR_CONTEXT("Awaiting context"),
        UNDEPLOYING("Undeploying"),
        UNDEPLOYED("Undeployed"),
        FAILED("Failed");

        private final String stateName;

        private State(String stateName) {
            this.stateName = stateName;
        }

        public String getStateName() {
            return this.stateName;
        }
    }
}

