/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.XShapeCollection;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.geometry.MultiPoint;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;

public class MultiPointBuilder
extends ShapeBuilder<XShapeCollection<Point>, MultiPoint, MultiPointBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.MULTIPOINT;

    public MultiPointBuilder(List<Coordinate> coordinates) {
        super(coordinates);
    }

    public MultiPointBuilder() {
    }

    public MultiPointBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ShapeParser.FIELD_TYPE.getPreferredName(), TYPE.shapeName());
        builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
        super.coordinatesToXcontent(builder, false);
        builder.endObject();
        return builder;
    }

    @Override
    public XShapeCollection<Point> buildS4J() {
        ArrayList<Point> shapes = new ArrayList<Point>(this.coordinates.size());
        for (Coordinate coord : this.coordinates) {
            shapes.add(SPATIAL_CONTEXT.makePoint(coord.x, coord.y));
        }
        XShapeCollection<Point> multiPoints = new XShapeCollection<Point>(shapes, (SpatialContext)SPATIAL_CONTEXT);
        multiPoints.setPointsOnly(true);
        return multiPoints;
    }

    @Override
    public MultiPoint buildGeometry() {
        if (this.coordinates.isEmpty()) {
            return MultiPoint.EMPTY;
        }
        return new MultiPoint(this.coordinates.stream().map(coord -> new org.elasticsearch.geometry.Point(coord.x, coord.y)).collect(Collectors.toList()));
    }

    @Override
    public GeoShapeType type() {
        return TYPE;
    }

    @Override
    public int numDimensions() {
        if (this.coordinates == null || this.coordinates.isEmpty()) {
            throw new IllegalStateException("unable to get number of dimensions, LineString has not yet been initialized");
        }
        return Double.isNaN(((Coordinate)this.coordinates.get((int)0)).z) ? 2 : 3;
    }
}

