/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.interplugin;

import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestBodyMissingException;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestParamMissingException;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestChangesFilterAddAction
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestChangesFilterAddAction.class, (String[])new String[]{"es-bpc-plugin"});

    public RestChangesFilterAddAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.POST, "/_bpc/changesfilter/add", (RestHandler)this);
    }

    public String getName() {
        return "changes_filter_add_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        try {
            String fromNode = RequestUtil.getMandatoryQueryParamAsString(request, "fromNode");
            LOG.debug("fromNode=" + fromNode);
            Map<String, Object> msgBodyMap = RequestUtil.getMandatoryJsonBodyAsMap(request);
            Manager.getInstance().processAddChangesFilter((String)msgBodyMap.get("serverUUID"), (String)msgBodyMap.get("index"), (Boolean)msgBodyMap.get("sendIndexEventsOnlyForModifiedSources"));
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "OK"));
        }
        catch (RequestBodyMissingException | RequestParamMissingException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, ex.getMessage()));
        }
    }
}

