/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.utils.TimestampUtil;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;

public class ServerStateInfo {
    private static final Logger LOG = Loggers.getLogger(ServerStateInfo.class, (String[])new String[]{"es-bpc-plugin"});
    private String serverUUID;
    private String serverHostname;
    private String serverAddress;
    private String serverHttpPort;
    private String bpcName;
    private boolean maintenanceModeEnabled;
    private boolean replicationEnabled;
    private long sendedAtUtcMilli;

    private ServerStateInfo() {
    }

    public ServerStateInfo(Map<String, Object> stateInfoMessage) {
        this.serverUUID = (String)stateInfoMessage.get("serverUUID");
        this.serverHostname = (String)stateInfoMessage.get("serverHostname");
        this.serverAddress = (String)stateInfoMessage.get("serverAddress");
        this.serverHttpPort = (String)stateInfoMessage.get("serverHttpPort");
        this.bpcName = (String)stateInfoMessage.get("bpcName");
        this.maintenanceModeEnabled = (Boolean)stateInfoMessage.get("maintenanceModeEnabled");
        this.replicationEnabled = (Boolean)stateInfoMessage.get("replicationEnabled");
        this.sendedAtUtcMilli = ((Number)stateInfoMessage.get("sendedAtUtcMilli")).longValue();
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public String getServerHostname() {
        return this.serverHostname;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServerHttpPort() {
        return this.serverHttpPort;
    }

    public String getBpcName() {
        return this.bpcName;
    }

    public boolean isMaintenanceModeEnabled() {
        return this.maintenanceModeEnabled;
    }

    public boolean isReplicationEnabled() {
        return this.replicationEnabled;
    }

    public long getSendedAtUtcMilli() {
        return this.sendedAtUtcMilli;
    }

    public LocalDateTime getSendedAt() {
        return TimestampUtil.asLocalDateTime(this.sendedAtUtcMilli);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerStateInfo that = (ServerStateInfo)o;
        return this.maintenanceModeEnabled == that.maintenanceModeEnabled && this.replicationEnabled == that.replicationEnabled && this.sendedAtUtcMilli == that.sendedAtUtcMilli && Objects.equals(this.serverUUID, that.serverUUID) && Objects.equals(this.serverHostname, that.serverHostname) && Objects.equals(this.serverAddress, that.serverAddress) && Objects.equals(this.serverHttpPort, that.serverHttpPort) && Objects.equals(this.bpcName, that.bpcName);
    }

    public int hashCode() {
        return Objects.hash(this.serverUUID);
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("serverUUID", this.serverUUID);
        result.put("serverHostname", this.serverHostname);
        result.put("serverAddress", this.serverAddress);
        result.put("serverHttpPort", this.serverHttpPort);
        result.put("bpcName", this.bpcName);
        result.put("maintenanceModeEnabled", this.maintenanceModeEnabled);
        result.put("replicationEnabled", this.replicationEnabled);
        result.put("sendedAtUtcMilli", this.sendedAtUtcMilli);
        return result;
    }

    public String toString() {
        return "ServerStateInfo{serverUUID='" + this.serverUUID + '\'' + ", serverHostname='" + this.serverHostname + '\'' + ", serverAddress='" + this.serverAddress + '\'' + ", serverHttpPort='" + this.serverHttpPort + '\'' + ", bpcName='" + this.bpcName + '\'' + ", maintenanceModeEnabled=" + this.maintenanceModeEnabled + ", replicationEnabled=" + this.replicationEnabled + ", sendedAtUtcMilli=" + this.sendedAtUtcMilli + '}';
    }
}

