/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.filters;

import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestParamMissingException;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestUtil;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestAddFilterAction
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestAddFilterAction.class, (String[])new String[]{"es-bpc-plugin"});

    public RestAddFilterAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.PUT, "/_bpc/filters", (RestHandler)this);
    }

    public String getName() {
        return "add_filter_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        try {
            String serverUUID = RequestUtil.getMandatoryQueryParamAsString(request, "serverUUID");
            String index = RequestUtil.getMandatoryQueryParamAsString(request, "index");
            boolean sendIndexEventsOnlyForModifiedSources = request.paramAsBoolean("sendIndexEventsOnlyForModifiedSources", Boolean.TRUE);
            LOG.debug("serverUUID=" + serverUUID + ", index=" + index + ", sendIndexEventsOnlyForModifiedSources=" + sendIndexEventsOnlyForModifiedSources);
            Manager.getInstance().addChangesFilter(serverUUID, index, sendIndexEventsOnlyForModifiedSources, true);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "OK"));
        }
        catch (RequestParamMissingException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, ex.getMessage()));
        }
    }
}

