/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.interplugin;

import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestBodyMissingException;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestParamMissingException;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestUtil;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestIndexOperationAction
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestIndexOperationAction.class, (String[])new String[]{"es-bpc-plugin"});

    public RestIndexOperationAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.POST, "/_bpc/index_operation", (RestHandler)this);
    }

    public String getName() {
        return "index_operation_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        try {
            String fromNode = RequestUtil.getMandatoryQueryParamAsString(request, "fromNode");
            LOG.debug("fromNode=" + fromNode);
            String indexOperationJsonContent = RequestUtil.getMandatoryBodyAsString(request);
            Manager.getInstance().getConnections().sendWebsocketMessage("IndexOperation:::" + indexOperationJsonContent, null);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "OK"));
        }
        catch (RequestBodyMissingException | RequestParamMissingException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, ex.getMessage()));
        }
    }
}

