/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.filters;

import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestParamMissingException;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestUtil;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestRemoveFiltersAction
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestRemoveFiltersAction.class, (String[])new String[]{"es-bpc-plugin"});

    public RestRemoveFiltersAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.DELETE, "/_bpc/filters", (RestHandler)this);
    }

    public String getName() {
        return "remove_filters_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        try {
            String serverUUID = RequestUtil.getMandatoryQueryParamAsString(request, "serverUUID");
            boolean removeAll = request.paramAsBoolean("all", Boolean.FALSE);
            String index = removeAll ? null : RequestUtil.getMandatoryQueryParamAsString(request, "index");
            LOG.debug("serverUUID=" + serverUUID + ", all=" + removeAll + ", index=" + index);
            if (removeAll) {
                Manager.getInstance().removeAllChangesFiltersOfServerUUID(serverUUID, true);
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "OK"));
            }
            if (!Manager.getInstance().removeChangesFilter(serverUUID, index, true)) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_FOUND, "Filter not found"));
            }
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "OK"));
        }
        catch (RequestParamMissingException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, ex.getMessage()));
        }
    }
}

