/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.FutureArrays;
import org.apache.lucene.util.NumericUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Rectangle2D {
    protected final byte[] bbox = new byte[16];
    private final byte[] west;
    protected final int minX;
    protected final int maxX;
    protected final int minY;
    protected final int maxY;

    protected Rectangle2D(double minLat, double maxLat, double minLon, double maxLon) {
        int minXenc = GeoEncodingUtils.encodeLongitudeCeil((double)minLon);
        int maxXenc = GeoEncodingUtils.encodeLongitude((double)maxLon);
        int minYenc = GeoEncodingUtils.encodeLatitudeCeil((double)minLat);
        int maxYenc = GeoEncodingUtils.encodeLatitude((double)maxLat);
        if (minYenc > maxYenc) {
            minYenc = maxYenc;
        }
        this.minY = minYenc;
        this.maxY = maxYenc;
        if (minLon > maxLon) {
            this.west = new byte[16];
            this.minX = minXenc;
            this.maxX = maxXenc;
            Rectangle2D.encode(GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY, this.west);
            Rectangle2D.encode(this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY, this.bbox);
        } else {
            if (minXenc > maxXenc) {
                minXenc = maxXenc;
            }
            this.west = null;
            this.minX = minXenc;
            this.maxX = maxXenc;
            Rectangle2D.encode(this.minX, this.maxX, this.minY, this.maxY, this.bbox);
        }
    }

    protected Rectangle2D(int minX, int maxX, int minY, int maxY) {
        this.west = null;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        Rectangle2D.encode(this.minX, this.maxX, this.minY, this.maxY, this.bbox);
    }

    public static Rectangle2D create(Rectangle rectangle) {
        return new Rectangle2D(rectangle.minLat, rectangle.maxLat, rectangle.minLon, rectangle.maxLon);
    }

    public boolean crossesDateline() {
        return this.minX > this.maxX;
    }

    public boolean queryContainsPoint(int x, int y) {
        if (this.crossesDateline()) {
            return Rectangle2D.bboxContainsPoint(x, y, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || Rectangle2D.bboxContainsPoint(x, y, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
        }
        return Rectangle2D.bboxContainsPoint(x, y, this.minX, this.maxX, this.minY, this.maxY);
    }

    public PointValues.Relation relateRangeBBox(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        PointValues.Relation eastRelation = Rectangle2D.compareBBoxToRangeBBox(this.bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        if (this.crossesDateline() && eastRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return Rectangle2D.compareBBoxToRangeBBox(this.west, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        }
        return eastRelation;
    }

    public PointValues.Relation intersectRangeBBox(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        PointValues.Relation eastRelation = Rectangle2D.intersectBBoxWithRangeBBox(this.bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        if (this.crossesDateline() && eastRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return Rectangle2D.intersectBBoxWithRangeBBox(this.west, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        }
        return eastRelation;
    }

    public boolean intersectsTriangle(int aX, int aY, int bX, int bY, int cX, int cY) {
        if (this.queryContainsPoint(aX, aY) || this.queryContainsPoint(bX, bY) || this.queryContainsPoint(cX, cY)) {
            return true;
        }
        int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
        int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
        int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
        int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
        if (this.crossesDateline() ? Rectangle2D.boxesAreDisjoint(tMinX, tMaxX, tMinY, tMaxY, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) && Rectangle2D.boxesAreDisjoint(tMinX, tMaxX, tMinY, tMaxY, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY) : tMaxX < this.minX || tMinX > this.maxX || tMinY > this.maxY || tMaxY < this.minY) {
            return false;
        }
        if (Tessellator.pointInTriangle(this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.maxX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.maxX, this.maxY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.minX, this.maxY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        return this.queryIntersects(aX, aY, bX, bY, cX, cY);
    }

    public boolean containsTriangle(int ax, int ay, int bx, int by, int cx, int cy) {
        if (this.crossesDateline()) {
            return Rectangle2D.bboxContainsTriangle(ax, ay, bx, by, cx, cy, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || Rectangle2D.bboxContainsTriangle(ax, ay, bx, by, cx, cy, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
        }
        return Rectangle2D.bboxContainsTriangle(ax, ay, bx, by, cx, cy, this.minX, this.maxX, this.minY, this.maxY);
    }

    private static PointValues.Relation compareBBoxToRangeBBox(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        if (Rectangle2D.disjoint(bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (FutureArrays.compareUnsigned((byte[])minTriangle, (int)minXOffset, (int)(minXOffset + 4), (byte[])bbox, (int)4, (int)8) >= 0 && FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxXOffset, (int)(maxXOffset + 4), (byte[])bbox, (int)12, (int)16) <= 0 && FutureArrays.compareUnsigned((byte[])minTriangle, (int)minYOffset, (int)(minYOffset + 4), (byte[])bbox, (int)0, (int)4) >= 0 && FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxYOffset, (int)(maxYOffset + 4), (byte[])bbox, (int)8, (int)12) <= 0) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private static PointValues.Relation intersectBBoxWithRangeBBox(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        if (Rectangle2D.disjoint(bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (FutureArrays.compareUnsigned((byte[])minTriangle, (int)minXOffset, (int)(minXOffset + 4), (byte[])bbox, (int)4, (int)8) >= 0 && FutureArrays.compareUnsigned((byte[])minTriangle, (int)minYOffset, (int)(minYOffset + 4), (byte[])bbox, (int)0, (int)4) >= 0) {
            if (FutureArrays.compareUnsigned((byte[])maxTriangle, (int)minXOffset, (int)(minXOffset + 4), (byte[])bbox, (int)12, (int)16) <= 0 && FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxYOffset, (int)(maxYOffset + 4), (byte[])bbox, (int)8, (int)12) <= 0) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            if (FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxXOffset, (int)(maxXOffset + 4), (byte[])bbox, (int)12, (int)16) <= 0 && FutureArrays.compareUnsigned((byte[])maxTriangle, (int)minYOffset, (int)(minYOffset + 4), (byte[])bbox, (int)8, (int)12) <= 0) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
        }
        if (FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxXOffset, (int)(maxXOffset + 4), (byte[])bbox, (int)12, (int)16) <= 0 && FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxYOffset, (int)(maxYOffset + 4), (byte[])bbox, (int)8, (int)12) <= 0) {
            if (FutureArrays.compareUnsigned((byte[])minTriangle, (int)minXOffset, (int)(minXOffset + 4), (byte[])bbox, (int)4, (int)8) >= 0 && FutureArrays.compareUnsigned((byte[])minTriangle, (int)maxYOffset, (int)(maxYOffset + 4), (byte[])bbox, (int)0, (int)4) >= 0) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            if (FutureArrays.compareUnsigned((byte[])minTriangle, (int)maxXOffset, (int)(maxXOffset + 4), (byte[])bbox, (int)4, (int)8) >= 0 && FutureArrays.compareUnsigned((byte[])minTriangle, (int)minYOffset, (int)(minYOffset + 4), (byte[])bbox, (int)0, (int)4) >= 0) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private static boolean disjoint(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        return FutureArrays.compareUnsigned((byte[])minTriangle, (int)minXOffset, (int)(minXOffset + 4), (byte[])bbox, (int)12, (int)16) > 0 || FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxXOffset, (int)(maxXOffset + 4), (byte[])bbox, (int)4, (int)8) < 0 || FutureArrays.compareUnsigned((byte[])minTriangle, (int)minYOffset, (int)(minYOffset + 4), (byte[])bbox, (int)8, (int)12) > 0 || FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxYOffset, (int)(maxYOffset + 4), (byte[])bbox, (int)0, (int)4) < 0;
    }

    private static void encode(int minX, int maxX, int minY, int maxY, byte[] b) {
        if (b == null) {
            b = new byte[16];
        }
        NumericUtils.intToSortableBytes((int)minY, (byte[])b, (int)0);
        NumericUtils.intToSortableBytes((int)minX, (byte[])b, (int)4);
        NumericUtils.intToSortableBytes((int)maxY, (byte[])b, (int)8);
        NumericUtils.intToSortableBytes((int)maxX, (byte[])b, (int)12);
    }

    private boolean queryIntersects(int ax, int ay, int bx, int by, int cx, int cy) {
        return this.edgeIntersectsQuery(ax, ay, bx, by) || this.edgeIntersectsQuery(bx, by, cx, cy) || this.edgeIntersectsQuery(cx, cy, ax, ay);
    }

    private boolean edgeIntersectsQuery(int ax, int ay, int bx, int by) {
        if (this.crossesDateline()) {
            return Rectangle2D.edgeIntersectsBox(ax, ay, bx, by, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || Rectangle2D.edgeIntersectsBox(ax, ay, bx, by, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
        }
        return Rectangle2D.edgeIntersectsBox(ax, ay, bx, by, this.minX, this.maxX, this.minY, this.maxY);
    }

    private static boolean bboxContainsPoint(int x, int y, int minX, int maxX, int minY, int maxY) {
        return !(x < minX || x > maxX || y < minY || y > maxY);
    }

    private static boolean bboxContainsTriangle(int ax, int ay, int bx, int by, int cx, int cy, int minX, int maxX, int minY, int maxY) {
        return Rectangle2D.bboxContainsPoint(ax, ay, minX, maxX, minY, maxY) && Rectangle2D.bboxContainsPoint(bx, by, minX, maxX, minY, maxY) && Rectangle2D.bboxContainsPoint(cx, cy, minX, maxX, minY, maxY);
    }

    private static boolean edgeIntersectsBox(int ax, int ay, int bx, int by, int minX, int maxX, int minY, int maxY) {
        if (ax == bx && ay == by) {
            return Rectangle.containsPoint((double)ay, (double)ax, (double)minY, (double)maxY, (double)minX, (double)maxX);
        }
        if (Rectangle2D.bboxContainsPoint(ax, ay, minX, maxX, minY, maxY) || Rectangle2D.bboxContainsPoint(bx, by, minX, maxX, minY, maxY)) {
            return true;
        }
        if (Rectangle2D.boxesAreDisjoint(Math.min(ax, bx), Math.max(ax, bx), Math.min(ay, by), Math.max(ay, by), minX, maxX, minY, maxY)) {
            return false;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)minX, (double)maxY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)maxX, (double)maxY) <= 0 && GeoUtils.orient((double)minX, (double)maxY, (double)maxX, (double)maxY, (double)ax, (double)ay) * GeoUtils.orient((double)minX, (double)maxY, (double)maxX, (double)maxY, (double)bx, (double)by) <= 0) {
            return true;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)maxX, (double)maxY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)maxX, (double)minY) <= 0 && GeoUtils.orient((double)maxX, (double)maxY, (double)maxX, (double)minY, (double)ax, (double)ay) * GeoUtils.orient((double)maxX, (double)maxY, (double)maxX, (double)minY, (double)bx, (double)by) <= 0) {
            return true;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)maxX, (double)minY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)minX, (double)minY) <= 0 && GeoUtils.orient((double)maxX, (double)minY, (double)minX, (double)minY, (double)ax, (double)ay) * GeoUtils.orient((double)maxX, (double)minY, (double)minX, (double)minY, (double)bx, (double)by) <= 0) {
            return true;
        }
        return GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)minX, (double)minY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)minX, (double)maxY) <= 0 && GeoUtils.orient((double)minX, (double)minY, (double)minX, (double)maxY, (double)ax, (double)ay) * GeoUtils.orient((double)minX, (double)minY, (double)minX, (double)maxY, (double)bx, (double)by) <= 0;
    }

    private static boolean boxesAreDisjoint(int aMinX, int aMaxX, int aMinY, int aMaxY, int bMinX, int bMaxX, int bMinY, int bMaxY) {
        return aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D that = (Rectangle2D)o;
        return this.minX == that.minX && this.maxX == that.maxX && this.minY == that.minY && this.maxY == that.maxY && Arrays.equals(this.bbox, that.bbox) && Arrays.equals(this.west, that.west);
    }

    public int hashCode() {
        int result = Objects.hash(this.minX, this.maxX, this.minY, this.maxY);
        result = 31 * result + Arrays.hashCode(this.bbox);
        result = 31 * result + Arrays.hashCode(this.west);
        return result;
    }
}

