/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.BpcConnection;
import de.virtimo.bpc.elasticsearch.plugin.IndexOperation;
import de.virtimo.bpc.elasticsearch.plugin.NodesInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class NodeBroadcaster
extends AbstractLifecycleComponent {
    private static final Logger LOG = Loggers.getLogger(NodeBroadcaster.class, (String[])new String[]{"es-bpc-plugin"});
    private NodeBroadcaster INSTANCE = null;
    private Settings settings;
    private Provider<Client> clientProvider;
    private NodesInfo nodesInfo;

    @Inject
    public NodeBroadcaster(Settings settings, Provider<Client> clientProvider, NodesInfo nodesInfo) {
        LOG.debug("NodeBroadcaster settings=" + settings + ", clientProvider=" + clientProvider + ", nodesInfo=" + (Object)((Object)nodesInfo));
        this.settings = settings;
        this.clientProvider = clientProvider;
        this.nodesInfo = nodesInfo;
    }

    public NodeBroadcaster getInstance() {
        return this.INSTANCE;
    }

    protected void doStart() {
        this.INSTANCE = this;
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }

    private List<NodeInfo> getAllNodes() throws ExecutionException, InterruptedException {
        LOG.debug("getAllNodes");
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[0]).clear().http(true);
        NodesInfoResponse nodeInfos = (NodesInfoResponse)((Client)this.clientProvider.get()).admin().cluster().nodesInfo(nodesInfoRequest).get();
        return nodeInfos.getNodes();
    }

    private NodeInfo getLocalNodeInfo() {
        LOG.debug("getLocalNodeInfo");
        try {
            String thisNodeName = this.nodesInfo.getLocalNodeName();
            for (NodeInfo nodeInfo : this.getAllNodes()) {
                String nodeName = nodeInfo.getNode().getName();
                if (!nodeName.equals(thisNodeName)) continue;
                return nodeInfo;
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to get the local node info.", (Throwable)ex);
        }
        return null;
    }

    private URIBuilder getURIBuilderForElasticsearchEndpoint(NodeInfo nodeInfo, String path) {
        return new URIBuilder().setScheme(this.settings.getAsBoolean("xpack.security.http.ssl.enabled", Boolean.valueOf(false)) != false ? "https" : "http").setHost(nodeInfo.getHttp().getAddress().publishAddress().getAddress()).setPort(nodeInfo.getHttp().getAddress().publishAddress().getPort()).setPath(path);
    }

    public void sendIndexOperationToAllNodes(IndexOperation indexOperation) {
        LOG.debug("sendIndexOperationMessageToAllNodes indexOperation=" + indexOperation);
        try {
            String indexOperationAsJson = indexOperation.asJsonString();
            String thisNodeName = this.nodesInfo.getLocalNodeName();
            for (NodeInfo nodeInfo : this.getAllNodes()) {
                try {
                    URIBuilder uriBuilder = this.getURIBuilderForElasticsearchEndpoint(nodeInfo, "/_bpc/index_operation");
                    uriBuilder.setParameter("fromNode", thisNodeName);
                    this.postJsonMessage(uriBuilder.build(), indexOperationAsJson);
                }
                catch (Exception ex) {
                    LOG.error("Failed to send an IndexOperation to node: " + nodeInfo.getNode(), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to send an IndexOperation to all nodes.", (Throwable)ex);
        }
    }

    public void sendBroadcastMessageToAllNodes(String websocketId, String serverUUID, String topic, String broadcastMsg) {
        LOG.debug("sendBroadcastMessageToAllNodes websocketId=" + websocketId + ", serverUUID=" + serverUUID + ", topic=" + topic + ", broadcastMsg=" + broadcastMsg);
        try {
            String thisNodeName = this.nodesInfo.getLocalNodeName();
            for (NodeInfo nodeInfo : this.getAllNodes()) {
                try {
                    URIBuilder uriBuidler = this.getURIBuilderForElasticsearchEndpoint(nodeInfo, "/_bpc/broadcast");
                    uriBuidler.setParameter("fromNode", thisNodeName);
                    uriBuidler.setParameter("websocketId", websocketId);
                    uriBuidler.setParameter("serverUUID", serverUUID);
                    uriBuidler.setParameter("topic", topic);
                    this.postJsonMessage(uriBuidler.build(), broadcastMsg);
                }
                catch (Exception ex) {
                    LOG.error("Failed to broadcast to node: " + nodeInfo.getNode(), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to broadcast a message to all nodes.", (Throwable)ex);
        }
    }

    public void sendBpcConnectionAddedOrUpdatedToAllOtherNodes(BpcConnection connection) {
        LOG.debug("sendBpcConnectionAddedOrUpdatedToAllOtherNodes connection=" + connection);
        try {
            String thisNodeName = this.nodesInfo.getLocalNodeName();
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)new BytesStreamOutput());
            connection.addToBuilder(builder);
            String jsonMsg = Strings.toString((XContentBuilder)builder);
            for (NodeInfo nodeInfo : this.getAllNodes()) {
                String nodeName = nodeInfo.getNode().getName();
                if (nodeName.equals(thisNodeName)) continue;
                try {
                    URIBuilder uriBuilder = this.getURIBuilderForElasticsearchEndpoint(nodeInfo, "/_bpc/connection/added_or_updated");
                    uriBuilder.setParameter("fromNode", thisNodeName);
                    this.postJsonMessage(uriBuilder.build(), jsonMsg);
                }
                catch (Exception ex) {
                    LOG.error("Failed to send a connection added/updated message to node: " + nodeName, (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to send a connection added/updated message to all other nodes.", (Throwable)ex);
        }
    }

    public void sendBpcConnectionRemovedToAllOtherNodes(BpcConnection connection) {
        LOG.debug("sendBpcConnectionRemovedToAllOtherNodes connection=" + connection);
        try {
            String thisNodeName = this.nodesInfo.getLocalNodeName();
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)new BytesStreamOutput());
            connection.addToBuilder(builder);
            String jsonMsg = Strings.toString((XContentBuilder)builder);
            for (NodeInfo nodeInfo : this.getAllNodes()) {
                String nodeName = nodeInfo.getNode().getName();
                if (nodeName.equals(thisNodeName)) continue;
                try {
                    URIBuilder uriBuilder = this.getURIBuilderForElasticsearchEndpoint(nodeInfo, "/_bpc/connection/removed");
                    uriBuilder.setParameter("fromNode", thisNodeName);
                    this.postJsonMessage(uriBuilder.build(), jsonMsg);
                }
                catch (Exception ex) {
                    LOG.error("Failed to send a connection removed message to node: " + nodeName, (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to send a connection removed message to all other nodes.", (Throwable)ex);
        }
    }

    public void sendChangesFilterAddedToAllOtherNodes(String serverUUID, String index, boolean sendIndexEventsOnlyForModifiedSources) {
        LOG.debug("sendChangesFilterAddedToAllOtherNodes serverUUID=" + serverUUID + ", index=" + index + ", sendIndexEventsOnlyForModifiedSources=" + sendIndexEventsOnlyForModifiedSources);
        try {
            String thisNodeName = this.nodesInfo.getLocalNodeName();
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)new BytesStreamOutput());
            builder.startObject().field("serverUUID", serverUUID).field("index", index).field("sendIndexEventsOnlyForModifiedSources", sendIndexEventsOnlyForModifiedSources);
            builder.endObject();
            String jsonMsg = Strings.toString((XContentBuilder)builder);
            for (NodeInfo nodeInfo : this.getAllNodes()) {
                String nodeName = nodeInfo.getNode().getName();
                if (nodeName.equals(thisNodeName)) continue;
                try {
                    URIBuilder uriBuilder = this.getURIBuilderForElasticsearchEndpoint(nodeInfo, "/_bpc/changesfilter/add");
                    uriBuilder.setParameter("fromNode", thisNodeName);
                    this.postJsonMessage(uriBuilder.build(), jsonMsg);
                }
                catch (Exception ex) {
                    LOG.error("Failed to send a add changes filter message to node: " + nodeName, (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to send a add changes filter message to all other nodes.", (Throwable)ex);
        }
    }

    public void sendRemoveAllChangesFiltersOfServerUUIDToAllOtherNodes(String serverUUID) {
        LOG.debug("sendRemoveAllChangesFiltersOfServerUUIDToAllOtherNodes serverUUID=" + serverUUID);
        try {
            String thisNodeName = this.nodesInfo.getLocalNodeName();
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)new BytesStreamOutput());
            builder.startObject().field("serverUUID", serverUUID);
            builder.endObject();
            String jsonMsg = Strings.toString((XContentBuilder)builder);
            for (NodeInfo nodeInfo : this.getAllNodes()) {
                String nodeName = nodeInfo.getNode().getName();
                if (nodeName.equals(thisNodeName)) continue;
                try {
                    URIBuilder uriBuilder = this.getURIBuilderForElasticsearchEndpoint(nodeInfo, "/_bpc/changesfilter/removeall");
                    uriBuilder.setParameter("fromNode", thisNodeName);
                    this.postJsonMessage(uriBuilder.build(), jsonMsg);
                }
                catch (Exception ex) {
                    LOG.error("Failed to send a remove all changes filter message to node: " + nodeName, (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to send a remove all changes filter message to all other nodes.", (Throwable)ex);
        }
    }

    public void sendRemoveChangesFilterToAllOtherNodes(String serverUUID, String index) {
        LOG.debug("sendRemoveChangesFilterToAllOtherNodes serverUUID=" + serverUUID + ", index=" + index);
        try {
            String thisNodeName = this.nodesInfo.getLocalNodeName();
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)new BytesStreamOutput());
            builder.startObject().field("serverUUID", serverUUID).field("index", index);
            builder.endObject();
            String jsonMsg = Strings.toString((XContentBuilder)builder);
            for (NodeInfo nodeInfo : this.getAllNodes()) {
                String nodeName = nodeInfo.getNode().getName();
                if (nodeName.equals(thisNodeName)) continue;
                try {
                    URIBuilder uriBuilder = this.getURIBuilderForElasticsearchEndpoint(nodeInfo, "/_bpc/changesfilter/remove");
                    uriBuilder.setParameter("fromNode", thisNodeName);
                    this.postJsonMessage(uriBuilder.build(), jsonMsg);
                }
                catch (Exception ex) {
                    LOG.error("Failed to send a remove changes filter message to node: " + nodeName, (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to send a remove changes filter message to all other nodes.", (Throwable)ex);
        }
    }

    private void postJsonMessage(final URI uri, final String jsonMsg) throws Exception {
        LOG.debug("postJsonMessage uri=" + uri + ", jsonMsg=" + jsonMsg);
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                CloseableHttpClient client;
                String basicAuthUsername = NodeBroadcaster.this.settings.get("es-bpc-plugin.basicauth.username", "");
                String basicAuthPassword = NodeBroadcaster.this.settings.get("es-bpc-plugin.basicauth.password", "");
                if (basicAuthUsername != null && basicAuthUsername.trim().length() > 0) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(basicAuthUsername, basicAuthPassword);
                    BasicCredentialsProvider provider = new BasicCredentialsProvider();
                    provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                    client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
                } else {
                    client = HttpClientBuilder.create().build();
                }
                try {
                    HttpPost httpPost = new HttpPost(uri);
                    httpPost.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
                    httpPost.setHeader("User-Agent", "es-bpc-plugin");
                    httpPost.setHeader("Content-Type", "application/json");
                    CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new Exception("Failed to POST the message '" + jsonMsg + "' to '" + uri + "'. Received the response code '" + response.getStatusLine().getStatusCode() + "' and message '" + EntityUtils.toString((HttpEntity)response.getEntity()) + "'.");
                    }
                    CloseableHttpResponse closeableHttpResponse = response;
                    return closeableHttpResponse;
                }
                catch (Exception ex) {
                    Exception exception = ex;
                    return exception;
                }
                finally {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
        if (result instanceof Exception) {
            throw (Exception)result;
        }
    }

    public void httpPutJsonToLocalNode(final String path, final Map<String, String> params, final String jsonMsg) throws Exception {
        LOG.debug("httpPutJsonToLocalNode path=" + path + ", params=" + params + ", jsonMsg=" + jsonMsg);
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                try {
                    NodeInfo nodeInfo = NodeBroadcaster.this.getLocalNodeInfo();
                    URIBuilder uriBuilder = NodeBroadcaster.this.getURIBuilderForElasticsearchEndpoint(nodeInfo, path);
                    if (params != null) {
                        for (String paramName : params.keySet()) {
                            String paramValue = (String)params.get(paramName);
                            uriBuilder.setParameter(paramName, paramValue);
                        }
                    }
                    URI uri = uriBuilder.build();
                    LOG.debug("httpPutJsonToLocalNode uri = " + uri);
                    HttpPut httpPut = new HttpPut(uri);
                    httpPut.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
                    httpPut.setHeader("User-Agent", "es-bpc-plugin");
                    httpPut.setHeader("Content-Type", "application/json");
                    CloseableHttpResponse response = client.execute((HttpUriRequest)httpPut);
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new Exception("Failed to HTTP PUT the message '" + jsonMsg + "' to '" + uri + "'. Received the response code '" + response.getStatusLine().getStatusCode() + "' and message '" + EntityUtils.toString((HttpEntity)response.getEntity()) + "'.");
                    }
                    CloseableHttpResponse closeableHttpResponse = response;
                    return closeableHttpResponse;
                }
                catch (Exception ex) {
                    Exception exception = ex;
                    return exception;
                }
                finally {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
        if (result instanceof Exception) {
            throw (Exception)result;
        }
    }
}

