/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DateRangeHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public final class DateHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource> {
    private final long offset;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final ExtendedBounds extendedBounds;
    private final Rounding rounding;
    private final Rounding shardRounding;

    public DateHistogramAggregatorFactory(String name, ValuesSourceConfig<ValuesSource> config, long offset, BucketOrder order, boolean keyed, long minDocCount, Rounding rounding, Rounding shardRounding, ExtendedBounds extendedBounds, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metaData);
        this.offset = offset;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.rounding = rounding;
        this.shardRounding = shardRounding;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected ValuesSource resolveMissingAny(Object missing) {
        if (missing instanceof Number) {
            return ValuesSource.Numeric.EMPTY;
        }
        throw new IllegalArgumentException("Only numeric missing values are supported for date histogram aggregation, found [" + missing + "]");
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return DateHistogramAggregatorFactory.asMultiBucketAggregator(this, searchContext, parent);
        }
        if (valuesSource instanceof ValuesSource.Numeric) {
            return this.createAggregator((ValuesSource.Numeric)valuesSource, searchContext, parent, pipelineAggregators, metaData);
        }
        if (valuesSource instanceof ValuesSource.Range) {
            ValuesSource.Range rangeValueSource = (ValuesSource.Range)valuesSource;
            if (rangeValueSource.rangeType() != RangeType.DATE) {
                throw new IllegalArgumentException("Expected date range type but found range type [" + rangeValueSource.rangeType().name + "]");
            }
            return this.createRangeAggregator((ValuesSource.Range)valuesSource, searchContext, parent, pipelineAggregators, metaData);
        }
        throw new IllegalArgumentException("Expected one of [Date, Range] values source, found [" + valuesSource.toString() + "]");
    }

    private Aggregator createAggregator(ValuesSource.Numeric valuesSource, SearchContext searchContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new DateHistogramAggregator(this.name, this.factories, this.rounding, this.shardRounding, this.offset, this.order, this.keyed, this.minDocCount, this.extendedBounds, valuesSource, this.config.format(), searchContext, parent, pipelineAggregators, metaData);
    }

    private Aggregator createRangeAggregator(ValuesSource.Range valuesSource, SearchContext searchContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new DateRangeHistogramAggregator(this.name, this.factories, this.rounding, this.shardRounding, this.offset, this.order, this.keyed, this.minDocCount, this.extendedBounds, valuesSource, this.config.format(), searchContext, parent, pipelineAggregators, metaData);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return this.createAggregator(null, searchContext, parent, pipelineAggregators, metaData);
    }
}

