/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class EMapInit
extends AExpression {
    private final List<AExpression> keys;
    private final List<AExpression> values;
    private PainlessConstructor constructor = null;
    private PainlessMethod method = null;

    public EMapInit(Location location, List<AExpression> keys, List<AExpression> values) {
        super(location);
        this.keys = keys;
        this.values = values;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        for (AExpression key : this.keys) {
            key.storeSettings(settings);
        }
        for (AExpression value : this.values) {
            value.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression key : this.keys) {
            key.extractVariables(variables);
        }
        for (AExpression value : this.values) {
            value.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        AExpression expression;
        int index;
        if (!this.read) {
            throw this.createError(new IllegalArgumentException("Must read from map initializer."));
        }
        this.actual = HashMap.class;
        this.constructor = scriptRoot.getPainlessLookup().lookupPainlessConstructor(this.actual, 0);
        if (this.constructor == null) {
            throw this.createError(new IllegalArgumentException("constructor [" + PainlessLookupUtility.typeToCanonicalTypeName(this.actual) + ", <init>/0] not found"));
        }
        this.method = scriptRoot.getPainlessLookup().lookupPainlessMethod(this.actual, false, "put", 2);
        if (this.method == null) {
            throw this.createError(new IllegalArgumentException("method [" + PainlessLookupUtility.typeToCanonicalTypeName(this.actual) + ", put/2] not found"));
        }
        if (this.keys.size() != this.values.size()) {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        for (index = 0; index < this.keys.size(); ++index) {
            expression = this.keys.get(index);
            expression.expected = def.class;
            expression.internal = true;
            expression.analyze(scriptRoot, locals);
            this.keys.set(index, expression.cast(scriptRoot, locals));
        }
        for (index = 0; index < this.values.size(); ++index) {
            expression = this.values.get(index);
            expression.expected = def.class;
            expression.internal = true;
            expression.analyze(scriptRoot, locals);
            this.values.set(index, expression.cast(scriptRoot, locals));
        }
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        methodWriter.newInstance(MethodWriter.getType(this.actual));
        methodWriter.dup();
        methodWriter.invokeConstructor(Type.getType(this.constructor.javaConstructor.getDeclaringClass()), Method.getMethod(this.constructor.javaConstructor));
        for (int index = 0; index < this.keys.size(); ++index) {
            AExpression key = this.keys.get(index);
            AExpression value = this.values.get(index);
            methodWriter.dup();
            key.write(classWriter, methodWriter, globals);
            value.write(classWriter, methodWriter, globals);
            methodWriter.invokeMethodCall(this.method);
            methodWriter.pop();
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.pairwiseToString(this.keys, this.values));
    }
}

