/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.config.command.completers.ConfigurationCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.service.cm.Configuration;

@Command(scope="config", name="edit", description="Creates or edits a configuration.", detailedDescription="classpath:edit.txt")
@Service
public class EditCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="pid", description="PID of the configuration or of the factory if --factory is given. Pid can also be specified as ldap query", required=true, multiValued=false)
    @Completion(value=ConfigurationCompleter.class)
    String pid;
    @Option(name="--force", aliases={}, description="Force the edition of this config, even if another one was under edition", required=false, multiValued=false)
    boolean force;
    @Option(name="--factory", aliases={}, description="Define this config as a factory config. Will be created on calling update", required=false, multiValued=false)
    boolean factory;
    @Option(name="--alias", aliases={}, description="Specifies the alias used for this factory config.", required=false, multiValued=false)
    String alias;
    @Option(name="--type", aliases={}, description="Specifies the configuration storage type (cfg or json).", required=false, multiValued=false)
    String suffix;

    @Override
    protected Object doExecute() throws Exception {
        String oldPid = (String)this.session.get("ConfigCommand.PID");
        if (oldPid != null && !oldPid.equals(this.pid) && !this.force) {
            System.err.println("Another config is being edited.  Cancel / update first, or use the --force option");
            return null;
        }
        if (this.pid.startsWith("(")) {
            Configuration[] configs = this.configRepository.getConfigAdmin().listConfigurations(this.pid);
            if (configs == null) {
                throw new RuntimeException("No config found");
            }
            if (configs.length == 0) {
                throw new RuntimeException("Filter matches no config");
            }
            if (configs.length > 1) {
                throw new RuntimeException("Filter matches more than one config");
            }
            this.pid = configs[0].getPid();
            System.out.println("Editing config " + this.pid);
        }
        if (!this.factory && this.alias != null) {
            System.err.println("The --alias only works in case of a factory configuration. Add the --factory option.");
        }
        TypedProperties props = this.configRepository.getConfig(this.pid);
        this.session.put("ConfigCommand.PID", (Object)this.pid);
        this.session.put("ConfigCommand.Factory", (Object)this.factory);
        if (this.suffix == null) {
            this.suffix = "cfg";
        }
        this.session.put("ConfigCommand.Type", (Object)this.suffix);
        this.session.put("ConfigCommand.Props", (Object)props);
        if (this.alias != null) {
            this.session.put("ConfigCommand.Alias", (Object)this.alias);
        }
        return null;
    }
}

