/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.NodeBroadcaster;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;

@ServerEndpoint(value="/_bpc")
public class WebSocket {
    private static final Logger LOG = Loggers.getLogger(WebSocket.class, (String[])new String[]{"es-bpc-plugin"});
    private Session session;
    private NodeBroadcaster nodeBroadcaster;

    public void setNodeBroadcaster(NodeBroadcaster nodeBroadcaster) {
        LOG.debug("setNodeBroadcaster: " + nodeBroadcaster);
        this.nodeBroadcaster = nodeBroadcaster;
    }

    @OnOpen
    public void onOpen(Session session) {
        LOG.info("onOpen " + session.getId());
        this.session = session;
        Manager.getInstance().registerWebSocket(this);
    }

    @OnClose
    public void onClose(CloseReason reason) {
        LOG.info("onClose " + reason);
        Manager.getInstance().unregisterWebSocket(this.getId());
        this.session = null;
    }

    @OnError
    public void onError(Throwable t) {
        LOG.error("onError " + (this.session == null ? null : this.session.getId()), t);
    }

    @OnMessage
    public void onMessage(String message) {
        LOG.debug("onMessage " + message);
        if (message == null || message.trim().length() <= 0) {
            return;
        }
        String websocketId = this.getId();
        if (message.startsWith("ServerStateInfo:::")) {
            String extractedMsg = message.substring("ServerStateInfo:::".length());
            Manager.getInstance().serverStateInfoWebsocketMessageReceived(websocketId, extractedMsg);
            return;
        }
        if (message.startsWith("ServerLoadedModules:::")) {
            String extractedMsg = message.substring("ServerLoadedModules:::".length());
            Manager.getInstance().serverLoadedModulesWebsocketMessageReceived(websocketId, extractedMsg);
            return;
        }
        if (message.startsWith("[BROADCAST_TO_ALL]")) {
            String extractedMsg = message.substring("[BROADCAST_TO_ALL]".length());
            String serverUUID = Manager.getInstance().getConnections().getServerUUIDForWebsocketId(websocketId);
            this.nodeBroadcaster.sendBroadcastMessageToAllNodes(websocketId, serverUUID, "broadcast_to_all", extractedMsg);
            return;
        }
        if (message.startsWith("[BROADCAST_TO_ALL_EXCEPT_SENDER]")) {
            String extractedMsg = message.substring("[BROADCAST_TO_ALL_EXCEPT_SENDER]".length());
            String serverUUID = Manager.getInstance().getConnections().getServerUUIDForWebsocketId(websocketId);
            this.nodeBroadcaster.sendBroadcastMessageToAllNodes(websocketId, serverUUID, "broadcast_to_all_except_sender", extractedMsg);
            return;
        }
        if (message.startsWith("[BROADCAST_TO]")) {
            String extractedMsg = message.substring("[BROADCAST_TO]".length());
            String serverUUID = Manager.getInstance().getConnections().getServerUUIDForWebsocketId(websocketId);
            this.nodeBroadcaster.sendBroadcastMessageToAllNodes(websocketId, serverUUID, "broadcast_to", extractedMsg);
            return;
        }
        String serverUUID = Manager.getInstance().getConnections().getServerUUIDForWebsocketId(websocketId);
        this.nodeBroadcaster.sendBroadcastMessageToAllNodes(websocketId, serverUUID, "broadcast_to_all", message);
    }

    public String getId() {
        return this.session == null ? null : this.session.getId();
    }

    public void sendMessageAsync(String message) {
        this.session.getAsyncRemote().sendText(message);
    }
}

