/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.ServerStateInfo;
import de.virtimo.bpc.elasticsearch.plugin.WebSocket;
import de.virtimo.bpc.elasticsearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class BpcConnection {
    private static final Logger LOG = Loggers.getLogger(BpcConnection.class, (String[])new String[]{"es-bpc-plugin"});
    private String connectedtNode;
    private String websocketId;
    private WebSocket webSocket;
    private ServerStateInfo serverStateInfo;
    private String serverLoadedModules;
    private long modifiedAtUtcMilli;

    private BpcConnection() {
    }

    public BpcConnection(String connectedtNode, String websocketId) {
        this.connectedtNode = connectedtNode;
        this.websocketId = websocketId;
        this.webSocket = null;
        this.serverStateInfo = null;
        this.serverLoadedModules = null;
        this.modifiedAtUtcMilli = TimestampUtil.getNowInUtcEpochMilli();
    }

    public BpcConnection(String connectedtNode, WebSocket webSocket) {
        this.connectedtNode = connectedtNode;
        this.websocketId = webSocket.getId();
        this.webSocket = webSocket;
        this.serverStateInfo = null;
        this.serverLoadedModules = null;
        this.modifiedAtUtcMilli = TimestampUtil.getNowInUtcEpochMilli();
    }

    public BpcConnection(Map<String, Object> map) {
        this.connectedtNode = (String)map.get("connectedtNode");
        this.websocketId = (String)map.get("websocketId");
        this.webSocket = null;
        this.serverStateInfo = map.get("serverStateInfo") instanceof Map ? new ServerStateInfo((Map)map.get("serverStateInfo")) : null;
        this.serverLoadedModules = (String)map.get("serverLoadedModules");
        this.modifiedAtUtcMilli = (Long)map.get("modifiedAtUtcMilli");
    }

    public String getConnectedtNode() {
        return this.connectedtNode;
    }

    public String getWebsocketId() {
        return this.websocketId;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public ServerStateInfo getServerStateInfo() {
        return this.serverStateInfo;
    }

    public boolean setServerStateInfo(ServerStateInfo serverStateInfo) {
        if (this.serverStateInfo == null && serverStateInfo == null) {
            return false;
        }
        if (this.serverStateInfo != null && serverStateInfo != null && this.serverStateInfo.equals(serverStateInfo)) {
            return false;
        }
        this.serverStateInfo = serverStateInfo;
        this.modifiedAtUtcMilli = TimestampUtil.getNowInUtcEpochMilli();
        return true;
    }

    public String getServerLoadedModules() {
        return this.serverLoadedModules;
    }

    public boolean setServerLoadedModules(String serverLoadedModules) {
        if (this.serverLoadedModules == null && serverLoadedModules == null) {
            return false;
        }
        if (this.serverLoadedModules != null && serverLoadedModules != null && this.serverLoadedModules.equals(serverLoadedModules)) {
            return false;
        }
        this.serverLoadedModules = serverLoadedModules;
        this.modifiedAtUtcMilli = TimestampUtil.getNowInUtcEpochMilli();
        return true;
    }

    public long getModifiedAtUtcMilli() {
        return this.modifiedAtUtcMilli;
    }

    public LocalDateTime getModifiedAt() {
        return TimestampUtil.asLocalDateTime(this.modifiedAtUtcMilli);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BpcConnection that = (BpcConnection)o;
        return Objects.equals(this.connectedtNode, that.connectedtNode) && Objects.equals(this.websocketId, that.websocketId);
    }

    public int hashCode() {
        return Objects.hash(this.connectedtNode, this.websocketId);
    }

    public void addToBuilder(XContentBuilder builder) throws IOException {
        builder.startObject().field("connectedtNode", this.connectedtNode).field("websocketId", this.websocketId).field("serverStateInfo", this.serverStateInfo == null ? null : this.serverStateInfo.asMap()).field("serverLoadedModules", this.serverLoadedModules).field("modifiedAtUtcMilli", this.modifiedAtUtcMilli);
        builder.endObject();
    }

    public String toString() {
        return "BpcConnection{connectedtNode=" + this.connectedtNode + ", websocketId=" + this.websocketId + ", webSocket=" + this.webSocket + ", serverStateInfo=" + this.serverStateInfo + ", serverLoadedModules=" + this.serverLoadedModules + ", modifiedAtUtcMilli=" + this.modifiedAtUtcMilli + "}";
    }
}

