/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.BpcConnection;
import de.virtimo.bpc.elasticsearch.plugin.BpcConnections;
import de.virtimo.bpc.elasticsearch.plugin.BpcPlugin;
import de.virtimo.bpc.elasticsearch.plugin.ChangesFilters;
import de.virtimo.bpc.elasticsearch.plugin.ClusterMessage;
import de.virtimo.bpc.elasticsearch.plugin.ClusterSettings;
import de.virtimo.bpc.elasticsearch.plugin.MasterServerInfo;
import de.virtimo.bpc.elasticsearch.plugin.NodeBroadcaster;
import de.virtimo.bpc.elasticsearch.plugin.NodesInfo;
import de.virtimo.bpc.elasticsearch.plugin.ServerStateInfo;
import de.virtimo.bpc.elasticsearch.plugin.WebSocket;
import de.virtimo.bpc.elasticsearch.plugin.utils.JsonUtil;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.websocket.DeploymentException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.glassfish.tyrus.server.Server;

public class Manager
extends AbstractLifecycleComponent {
    private static final Logger LOG = Loggers.getLogger(Manager.class, (String[])new String[]{"es-bpc-plugin"});
    private static Manager INSTANCE = null;
    private NodeBroadcaster nodeBroadcaster;
    private ClusterSettings clusterSettings;
    private NodesInfo nodesInfo;
    private MasterServerInfo masterServerInfo;
    private BpcConnections connections;
    private ChangesFilters changesFilters;

    @Inject
    public Manager(Settings settings, NodeBroadcaster nodeBroadcaster, ClusterSettings clusterSettings, NodesInfo nodesInfo) {
        LOG.debug("Manager settings=" + settings + ", nodeBroadcaster=" + nodeBroadcaster + ", clusterSettings=" + clusterSettings + ", nodesInfo=" + nodesInfo);
        this.nodeBroadcaster = nodeBroadcaster;
        this.clusterSettings = clusterSettings;
        this.nodesInfo = nodesInfo;
        this.masterServerInfo = null;
        this.connections = new BpcConnections(clusterSettings);
        this.changesFilters = new ChangesFilters(clusterSettings);
        int port = settings.getAsInt("es-bpc-plugin.websocket.port", BpcPlugin.DEFAULT_WEBSOCKET_PORT);
        final Server server = new Server("localhost", port, "/ws", null, new Class[]{WebSocket.class});
        try {
            LOG.info("Starting WebSocket server");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        server.start();
                        return null;
                    }
                    catch (DeploymentException e) {
                        throw new RuntimeException("Failed to start server", e);
                    }
                }
            });
            LOG.info("WebSocket server started");
        }
        catch (Exception e) {
            LOG.error("Failed to start WebSocket server. Please restart Elasticsearch to try it again or check why it is not possible to start a websocket server on port '" + port + "'.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Manager getInstance() {
        return INSTANCE;
    }

    protected void doStart() {
        INSTANCE = this;
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }

    public MasterServerInfo getMasterServerInfo() {
        return this.masterServerInfo;
    }

    public BpcConnections getConnections() {
        return this.connections;
    }

    public ChangesFilters getChangesFilters() {
        return this.changesFilters;
    }

    public NodeBroadcaster getNodeBroadcaster() {
        return this.nodeBroadcaster;
    }

    public void registerWebSocket(WebSocket webSocket) {
        LOG.debug("registerWebSocket webSocket=" + webSocket);
        String thisNodeName = this.nodesInfo.getLocalNodeName();
        webSocket.setNodeBroadcaster(this.nodeBroadcaster);
        BpcConnection connection = this.connections.addConnection(thisNodeName, webSocket);
        if (this.nodesInfo.isThisNodeTheMasterNode(thisNodeName)) {
            this.connections.writeConnectionsSetting();
        }
        this.nodeBroadcaster.sendBpcConnectionAddedOrUpdatedToAllOtherNodes(connection);
    }

    public void unregisterWebSocket(String webSocketId) {
        LOG.debug("unregisterWebSocket webSocketId=" + webSocketId);
        BpcConnection existingConnection = this.connections.getConnectionByWebsocketId(webSocketId);
        this._unregisterConnection(existingConnection);
    }

    private void _unregisterConnection(BpcConnection existingConnection) {
        LOG.info("_unregisterConnection existingConnection=" + existingConnection);
        String unregisteredServerUUID = null;
        if (existingConnection != null) {
            boolean masterNode = this.nodesInfo.isThisNodeTheMasterNode();
            ServerStateInfo serverStateInfo = existingConnection.getServerStateInfo();
            if (serverStateInfo != null && this.changesFilters.removeAll(unregisteredServerUUID = serverStateInfo.getServerUUID())) {
                if (masterNode) {
                    this.changesFilters.writeFiltersSetting();
                }
                this.nodeBroadcaster.sendRemoveAllChangesFiltersOfServerUUIDToAllOtherNodes(unregisteredServerUUID);
            }
            if (this.connections.removeConnection(existingConnection)) {
                if (masterNode) {
                    this.connections.writeConnectionsSetting();
                }
                this.nodeBroadcaster.sendBpcConnectionRemovedToAllOtherNodes(existingConnection);
            }
        }
        if (this.masterServerInfo == null || this.masterServerInfo.getServerUUID().equals(unregisteredServerUUID)) {
            try {
                this.setNextAvailableServerAsMaster();
            }
            catch (Exception ex) {
                LOG.error("Failed to set next available server as the new master server.", (Throwable)ex);
            }
        }
    }

    public void unregisterRemovedElasticsearchNodes(Set<String> namesOfRemovedNodes) {
        LOG.debug("unregisterRemovedElasticsearchNodes namesOfRemovedNodes=" + namesOfRemovedNodes);
        List<BpcConnection> connectionsToUnregister = this.connections.getConnectionsByElasticsearchNodeNames(namesOfRemovedNodes);
        for (BpcConnection connectionToUnregister : connectionsToUnregister) {
            this._unregisterConnection(connectionToUnregister);
        }
    }

    public void serverStateInfoWebsocketMessageReceived(String websocketId, String serverStateInfoMessage) {
        LOG.debug("serverStateInfoWebsocketMessageReceived websocketId=" + websocketId + ", serverStateInfoMessage=" + serverStateInfoMessage);
        if (serverStateInfoMessage != null && serverStateInfoMessage.length() > 0) {
            BpcConnection connection = this.connections.getConnectionByWebsocketId(websocketId);
            if (connection != null) {
                try {
                    Map<String, Object> serverStateInfoMessageAsMap = JsonUtil.asMap(serverStateInfoMessage);
                    ServerStateInfo serverStateInfo = new ServerStateInfo(serverStateInfoMessageAsMap);
                    connection.setServerStateInfo(serverStateInfo);
                }
                catch (Exception ex) {
                    LOG.error("Failed to convert the given serverStateInfoMessage to JSON: " + serverStateInfoMessage, (Throwable)ex);
                }
                if (this.nodesInfo.isThisNodeTheMasterNode()) {
                    this.connections.writeConnectionsSetting();
                }
                this.nodeBroadcaster.sendBpcConnectionAddedOrUpdatedToAllOtherNodes(connection);
                if (this.masterServerInfo == null) {
                    try {
                        this.setNextAvailableServerAsMaster();
                    }
                    catch (Exception ex) {
                        LOG.error("Failed to set next available server as the new master server.", (Throwable)ex);
                    }
                }
            } else {
                LOG.warn("There must be something wrong. Received a server state info websocket message, but there is no websocket session registered on this node.");
            }
        }
    }

    public void serverLoadedModulesWebsocketMessageReceived(String websocketId, String loadedModulesMessage) {
        LOG.debug("serverLoadedModulesWebsocketMessageReceived websocketId=" + websocketId + ", loadedModulesMessage=" + loadedModulesMessage);
        if (loadedModulesMessage != null) {
            BpcConnection connection = this.connections.getConnectionByWebsocketId(websocketId);
            if (connection != null) {
                connection.setServerLoadedModules(loadedModulesMessage);
                if (this.nodesInfo.isThisNodeTheMasterNode()) {
                    this.connections.writeConnectionsSetting();
                }
                this.nodeBroadcaster.sendBpcConnectionAddedOrUpdatedToAllOtherNodes(connection);
            } else {
                LOG.warn("There must be something wrong. Received a server loaded modules websocket message, but there is no websocket session registered on this node.");
            }
        }
    }

    private void setNextAvailableServerAsMaster() {
        LOG.debug("setNextAvailableServerAsMaster");
        for (BpcConnection connection : this.connections.getAll()) {
            ServerStateInfo serverStateInfo = connection.getServerStateInfo();
            if (serverStateInfo == null || serverStateInfo.isMaintenanceModeEnabled() || serverStateInfo.isReplicationEnabled()) continue;
            LOG.debug("setNextAvailableServerAsMaster serverStateInfo=" + serverStateInfo);
            this.writeMasterServerInfoSetting(serverStateInfo.getServerUUID());
            return;
        }
        LOG.info("setNextAvailableServerAsMaster: There is no BPC server available");
        this.writeMasterServerInfoSetting("<<NONE>>");
    }

    public void writeMasterServerInfoSetting(String serverUUID) {
        LOG.debug("writeMasterServerInfoSetting serverUUID=" + serverUUID);
        try {
            MasterServerInfo masterServerInfo = new MasterServerInfo(serverUUID);
            this.clusterSettings.setTransientSetting("masterServer", masterServerInfo.asJsonString());
        }
        catch (Exception ex) {
            LOG.error("Failed to set the transient cluster setting 'masterServer'.", (Throwable)ex);
        }
    }

    public void processMasterServerInfoSetting(MasterServerInfo masterServerInfo) {
        LOG.debug("processMasterServerInfoSetting masterServerInfo=" + masterServerInfo);
        if (masterServerInfo == null || masterServerInfo.getServerUUID().equals("<<NONE>>")) {
            this.masterServerInfo = null;
            LOG.info("No more master server");
        } else if (!masterServerInfo.equals(this.masterServerInfo)) {
            this.masterServerInfo = masterServerInfo;
            ClusterMessage clusterMessage = new ClusterMessage("SetAsMaster", masterServerInfo.getServerUUID());
            LOG.info("Setting the BPC server with the following UUID as master: " + masterServerInfo.getServerUUID());
            this.connections.sendWebsocketMessage("ClusterMessage:::" + clusterMessage.asJsonString(), null);
        }
    }

    public void processAddedOrUpdatedConnection(BpcConnection connection) {
        LOG.debug("processAddedOrUpdatedConnection connection=" + connection);
        if (connection != null) {
            this.connections.addOrUpdateConnection(connection);
            if (this.nodesInfo.isThisNodeTheMasterNode()) {
                this.connections.writeConnectionsSetting();
            }
        }
    }

    public void processRemovedConnection(BpcConnection connection) {
        BpcConnection existingConnection;
        LOG.debug("processRemovedConnection connection=" + connection);
        if (connection != null && (existingConnection = this.connections.getConnectionByWebsocketId(connection.getWebsocketId())) != null) {
            this.connections.removeConnection(existingConnection);
            if (this.nodesInfo.isThisNodeTheMasterNode()) {
                this.connections.writeConnectionsSetting();
            }
        }
    }

    public void addChangesFilter(String serverUUID, String index, boolean sendIndexEventsOnlyForModifiedSources, boolean informOtherNodes) {
        LOG.debug("addChangesFilter serverUUID=" + serverUUID + ", index=" + index + ", sendIndexEventsOnlyForModifiedSources=" + sendIndexEventsOnlyForModifiedSources + ", informOtherNodes=" + informOtherNodes);
        boolean added = this.changesFilters.add(serverUUID, index, sendIndexEventsOnlyForModifiedSources);
        if (added) {
            if (this.nodesInfo.isThisNodeTheMasterNode()) {
                this.changesFilters.writeFiltersSetting();
            }
            if (informOtherNodes) {
                this.nodeBroadcaster.sendChangesFilterAddedToAllOtherNodes(serverUUID, index, sendIndexEventsOnlyForModifiedSources);
            }
        }
    }

    public void removeAllChangesFiltersOfServerUUID(String serverUUID, boolean informOtherNodes) {
        LOG.debug("removeAllChangesFiltersOfServerUUID serverUUID=" + serverUUID + ", informOtherNodes=" + informOtherNodes);
        if (this.changesFilters.removeAll(serverUUID)) {
            if (this.nodesInfo.isThisNodeTheMasterNode()) {
                this.changesFilters.writeFiltersSetting();
            }
            if (informOtherNodes) {
                this.nodeBroadcaster.sendRemoveAllChangesFiltersOfServerUUIDToAllOtherNodes(serverUUID);
            }
        }
    }

    public boolean removeChangesFilter(String serverUUID, String index, boolean informOtherNodes) {
        LOG.debug("removeChangesFilter serverUUID=" + serverUUID + ", index=" + index + ", informOtherNodes=" + informOtherNodes);
        boolean removed = this.changesFilters.remove(serverUUID, index);
        if (removed) {
            if (this.nodesInfo.isThisNodeTheMasterNode()) {
                this.changesFilters.writeFiltersSetting();
            }
            if (informOtherNodes) {
                this.nodeBroadcaster.sendRemoveChangesFilterToAllOtherNodes(serverUUID, index);
            }
        }
        return removed;
    }

    public void processAddChangesFilter(String serverUUID, String index, boolean sendIndexEventsOnlyForModifiedSources) {
        LOG.debug("processAddChangesFilter serverUUID=" + serverUUID + ", index=" + index + ", sendIndexEventsOnlyForModifiedSources=" + sendIndexEventsOnlyForModifiedSources);
        this.addChangesFilter(serverUUID, index, sendIndexEventsOnlyForModifiedSources, false);
    }

    public void processRemoveAllChangesFilter(String serverUUID) {
        LOG.debug("processRemoveAllChangesFilter serverUUID=" + serverUUID);
        this.removeAllChangesFiltersOfServerUUID(serverUUID, false);
    }

    public void processRemoveChangesFilter(String serverUUID, String index) {
        LOG.debug("processRemoveChangesFilter serverUUID=" + serverUUID + ", index=" + index);
        this.removeChangesFilter(serverUUID, index, false);
    }
}

