/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.servers;

import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.ServerStateInfo;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestParamMissingException;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestUtil;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestSetMasterServerAction
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestSetMasterServerAction.class, (String[])new String[]{"es-bpc-plugin"});

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_bpc/servers/master"));
    }

    public String getName() {
        return "set_master_server_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        try {
            String serverUUID = RequestUtil.getMandatoryQueryParamAsString(request, "serverUUID");
            LOG.debug("serverUUID=" + serverUUID);
            Manager manager = Manager.getInstance();
            ServerStateInfo serverStateInfo = manager.getConnections().getServerStateInfoByServerUUID(serverUUID);
            if (serverStateInfo == null) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_FOUND, "Did not found a server with the UUID '" + serverUUID + "'."));
            }
            if (serverStateInfo.isMaintenanceModeEnabled()) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "The server with the UUID '" + serverUUID + "' is in maintenance and cannot be set as master server."));
            }
            if (serverStateInfo.isReplicationEnabled()) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "The server with the UUID '" + serverUUID + "' is already the master server."));
            }
            manager.writeMasterServerInfoSetting(serverUUID);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "OK"));
        }
        catch (RequestParamMissingException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, ex.getMessage()));
        }
    }
}

