/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.io.WriteAbortedException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2DefaultIoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.core.CoreModuleProperties;

public class Nio2Session
extends AbstractCloseable
implements IoSession {
    public static final int DEFAULT_READBUF_SIZE = 32768;
    private static final AtomicLong SESSION_ID_GENERATOR = new AtomicLong(100L);
    private final long id = SESSION_ID_GENERATOR.incrementAndGet();
    private final Nio2Service service;
    private final IoHandler ioHandler;
    private final AsynchronousSocketChannel socketChannel;
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final SocketAddress acceptanceAddress;
    private final PropertyResolver propertyResolver;
    private final Queue<Nio2DefaultIoWriteFuture> writes = new LinkedTransferQueue<Nio2DefaultIoWriteFuture>();
    private final AtomicReference<Nio2DefaultIoWriteFuture> currentWrite = new AtomicReference();
    private final AtomicLong readCyclesCounter = new AtomicLong();
    private final AtomicLong lastReadCycleStart = new AtomicLong();
    private final AtomicLong writeCyclesCounter = new AtomicLong();
    private final AtomicLong lastWriteCycleStart = new AtomicLong();
    private final Object suspendLock = new Object();
    private volatile boolean suspend;
    private volatile Runnable readRunnable;
    private Thread readerThread;

    public Nio2Session(Nio2Service service, PropertyResolver propertyResolver, IoHandler handler, AsynchronousSocketChannel socket, SocketAddress acceptanceAddress) throws IOException {
        this.service = Objects.requireNonNull(service, "No service instance");
        this.propertyResolver = Objects.requireNonNull(propertyResolver, "No property resolver");
        this.ioHandler = Objects.requireNonNull(handler, "No IoHandler");
        this.socketChannel = Objects.requireNonNull(socket, "No socket channel");
        this.localAddress = socket.getLocalAddress();
        this.remoteAddress = socket.getRemoteAddress();
        this.acceptanceAddress = acceptanceAddress;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating IoSession on {} from {} via {}", new Object[]{this.localAddress, this.remoteAddress, acceptanceAddress});
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(Object key) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttribute(Object key, Object value) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttributeIfAbsent(Object key, Object value) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.putIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeAttribute(Object key) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(key);
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getAcceptanceAddress() {
        return this.acceptanceAddress;
    }

    public AsynchronousSocketChannel getSocket() {
        return this.socketChannel;
    }

    public IoHandler getIoHandler() {
        return this.ioHandler;
    }

    public void suspend() {
        block4: {
            AsynchronousSocketChannel socket = this.getSocket();
            try {
                socket.shutdownInput();
            }
            catch (IOException e) {
                this.debug("suspend({}) failed ({}) to shutdown input: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            }
            try {
                socket.shutdownOutput();
            }
            catch (IOException e) {
                if (!this.log.isDebugEnabled()) break block4;
                this.debug("suspend({}) failed ({}) to shutdown output: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            }
        }
    }

    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("writeBuffer({}) writing {} bytes", (Object)this, (Object)buffer.available());
        }
        ByteBuffer buf = ByteBuffer.wrap(buffer.array(), buffer.rpos(), buffer.available());
        Nio2DefaultIoWriteFuture future = new Nio2DefaultIoWriteFuture(this.getRemoteAddress(), null, buf);
        if (this.isClosing()) {
            ClosedChannelException exc = new ClosedChannelException();
            future.setException(exc);
            this.exceptionCaught(exc);
            return future;
        }
        this.writes.add(future);
        this.startWriting();
        return future;
    }

    protected void exceptionCaught(Throwable exc) {
        if (this.closeFuture.isClosed()) {
            return;
        }
        AsynchronousSocketChannel socket = this.getSocket();
        if (this.isOpen() && socket.isOpen()) {
            IoHandler handler = this.getIoHandler();
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("exceptionCaught({}) caught {}[{}] - calling handler", new Object[]{this, exc.getClass().getSimpleName(), exc.getMessage()});
                }
                handler.exceptionCaught(this, exc);
            }
            catch (Throwable e) {
                Throwable t = ExceptionUtils.peelException(e);
                this.debug("exceptionCaught({}) Exception handler threw {}, closing the session: {}", this, t.getClass().getSimpleName(), t.getMessage(), t);
            }
        }
        this.close(true);
    }

    @Override
    protected CloseFuture doCloseGracefully() {
        String closeId = this.toString();
        return this.builder().when(closeId, this.writes).run(closeId, () -> {
            try {
                AsynchronousSocketChannel socket = this.getSocket();
                socket.shutdownOutput();
            }
            catch (IOException e) {
                this.info("doCloseGracefully({}) {} while shutting down output: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            }
        }).build().close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCloseImmediately() {
        Nio2DefaultIoWriteFuture future;
        boolean debugEnabled = this.log.isDebugEnabled();
        while ((future = this.writes.poll()) != null) {
            if (future.isWritten()) {
                if (!debugEnabled) continue;
                this.log.debug("doCloseImmediately({}) skip already written future={}", (Object)this, (Object)future);
                continue;
            }
            Throwable error = future.getException();
            if (error != null) continue;
            if (debugEnabled) {
                this.log.debug("doCloseImmediately({}) signal write abort for future={}", (Object)this, (Object)future);
            }
            future.setException(new WriteAbortedException("Write request aborted due to immediate session close", null));
        }
        AsynchronousSocketChannel socket = this.getSocket();
        try {
            if (debugEnabled) {
                this.log.debug("doCloseImmediately({}) closing socket={}", (Object)this, (Object)socket);
            }
            socket.close();
            if (debugEnabled) {
                this.log.debug("doCloseImmediately({}) socket={} closed", (Object)this, (Object)socket);
            }
        }
        catch (IOException e) {
            this.debug("doCloseImmediately({}) {} caught while closing socket={}: {}", this, e.getClass().getSimpleName(), socket, e.getMessage(), e);
        }
        this.service.sessionClosed(this);
        super.doCloseImmediately();
        IoHandler handler = this.getIoHandler();
        try {
            handler.sessionClosed(this);
        }
        catch (Throwable e) {
            this.debug("doCloseImmediately({}) {} while calling IoHandler#sessionClosed: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
        }
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.clear();
        }
    }

    @Override
    public Nio2Service getService() {
        return this.service;
    }

    @Override
    public void shutdownOutputStream() throws IOException {
        AsynchronousSocketChannel socket = this.getSocket();
        if (socket.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("shudownOutputStream({})", (Object)this);
            }
            socket.shutdownOutput();
        }
    }

    public void startReading() {
        this.startReading(CoreModuleProperties.NIO2_READ_BUFFER_SIZE.getRequired(this.propertyResolver));
    }

    public void startReading(int bufSize) {
        this.startReading(new byte[bufSize]);
    }

    public void startReading(byte[] buf) {
        this.startReading(buf, 0, buf.length);
    }

    public void startReading(byte[] buf, int offset, int len) {
        this.startReading(ByteBuffer.wrap(buf, offset, len));
    }

    public void startReading(ByteBuffer buffer) {
        this.doReadCycle(buffer, Readable.readable(buffer));
    }

    protected void doReadCycle(ByteBuffer buffer, Readable bufReader) {
        Nio2CompletionHandler<Integer, Object> completion = Objects.requireNonNull(this.createReadCycleCompletionHandler(buffer, bufReader), "No completion handler created");
        this.doReadCycle(buffer, completion);
    }

    protected Nio2CompletionHandler<Integer, Object> createReadCycleCompletionHandler(final ByteBuffer buffer, final Readable bufReader) {
        return new Nio2CompletionHandler<Integer, Object>(){

            @Override
            protected void onCompleted(Integer result, Object attachment) {
                Nio2Session.this.readerThread = Thread.currentThread();
                try {
                    Nio2Session.this.handleReadCycleCompletion(buffer, bufReader, this, result, attachment);
                }
                finally {
                    Nio2Session.this.readerThread = null;
                }
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                Nio2Session.this.readerThread = null;
                Nio2Session.this.handleReadCycleFailure(buffer, bufReader, exc, attachment);
            }
        };
    }

    protected void handleReadCycleCompletion(ByteBuffer buffer, Readable bufReader, Nio2CompletionHandler<Integer, Object> completionHandler, Integer result, Object attachment) {
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            if (result >= 0) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("handleReadCycleCompletion({}) read {} bytes after {} nanos at cycle={}", new Object[]{this, result, System.nanoTime() - this.lastReadCycleStart.get(), this.readCyclesCounter});
                }
                buffer.flip();
                IoHandler handler = this.getIoHandler();
                handler.messageReceived(this, bufReader);
                if (!this.closeFuture.isClosed()) {
                    this.doReadCycle(buffer, completionHandler);
                } else if (debugEnabled) {
                    this.log.debug("handleReadCycleCompletion({}) IoSession has been closed, stop reading", (Object)this);
                }
            } else {
                if (debugEnabled) {
                    this.log.debug("handleReadCycleCompletion({}) Socket has been disconnected (result={}), closing IoSession now", (Object)this, (Object)result);
                }
                this.close(true);
            }
        }
        catch (Throwable exc) {
            completionHandler.failed(exc, attachment);
        }
    }

    protected void handleReadCycleFailure(ByteBuffer buffer, Readable bufReader, Throwable exc, Object attachment) {
        this.debug("handleReadCycleFailure({}) {} after {} nanos at read cycle={}: {}", this, exc.getClass().getSimpleName(), System.nanoTime() - this.lastReadCycleStart.get(), this.readCyclesCounter, exc.getMessage(), exc);
        this.exceptionCaught(exc);
    }

    @Override
    public void suspendRead() {
        this.log.trace("suspendRead({})", (Object)this);
        boolean prev = this.suspend;
        this.suspend = true;
        if (!prev) {
            this.log.debug("suspendRead({}) requesting read suspension", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeRead() {
        this.log.trace("resumeRead({})", (Object)this);
        if (this.suspend) {
            Runnable runnable;
            Object object = this.suspendLock;
            synchronized (object) {
                this.suspend = false;
                runnable = this.readRunnable;
                this.readRunnable = null;
            }
            if (runnable != null && !Thread.currentThread().equals(this.readerThread)) {
                this.log.debug("resumeRead({}) resuming read", (Object)this);
                this.service.getExecutorService().execute(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReadCycle(ByteBuffer buffer, Nio2CompletionHandler<Integer, Object> completion) {
        if (this.suspend) {
            this.log.debug("doReadCycle({}) suspending reading", (Object)this);
            Object object = this.suspendLock;
            synchronized (object) {
                if (this.suspend) {
                    this.readRunnable = () -> this.doReadCycle(buffer, completion);
                    return;
                }
            }
        }
        AsynchronousSocketChannel socket = this.getSocket();
        Duration readTimeout = CoreModuleProperties.NIO2_READ_TIMEOUT.getRequired(this.propertyResolver);
        this.readCyclesCounter.incrementAndGet();
        this.lastReadCycleStart.set(System.nanoTime());
        buffer.clear();
        socket.read(buffer, readTimeout.toMillis(), TimeUnit.MILLISECONDS, null, completion);
    }

    protected void startWriting() {
        Nio2DefaultIoWriteFuture future = this.writes.peek();
        if (future == null) {
            return;
        }
        if (!this.currentWrite.compareAndSet(null, future)) {
            return;
        }
        try {
            AsynchronousSocketChannel socket = this.getSocket();
            ByteBuffer buffer = future.getBuffer();
            Nio2CompletionHandler<Integer, Object> handler = Objects.requireNonNull(this.createWriteCycleCompletionHandler(future, socket, buffer), "No write cycle completion handler created");
            this.doWriteCycle(buffer, handler);
        }
        catch (Throwable e) {
            future.setWritten();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    protected void doWriteCycle(ByteBuffer buffer, Nio2CompletionHandler<Integer, Object> completion) {
        AsynchronousSocketChannel socket = this.getSocket();
        Duration writeTimeout = CoreModuleProperties.NIO2_MIN_WRITE_TIMEOUT.getRequired(this.propertyResolver);
        this.writeCyclesCounter.incrementAndGet();
        this.lastWriteCycleStart.set(System.nanoTime());
        socket.write(buffer, writeTimeout.toMillis(), TimeUnit.MILLISECONDS, null, completion);
    }

    protected Nio2CompletionHandler<Integer, Object> createWriteCycleCompletionHandler(final Nio2DefaultIoWriteFuture future, final AsynchronousSocketChannel socket, final ByteBuffer buffer) {
        final int writeLen = buffer.remaining();
        return new Nio2CompletionHandler<Integer, Object>(){

            @Override
            protected void onCompleted(Integer result, Object attachment) {
                Nio2Session.this.handleCompletedWriteCycle(future, socket, buffer, writeLen, this, result, attachment);
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                Nio2Session.this.handleWriteCycleFailure(future, socket, buffer, writeLen, exc, attachment);
            }
        };
    }

    protected void handleCompletedWriteCycle(Nio2DefaultIoWriteFuture future, AsynchronousSocketChannel socket, ByteBuffer buffer, int writeLen, Nio2CompletionHandler<Integer, Object> completionHandler, Integer result, Object attachment) {
        if (buffer.hasRemaining()) {
            try {
                socket.write(buffer, null, completionHandler);
            }
            catch (Throwable t) {
                this.debug("handleCompletedWriteCycle({}) {} while writing to socket len={}: {}", this, t.getClass().getSimpleName(), writeLen, t.getMessage(), t);
                future.setWritten();
                this.finishWrite(future);
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleCompletedWriteCycle({}) finished writing len={} at cycle={} after {} nanos", new Object[]{this, writeLen, this.writeCyclesCounter, System.nanoTime() - this.lastWriteCycleStart.get()});
            }
            this.writes.remove(future);
            future.setWritten();
            this.finishWrite(future);
        }
    }

    protected void handleWriteCycleFailure(Nio2DefaultIoWriteFuture future, AsynchronousSocketChannel socket, ByteBuffer buffer, int writeLen, Throwable exc, Object attachment) {
        block3: {
            if (this.log.isDebugEnabled()) {
                this.debug("handleWriteCycleFailure({}) failed ({}) to write {} bytes at write cycle={} afer {} nanos: {}", this, exc.getClass().getSimpleName(), writeLen, this.writeCyclesCounter, System.nanoTime() - this.lastWriteCycleStart.get(), exc.getMessage(), exc);
            }
            future.setException(exc);
            this.exceptionCaught(exc);
            try {
                this.finishWrite(future);
            }
            catch (RuntimeException e) {
                if (!this.log.isTraceEnabled()) break block3;
                this.log.trace("handleWriteCycleFailure({}) failed ({}) to finish writing: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
            }
        }
    }

    protected void finishWrite(Nio2DefaultIoWriteFuture future) {
        this.writes.remove(future);
        this.currentWrite.compareAndSet(future, null);
        this.startWriting();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", remote=" + this.getRemoteAddress() + "]";
    }
}

