/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.config;

import de.virtimo.bpc.elasticsearch.plugin.BpcPlugin;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestGetConfigAction
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestGetConfigAction.class, (String[])new String[]{"es-bpc-plugin"});
    private Settings settings;

    public RestGetConfigAction(Settings settings) {
        this.settings = settings;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_bpc/config"));
    }

    public String getName() {
        return "get_config_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        Properties props = new Properties();
        props.load(((Object)((Object)this)).getClass().getResourceAsStream("/plugin-descriptor.properties"));
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject().startObject("websocket").field("port", this.settings.getAsInt("es-bpc-plugin.websocket.port", BpcPlugin.DEFAULT_WEBSOCKET_PORT)).endObject().startObject("plugin").field("name", props.get("name")).field("version", props.get("version")).endObject().endObject();
        return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
    }
}

