/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.ChangesFilter;
import de.virtimo.bpc.elasticsearch.plugin.ClusterSettings;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class ChangesFilters {
    private static final Logger LOG = Loggers.getLogger(ChangesFilters.class, (String[])new String[]{"es-bpc-plugin"});
    private boolean initialized = false;
    private final ClusterSettings clusterSettings;
    private final Map<String, ChangesFilter> filters;

    public ChangesFilters(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
        this.filters = new HashMap<String, ChangesFilter>();
    }

    public boolean isInitialized() {
        LOG.debug("isInitialized");
        return this.initialized;
    }

    public Set<ChangesFilter> createChangesFilters(Map<String, Object> changesFiltersMap) {
        Object entries;
        LOG.debug("createChangesFilters changesFiltersMap=" + changesFiltersMap);
        HashSet<ChangesFilter> result = null;
        if (changesFiltersMap != null && (entries = changesFiltersMap.get("entries")) instanceof List) {
            result = new HashSet<ChangesFilter>();
            for (Object listEntry : (List)entries) {
                if (!(listEntry instanceof Map)) continue;
                ChangesFilter changesFilter = new ChangesFilter((Map)listEntry);
                result.add(changesFilter);
            }
        }
        return result;
    }

    public void processChangesFilters(Set<ChangesFilter> filters) {
        LOG.debug("processChangesFilters filters=" + filters);
        this.initialized = true;
        this.filters.clear();
        if (filters != null) {
            for (ChangesFilter filter : filters) {
                this.filters.put(filter.getKey(), filter);
            }
        }
    }

    public void writeFiltersSetting() {
        LOG.debug("writeFiltersSetting");
        try {
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)new BytesStreamOutput());
            builder.startObject();
            builder.startArray("entries");
            for (ChangesFilter changesFilter : new ArrayList<ChangesFilter>(this.filters.values())) {
                changesFilter.addToBuilder(builder);
            }
            builder.endArray();
            builder.endObject();
            this.clusterSettings.setTransientSetting("filters", Strings.toString((XContentBuilder)builder));
        }
        catch (Exception ex) {
            LOG.error("Failed to set the transient cluster setting 'filters'.", (Throwable)ex);
        }
    }

    public List<ChangesFilter> getAll(String serverUUID) {
        LOG.debug("getAll serverUUID=" + serverUUID);
        if (serverUUID == null) {
            return new ArrayList<ChangesFilter>(this.filters.values());
        }
        ArrayList<ChangesFilter> result = new ArrayList<ChangesFilter>();
        for (ChangesFilter filter : this.filters.values()) {
            if (!filter.belongsToServerUUID(serverUUID)) continue;
            result.add(filter);
        }
        return result;
    }

    public ChangesFilter getFilter(String index, Set<String> aliases) {
        LOG.debug("getFilter index=" + index + ", aliases=" + aliases);
        ChangesFilter indexFilter = this.filters.get(ChangesFilter.getKey(index));
        if (indexFilter != null) {
            return indexFilter;
        }
        if (aliases != null) {
            for (String alias : aliases) {
                ChangesFilter aliasFilter = this.filters.get(ChangesFilter.getKey(alias));
                if (aliasFilter == null) continue;
                return aliasFilter;
            }
        }
        return null;
    }

    public boolean add(String serverUUID, String index, boolean sendIndexEventsOnlyForModifiedSources) {
        LOG.debug("add serverUUID=" + serverUUID + ", index=" + index + ", sendIndexEventsOnlyForModifiedSources=" + sendIndexEventsOnlyForModifiedSources);
        boolean added = false;
        if (serverUUID != null && index != null) {
            String changesFilterKey = ChangesFilter.getKey(index);
            ChangesFilter existingFilter = this.filters.get(changesFilterKey);
            if (existingFilter == null) {
                ChangesFilter changesFilter = new ChangesFilter(index, sendIndexEventsOnlyForModifiedSources);
                changesFilter.addServerUUID(serverUUID);
                this.filters.put(changesFilterKey, changesFilter);
                added = true;
            } else if (existingFilter.addServerUUID(serverUUID)) {
                added = true;
            }
        }
        return added;
    }

    public boolean removeAll(String serverUUID) {
        LOG.debug("removeAll serverUUID=" + serverUUID);
        boolean removed = false;
        if (serverUUID != null) {
            HashSet<String> existingsKeys = new HashSet<String>(this.filters.keySet());
            for (String existingsKey : existingsKeys) {
                if (!this.removeByFilterKey(serverUUID, existingsKey)) continue;
                removed = true;
            }
        }
        return removed;
    }

    public boolean remove(String serverUUID, String index) {
        LOG.debug("remove serverUUID=" + serverUUID + ", index=" + index);
        boolean removed = false;
        if (index != null) {
            removed = this.removeByFilterKey(serverUUID, ChangesFilter.getKey(index));
        }
        return removed;
    }

    private boolean removeByFilterKey(String serverUUID, String changesFilterKey) {
        ChangesFilter existingFilter;
        LOG.debug("removeByFilterKey serverUUID=" + serverUUID + ", changesFilterKey=" + changesFilterKey);
        if (changesFilterKey != null && (existingFilter = this.filters.get(changesFilterKey)) != null) {
            existingFilter.removeServerUUID(serverUUID);
            if (!existingFilter.hasServerUUIDs()) {
                this.filters.remove(changesFilterKey);
            }
            return true;
        }
        return false;
    }
}

