/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.logging.Loggers;

public class NodesInfo
extends AbstractLifecycleComponent {
    private static final Logger LOG = Loggers.getLogger(NodesInfo.class, (String[])new String[]{"es-bpc-plugin"});
    private static NodesInfo INSTANCE = null;
    private final Provider<ClusterService> clusterServiceProvider;
    private final Provider<Client> clientProvider;

    @Inject
    public NodesInfo(Provider<ClusterService> clusterServiceProvider, Provider<Client> clientProvider) {
        LOG.debug("NodesInfo clusterServiceProvider=" + clusterServiceProvider + ", clientProvider=" + clientProvider);
        this.clusterServiceProvider = clusterServiceProvider;
        this.clientProvider = clientProvider;
    }

    public static NodesInfo getInstance() {
        return INSTANCE;
    }

    protected void doStart() {
        INSTANCE = this;
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }

    public String getLocalNodeName() throws NullPointerException {
        LOG.debug("getLocalNodeName");
        String thisNodeName = null;
        try {
            thisNodeName = ((ClusterService)this.clusterServiceProvider.get()).localNode().getName();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (thisNodeName == null) {
            throw new NullPointerException("Failed to get the name of the local node.");
        }
        return thisNodeName;
    }

    public boolean isThisNodeTheMasterNode() {
        LOG.debug("isThisNodeTheMasterNode");
        return this.isThisNodeTheMasterNode(this.getLocalNodeName());
    }

    public boolean isThisNodeTheMasterNode(String nodeName) {
        LOG.debug("isThisNodeTheMasterNode nodeName=" + nodeName);
        try {
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[]{"_master"}).clear();
            NodesInfoResponse nodeInfos = (NodesInfoResponse)((Client)this.clientProvider.get()).admin().cluster().nodesInfo(nodesInfoRequest).get();
            for (NodeInfo node : nodeInfos.getNodes()) {
                String masterNodeName = node.getNode().getName();
                if (!nodeName.equals(masterNodeName)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to check if the current node is the master node.", (Throwable)ex);
        }
        return false;
    }
}

