/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import org.elasticsearch.ingest.IngestDocument;

final class CsvParser {
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private final char quote;
    private final char separator;
    private final boolean trim;
    private final String[] headers;
    private final Object emptyValue;
    private final IngestDocument ingestDocument;
    private final StringBuilder builder = new StringBuilder();
    private State state = State.START;
    private String line;
    private int currentHeader = 0;
    private int startIndex = 0;
    private int length;
    private int currentIndex;

    CsvParser(IngestDocument ingestDocument, char quote, char separator, boolean trim, String[] headers, Object emptyValue) {
        this.ingestDocument = ingestDocument;
        this.quote = quote;
        this.separator = separator;
        this.trim = trim;
        this.headers = headers;
        this.emptyValue = emptyValue;
    }

    void process(String line) {
        this.line = line;
        this.length = line.length();
        this.currentIndex = 0;
        while (this.currentIndex < this.length) {
            switch (this.state) {
                case START: {
                    if (!this.processStart()) break;
                    return;
                }
                case UNQUOTED: {
                    if (!this.processUnquoted()) break;
                    return;
                }
                case QUOTED: {
                    this.processQuoted();
                    break;
                }
                case QUOTED_END: {
                    if (!this.processQuotedEnd()) break;
                    return;
                }
            }
            ++this.currentIndex;
        }
        switch (this.state) {
            case UNQUOTED: {
                this.setField(this.length);
                break;
            }
            case QUOTED_END: {
                this.setField(this.length - 1);
                break;
            }
            case QUOTED: {
                throw new IllegalArgumentException("Unmatched quote");
            }
        }
    }

    private boolean processStart() {
        while (this.currentIndex < this.length) {
            char c = this.currentChar();
            if (c == this.quote) {
                this.state = State.QUOTED;
                this.builder.setLength(0);
                this.startIndex = this.currentIndex + 1;
                return false;
            }
            if (c == this.separator) {
                ++this.startIndex;
                this.builder.setLength(0);
                if (this.setField(this.startIndex)) {
                    return true;
                }
            } else if (this.isWhitespace(c)) {
                if (this.trim) {
                    ++this.startIndex;
                }
            } else {
                this.state = State.UNQUOTED;
                this.builder.setLength(0);
                return false;
            }
            ++this.currentIndex;
        }
        return true;
    }

    private boolean processUnquoted() {
        int spaceCount = 0;
        while (this.currentIndex < this.length) {
            char c = this.currentChar();
            if (c == '\n' || c == '\r' || c == this.quote) {
                throw new IllegalArgumentException("Illegal character inside unquoted field at " + this.currentIndex);
            }
            if (c == this.separator) {
                this.state = State.START;
                if (this.setField(this.currentIndex - spaceCount)) {
                    return true;
                }
                this.startIndex = this.currentIndex + 1;
                return false;
            }
            spaceCount = this.trim && this.isWhitespace(c) ? ++spaceCount : 0;
            ++this.currentIndex;
        }
        return false;
    }

    private void processQuoted() {
        while (this.currentIndex < this.length) {
            if (this.currentChar() == this.quote) {
                this.state = State.QUOTED_END;
                break;
            }
            ++this.currentIndex;
        }
    }

    private boolean processQuotedEnd() {
        char c = this.currentChar();
        if (c == this.quote) {
            this.builder.append(this.line, this.startIndex, this.currentIndex - 1).append(this.quote);
            this.startIndex = this.currentIndex + 1;
            this.state = State.QUOTED;
            return false;
        }
        boolean shouldSetField = true;
        while (this.currentIndex < this.length) {
            c = this.currentChar();
            if (c == this.separator) {
                if (shouldSetField && this.setField(this.currentIndex - 1)) {
                    return true;
                }
                this.startIndex = this.currentIndex + 1;
                this.state = State.START;
                return false;
            }
            if (this.isWhitespace(c)) {
                if (shouldSetField) {
                    if (this.setField(this.currentIndex - 1)) {
                        return true;
                    }
                    shouldSetField = false;
                }
            } else {
                throw new IllegalArgumentException("character '" + c + "' after quoted field at " + this.currentIndex);
            }
            ++this.currentIndex;
        }
        return true;
    }

    private char currentChar() {
        return this.line.charAt(this.currentIndex);
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean setField(int endIndex) {
        String value = this.builder.length() == 0 ? this.line.substring(this.startIndex, endIndex) : this.builder.append(this.line, this.startIndex, endIndex).toString();
        if (value.length() > 0) {
            this.ingestDocument.setFieldValue(this.headers[this.currentHeader], (Object)value);
        } else if (this.emptyValue != null) {
            this.ingestDocument.setFieldValue(this.headers[this.currentHeader], this.emptyValue);
        }
        ++this.currentHeader;
        return this.currentHeader == this.headers.length;
    }

    private static enum State {
        START,
        UNQUOTED,
        QUOTED,
        QUOTED_END;

    }
}

