/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.rest.action.servers;

import de.virtimo.bpc.elasticsearch.plugin.BpcConnection;
import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.servers.ConnectedServersUtil;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestGetConnectedServersAction
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestGetConnectedServersAction.class, (String[])new String[]{"es-bpc-plugin"});

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_bpc/servers"));
    }

    public String getName() {
        return "get_connected_servers_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject().startArray("servers");
        for (BpcConnection connection : Manager.getInstance().getConnections().getAll()) {
            ConnectedServersUtil.addConnection(builder, connection);
        }
        builder.endArray().endObject();
        return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
    }
}

