/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;

public class TimestampUtil {
    private static final Logger LOG = Loggers.getLogger(TimestampUtil.class, (String[])new String[]{"es-bpc-plugin"});

    public static long getNowInUtcEpochMilli() {
        LOG.debug("getNowInUtcEpochMilli");
        return LocalDateTime.now().toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static LocalDateTime asLocalDateTime(long utcMilliTimestamp) {
        LOG.debug("asLocalDateTime utcMilliTimestamp=" + utcMilliTimestamp);
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(utcMilliTimestamp), ZoneOffset.UTC);
    }
}

