/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.utils;

import de.virtimo.bpc.elasticsearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestBodyMissingException;
import de.virtimo.bpc.elasticsearch.plugin.utils.RequestParamMissingException;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.rest.RestRequest;

public class RequestUtil {
    public static String getMandatoryQueryParamAsString(RestRequest request, String paramName) throws RequestParamMissingException {
        String paramValue = request.param(paramName, null);
        if (paramValue == null || paramValue.length() == 0) {
            throw new RequestParamMissingException(paramName);
        }
        return paramValue;
    }

    public static String getMandatoryBodyAsString(RestRequest request) throws RequestBodyMissingException {
        if (request == null || !request.hasContent()) {
            throw new RequestBodyMissingException("The content in the request body is missing.");
        }
        return request.content().utf8ToString();
    }

    public static Map<String, Object> getMandatoryJsonBodyAsMap(RestRequest request) throws RequestBodyMissingException {
        Map<String, Object> map;
        if (request == null || !request.hasContent()) {
            throw new RequestBodyMissingException("The content in the request body is missing.");
        }
        try {
            map = JsonUtil.asMap(request.content().utf8ToString());
            if (map == null) {
                throw new RequestBodyMissingException("The content in the request body is empty.");
            }
        }
        catch (IOException ex) {
            throw new RequestBodyMissingException("The content in the request body is not a valid JSON.");
        }
        return map;
    }
}

