/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.BpcPluginModule;
import de.virtimo.bpc.elasticsearch.plugin.ChangesFilter;
import de.virtimo.bpc.elasticsearch.plugin.ClusterSettings;
import de.virtimo.bpc.elasticsearch.plugin.ClusterSettingsObserver;
import de.virtimo.bpc.elasticsearch.plugin.IndexOperation;
import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.NodeBroadcaster;
import de.virtimo.bpc.elasticsearch.plugin.NodesInfo;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.config.RestGetConfigAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.filters.RestAddFilterAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.filters.RestGetFiltersAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.filters.RestRemoveFiltersAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.interplugin.RestBroadcastMessageReceivedAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.interplugin.RestChangesFilterAddAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.interplugin.RestChangesFilterRemoveAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.interplugin.RestChangesFilterRemoveAllAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.interplugin.RestConnectionAddedOrUpdatedAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.interplugin.RestConnectionRemovedAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.interplugin.RestIndexOperationAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.servers.RestGetConnectedMasterServerAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.servers.RestGetConnectedServersAction;
import de.virtimo.bpc.elasticsearch.plugin.rest.action.servers.RestSetMasterServerAction;
import de.virtimo.bpc.elasticsearch.plugin.utils.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;

public class BpcPlugin
extends Plugin
implements ActionPlugin,
ClusterPlugin {
    private static final Logger LOG = Loggers.getLogger(BpcPlugin.class, (String[])new String[]{"es-bpc-plugin"});
    public static final String SETTING_WEBSOCKET_PORT = "es-bpc-plugin.websocket.port";
    public static final Integer DEFAULT_WEBSOCKET_PORT = 9201;
    public static final String SETTING_BASICAUTH_USERNAME = "es-bpc-plugin.basicauth.username";
    public static final String SETTING_BASICAUTH_PASSWORD = "es-bpc-plugin.basicauth.password";
    public static final String SETTING_TRUST_CERTIFICATES = "es-bpc-plugin.trust_certificates";
    private Client client = null;
    private ClusterService clusterService = null;

    public BpcPlugin(Settings settings) {
        LOG.info("Starting the Virtimo BPC Plugin settings=" + settings);
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Setting.intSetting((String)SETTING_WEBSOCKET_PORT, (int)DEFAULT_WEBSOCKET_PORT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), Setting.simpleString((String)SETTING_BASICAUTH_USERNAME, (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), Setting.simpleString((String)SETTING_BASICAUTH_PASSWORD, (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), Setting.boolSetting((String)SETTING_TRUST_CERTIFICATES, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), Setting.simpleString((String)ClusterSettings.structuredSettingName("masterServer"), (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), Setting.simpleString((String)ClusterSettings.structuredSettingName("connections"), (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), Setting.simpleString((String)ClusterSettings.structuredSettingName("filters"), (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}));
    }

    public Collection<Module> createGuiceModules() {
        LOG.debug("createGuiceModules");
        return Collections.singletonList(new BpcPluginModule());
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        LOG.debug("getGuiceServiceClasses");
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>();
        services.add(NodesInfo.class);
        services.add(NodeBroadcaster.class);
        services.add(ClusterSettings.class);
        services.add(Manager.class);
        services.add(ClusterSettingsObserver.class);
        return services;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        LOG.debug("createComponents");
        this.client = client;
        this.clusterService = clusterService;
        return super.createComponents(client, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, environment, nodeEnvironment, namedWriteableRegistry, indexNameExpressionResolver, repositoriesServiceSupplier);
    }

    private boolean uglyWorkaroundForMultipleOnIndexModuleCallsForTheSameIndex() {
        StackTraceElement[] stacktrace;
        for (StackTraceElement stackTraceElement : stacktrace = Thread.currentThread().getStackTrace()) {
            String methodName = stackTraceElement.getMethodName();
            if (!methodName.equals("applyClusterState")) continue;
            return true;
        }
        return false;
    }

    public void onIndexModule(IndexModule indexModule) {
        LOG.debug("onIndexModule indexModule=" + indexModule + " (" + indexModule.getIndex().getName() + ")");
        if (this.uglyWorkaroundForMultipleOnIndexModuleCallsForTheSameIndex()) {
            indexModule.addIndexEventListener(new IndexEventListener(){

                public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
                    Manager manager = Manager.getInstance();
                    if (manager.getConnections().hasEntries()) {
                        manager.getConnections().sendWebsocketMessage("IndexDeleted:::" + index.getName(), null);
                    }
                }

                public void afterIndexCreated(IndexService indexService) {
                    Manager manager = Manager.getInstance();
                    if (manager.getConnections().hasEntries()) {
                        manager.getConnections().sendWebsocketMessage("IndexCreated:::" + indexService.index().getName(), null);
                    }
                }
            });
        }
        indexModule.addIndexOperationListener(new IndexingOperationListener(){
            private Map<Engine.Index, Boolean> identicalSourcesMap;

            private Set<String> getAliasesOfIndex(String indexName) {
                return new HashSet<String>(Arrays.asList((String[])BpcPlugin.this.clusterService.state().metadata().index(indexName).getAliases().keys().toArray(String.class)));
            }

            public Engine.Index preIndex(ShardId shardId, Engine.Index index) {
                Manager manager = Manager.getInstance();
                if (manager.getConnections().hasEntries()) {
                    String indexName = shardId.getIndexName();
                    Set<String> aliasesOfIndex = this.getAliasesOfIndex(indexName);
                    ChangesFilter filter = manager.getChangesFilters().getFilter(indexName, aliasesOfIndex);
                    if (filter != null && filter.isSendIndexEventsOnlyForModifiedSources()) {
                        Map<String, Object> currentSource = null;
                        try {
                            currentSource = JsonUtil.asMap(index.source());
                        }
                        catch (IOException ex) {
                            LOG.error("Failed to convert the Elasticsearch SOURCE as JSON. This should not be possible. Index: " + indexName + ", ID: " + index.id(), (Throwable)ex);
                        }
                        Map previousSource = null;
                        try {
                            GetResponse getResponse = (GetResponse)BpcPlugin.this.client.prepareGet(indexName, index.type(), index.id()).execute().actionGet();
                            if (getResponse != null) {
                                previousSource = getResponse.getSource();
                            }
                        }
                        catch (Exception ex) {
                            LOG.error("Could not get the current document.", (Throwable)ex);
                        }
                        boolean identicalSources = currentSource == null && previousSource == null ? true : (currentSource != null && previousSource == null ? false : (currentSource == null && previousSource != null ? false : currentSource.equals(previousSource)));
                        if (this.identicalSourcesMap == null) {
                            this.identicalSourcesMap = new HashMap<Engine.Index, Boolean>();
                        }
                        this.identicalSourcesMap.put(index, identicalSources);
                    }
                }
                return index;
            }

            public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
                Manager manager = Manager.getInstance();
                if (manager.getConnections().hasEntries()) {
                    String indexName = shardId.getIndexName();
                    Set<String> aliasesOfIndex = this.getAliasesOfIndex(indexName);
                    ChangesFilter filter = manager.getChangesFilters().getFilter(indexName, aliasesOfIndex);
                    if (filter != null) {
                        boolean sendChangesEvent;
                        if (filter.isSendIndexEventsOnlyForModifiedSources()) {
                            if (this.identicalSourcesMap != null) {
                                boolean identicalSources = this.identicalSourcesMap.get(index);
                                this.identicalSourcesMap.remove(index);
                                sendChangesEvent = !identicalSources;
                            } else {
                                sendChangesEvent = false;
                            }
                        } else {
                            sendChangesEvent = true;
                        }
                        if (sendChangesEvent) {
                            IndexOperation indexOperation = new IndexOperation(indexName, aliasesOfIndex, index.id(), IndexOperation.Operation.INDEX, index.version(), index.source());
                            manager.getNodeBroadcaster().sendIndexOperationToAllNodes(indexOperation);
                        }
                    }
                }
            }

            public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
                Manager manager = Manager.getInstance();
                if (manager.getConnections().hasEntries()) {
                    String indexName = shardId.getIndexName();
                    Set<String> aliasesOfIndex = this.getAliasesOfIndex(indexName);
                    ChangesFilter filter = manager.getChangesFilters().getFilter(indexName, aliasesOfIndex);
                    if (filter != null) {
                        IndexOperation indexOperation = new IndexOperation(indexName, aliasesOfIndex, delete.id(), IndexOperation.Operation.DELETE, delete.version(), null);
                        manager.getNodeBroadcaster().sendIndexOperationToAllNodes(indexOperation);
                    }
                }
            }
        });
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, org.elasticsearch.common.settings.ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> result = new ArrayList<RestHandler>();
        result.add((RestHandler)new RestGetConfigAction(settings));
        result.add((RestHandler)new RestGetFiltersAction());
        result.add((RestHandler)new RestRemoveFiltersAction());
        result.add((RestHandler)new RestAddFilterAction());
        result.add((RestHandler)new RestGetConnectedServersAction());
        result.add((RestHandler)new RestGetConnectedMasterServerAction());
        result.add((RestHandler)new RestSetMasterServerAction());
        result.add((RestHandler)new RestBroadcastMessageReceivedAction());
        result.add((RestHandler)new RestIndexOperationAction());
        result.add((RestHandler)new RestConnectionAddedOrUpdatedAction());
        result.add((RestHandler)new RestConnectionRemovedAction());
        result.add((RestHandler)new RestChangesFilterAddAction());
        result.add((RestHandler)new RestChangesFilterRemoveAllAction());
        result.add((RestHandler)new RestChangesFilterRemoveAction());
        return result;
    }
}

