/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.dbcp2.impl;

import java.sql.SQLException;
import java.util.Properties;
import java.util.UUID;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.managed.DataSourceXAConnectionFactory;
import org.apache.commons.dbcp2.managed.ManagedDataSource;
import org.apache.commons.dbcp2.managed.PoolableManagedConnectionFactory;
import org.apache.commons.dbcp2.managed.TransactionRegistry;
import org.apache.commons.dbcp2.managed.XAConnectionFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.ops4j.pax.jdbc.pool.dbcp2.impl.DbcpPooledDataSourceFactory;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbcpXAPooledDataSourceFactory
extends DbcpPooledDataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DbcpXAPooledDataSourceFactory.class);
    protected TransactionManager tm;

    public DbcpXAPooledDataSourceFactory(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    protected ObjectName getJmxName(String dsName) {
        if (dsName == null) {
            dsName = UUID.randomUUID().toString();
        }
        try {
            return new ObjectName("org.ops4j.pax.jdbc.pool", "dsName", dsName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name for data source" + dsName, e);
        }
    }

    @Override
    public DataSource create(DataSourceFactory dsf, Properties props) throws SQLException {
        try {
            XADataSource ds = dsf.createXADataSource(this.getNonPoolProps(props));
            DataSourceXAConnectionFactory connFactory = new DataSourceXAConnectionFactory(this.tm, ds);
            PoolableManagedConnectionFactory pcf = new PoolableManagedConnectionFactory((XAConnectionFactory)connFactory, null);
            GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
            BeanConfig.configure((Object)conf, this.getPoolProps(props));
            BeanConfig.configure((Object)pcf, this.getPrefixed(props, "factory."));
            GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)pcf, conf);
            pcf.setPool((ObjectPool)pool);
            TransactionRegistry transactionRegistry = connFactory.getTransactionRegistry();
            return new ManagedDataSource((ObjectPool)pool, transactionRegistry);
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled datasource: " + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

