/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.BpcConnection;
import de.virtimo.bpc.elasticsearch.plugin.ChangesFilter;
import de.virtimo.bpc.elasticsearch.plugin.ClusterSettings;
import de.virtimo.bpc.elasticsearch.plugin.Manager;
import de.virtimo.bpc.elasticsearch.plugin.MasterServerInfo;
import de.virtimo.bpc.elasticsearch.plugin.utils.JsonUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public class ClusterSettingsObserver
extends AbstractLifecycleComponent {
    private static final Logger LOG = Loggers.getLogger(ClusterSettingsObserver.class, (String[])new String[]{"es-bpc-plugin"});
    private static ClusterSettingsObserver INSTANCE;
    private final Manager manager;
    private Map<String, Object> previousMasterServerMap;
    private Map<String, Object> previousConnectionsMap;
    private Map<String, Object> previousChangesFiltersMap;

    @Inject
    public ClusterSettingsObserver(final Provider<ClusterService> clusterServiceProvider, Manager manager) {
        LOG.debug("ClusterSettingsObserver clusterServiceProvider=" + clusterServiceProvider + ", manager=" + manager);
        this.manager = manager;
        Thread thread = new Thread("AddClusterServiceListenerWorkaroundThread"){

            @Override
            public void run() {
                ClusterService clusterService = null;
                while (clusterService == null) {
                    try {
                        LOG.info("Adding cluster state listener to the ClusterService");
                        clusterService = (ClusterService)clusterServiceProvider.get();
                        clusterService.addListener(new ClusterStateListener(){

                            public void clusterChanged(ClusterChangedEvent clusterChangedEvent) {
                                if (clusterChangedEvent.nodesRemoved()) {
                                    DiscoveryNodes.Delta nodesDelta = clusterChangedEvent.nodesDelta();
                                    ClusterSettingsObserver.this.processRemovedNodesFromCluster(nodesDelta.removedNodes());
                                }
                                if (clusterChangedEvent.metadataChanged()) {
                                    ClusterSettingsObserver.this.processChangedClusterMetaData(clusterChangedEvent.state().getMetadata());
                                }
                            }
                        });
                        LOG.info("Cluster state listener added to ClusterService");
                    }
                    catch (Throwable e) {
                        try {
                            LOG.warn("Failed to add my cluster state listener to the ClusterService ... trying it again ...");
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        };
        thread.start();
    }

    public static ClusterSettingsObserver getInstance() {
        return INSTANCE;
    }

    protected void doStart() {
        INSTANCE = this;
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }

    private void processRemovedNodesFromCluster(List<DiscoveryNode> removedNodes) {
        LOG.debug("processRemovedNodesFromCluster removedNodes=" + removedNodes);
        final HashSet<String> namesOfRemovedNodes = new HashSet<String>();
        for (DiscoveryNode removedNode : removedNodes) {
            namesOfRemovedNodes.add(removedNode.getName());
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ClusterSettingsObserver.this.manager.unregisterRemovedElasticsearchNodes(namesOfRemovedNodes);
            }
        });
        t.start();
    }

    private void processChangedClusterMetaData(Metadata metaData) {
        LOG.debug("processChangedClusterMetaData metaData=" + metaData);
        Settings allTransientSettings = metaData.transientSettings();
        Settings esBpcPluginSettings = (Settings)allTransientSettings.getAsGroups().get(ClusterSettings.TRANSIENT_SETTINGS_PREFIX);
        if (esBpcPluginSettings == null || esBpcPluginSettings.isEmpty()) {
            LOG.debug("Nothing to do, the transient bpc plugin settings do not exist at the moment");
            return;
        }
        LOG.debug("Processing updated plugin settings: " + esBpcPluginSettings);
        this.processMasterServerSetting(esBpcPluginSettings.get("masterServer"));
        this.processConnectionsSetting(esBpcPluginSettings.get("connections"));
        this.processFiltersSetting(esBpcPluginSettings.get("filters"));
    }

    private void processMasterServerSetting(Object masterServerObject) {
        LOG.debug("processMasterServerSetting masterServerObject=" + masterServerObject);
        if (masterServerObject == null) {
            return;
        }
        if (!(masterServerObject instanceof String)) {
            LOG.error("The 'masterServer' setting data type is not the expected String.");
            return;
        }
        try {
            Map<String, Object> masterServerMap = JsonUtil.asMap((String)masterServerObject);
            if (masterServerMap == null) {
                LOG.debug("No 'masterServer' setting value set at the moment");
                return;
            }
            if (this.previousMasterServerMap != null && this.previousMasterServerMap.equals(masterServerMap)) {
                LOG.debug("No 'masterServer' setting update detected");
                return;
            }
            MasterServerInfo masterServerInfo = new MasterServerInfo(masterServerMap);
            this.manager.processMasterServerInfoSetting(masterServerInfo);
            this.previousMasterServerMap = new HashMap<String, Object>(masterServerMap);
        }
        catch (IOException ex) {
            LOG.error("The 'masterServer' setting value is no valid JSON: " + masterServerObject, (Throwable)ex);
        }
    }

    private void processConnectionsSetting(Object connectionsObject) {
        LOG.debug("processConnectionsSetting connectionsObject=" + connectionsObject);
        if (connectionsObject == null) {
            return;
        }
        if (!(connectionsObject instanceof String)) {
            LOG.error("The 'connections' setting data type is not the expected String.");
            return;
        }
        try {
            Map<String, Object> connectionsMap = JsonUtil.asMap((String)connectionsObject);
            if (connectionsMap == null) {
                LOG.debug("No 'connections' setting value set at the moment");
                return;
            }
            if (this.previousConnectionsMap != null && this.previousConnectionsMap.equals(connectionsMap)) {
                LOG.debug("No 'connections' setting update detected");
                return;
            }
            Set<BpcConnection> connections = this.manager.getConnections().createBpcConnections(connectionsMap);
            if (connections != null) {
                if (!this.manager.getConnections().hasEntries()) {
                    this.manager.getConnections().processBpcConnectionsSetting(connections);
                }
                this.previousConnectionsMap = new HashMap<String, Object>(connectionsMap);
            }
        }
        catch (IOException ex) {
            LOG.error("The 'connections' setting value is no valid JSON: " + connectionsObject, (Throwable)ex);
        }
    }

    private void processFiltersSetting(Object changesFiltersObject) {
        LOG.debug("processFiltersSetting changesFiltersObject=" + changesFiltersObject);
        if (changesFiltersObject == null) {
            return;
        }
        if (!(changesFiltersObject instanceof String)) {
            LOG.error("The 'filters' setting data type is not the expected String.");
            return;
        }
        try {
            Map<String, Object> changesFiltersMap = JsonUtil.asMap((String)changesFiltersObject);
            if (changesFiltersMap == null) {
                LOG.debug("No 'filters' setting value set at the moment");
                return;
            }
            if (this.previousChangesFiltersMap != null && this.previousChangesFiltersMap.equals(changesFiltersMap)) {
                LOG.debug("No 'filters' setting update detected");
                return;
            }
            Set<ChangesFilter> changesFilters = this.manager.getChangesFilters().createChangesFilters(changesFiltersMap);
            if (changesFilters != null) {
                if (!this.manager.getChangesFilters().isInitialized()) {
                    this.manager.getChangesFilters().processChangesFilters(changesFilters);
                }
                this.previousChangesFiltersMap = new HashMap<String, Object>(changesFiltersMap);
            }
        }
        catch (IOException ex) {
            LOG.error("The 'filters' setting value is no valid JSON: " + changesFiltersObject, (Throwable)ex);
        }
    }
}

