/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.BpcConnections;
import de.virtimo.bpc.opensearch.plugin.ChangesFilters;
import de.virtimo.bpc.opensearch.plugin.MasterServerInfo;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobs;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class BpcPluginModelInitDTO
implements OpenSearchPluginDTO {
    private static final Logger LOG = Loggers.getLogger(BpcPluginModelInitDTO.class, (String[])new String[]{"os-bpc-plugin"});
    private final MasterServerInfo masterServerInfo;
    private final BpcConnections connections;
    private final ChangesFilters changesFilters;
    private final ReplicationJobs replicationJobs;

    public BpcPluginModelInitDTO(MasterServerInfo masterServerInfo, BpcConnections connections, ChangesFilters changesFilters, ReplicationJobs replicationJobs) {
        Objects.requireNonNull(connections, "connections must not be null");
        Objects.requireNonNull(changesFilters, "changesFilters must not be null");
        Objects.requireNonNull(replicationJobs, "replicationJobs must not be null");
        this.masterServerInfo = masterServerInfo;
        this.connections = connections;
        this.changesFilters = changesFilters;
        this.replicationJobs = replicationJobs;
    }

    public BpcPluginModelInitDTO(Map<String, Object> map) {
        this.masterServerInfo = map.get("masterServerInfo") instanceof Map ? new MasterServerInfo((Map)map.get("masterServerInfo")) : null;
        this.connections = map.get("connections") instanceof Map ? new BpcConnections((Map)map.get("connections")) : new BpcConnections();
        this.changesFilters = map.get("changesFilters") instanceof Map ? new ChangesFilters((Map)map.get("changesFilters")) : new ChangesFilters();
        this.replicationJobs = map.get("replicationJobs") instanceof Map ? new ReplicationJobs((Map)map.get("replicationJobs")) : new ReplicationJobs();
    }

    public BpcPluginModelInitDTO(StreamInput in) throws IOException {
        this.masterServerInfo = (MasterServerInfo)in.readOptionalWriteable(MasterServerInfo::new);
        this.connections = (BpcConnections)in.readOptionalWriteable(BpcConnections::new);
        this.changesFilters = (ChangesFilters)in.readOptionalWriteable(ChangesFilters::new);
        this.replicationJobs = (ReplicationJobs)in.readOptionalWriteable(ReplicationJobs::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.masterServerInfo);
        out.writeOptionalWriteable((Writeable)this.connections);
        out.writeOptionalWriteable((Writeable)this.changesFilters);
        out.writeOptionalWriteable((Writeable)this.replicationJobs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.masterServerInfo != null) {
            builder.field("masterServerInfo", (ToXContent)this.masterServerInfo, params);
        }
        builder.field("connections", (ToXContent)this.connections, params);
        builder.field("changesFilters", (ToXContent)this.changesFilters, params);
        builder.field("replicationJobs", (ToXContent)this.replicationJobs, params);
        builder.endObject();
        return builder;
    }

    public static BpcPluginModelInitDTO fromXContent(XContentParser parser) throws IOException {
        return new BpcPluginModelInitDTO(parser.map());
    }

    public MasterServerInfo getMasterServerInfo() {
        return this.masterServerInfo;
    }

    public BpcConnections getConnections() {
        return this.connections;
    }

    public ChangesFilters getChangesFilters() {
        return this.changesFilters;
    }

    public ReplicationJobs getReplicationJobs() {
        return this.replicationJobs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BpcPluginModelInitDTO that = (BpcPluginModelInitDTO)o;
        return Objects.equals(this.masterServerInfo, that.masterServerInfo) && Objects.equals(this.connections, that.connections) && Objects.equals(this.changesFilters, that.changesFilters) && Objects.equals(this.replicationJobs, that.replicationJobs);
    }

    public int hashCode() {
        return Objects.hash(this.masterServerInfo, this.connections, this.changesFilters, this.replicationJobs);
    }

    public String toString() {
        return "BpcPluginModelInitDTO{masterServerInfo=" + this.masterServerInfo + ", connections=" + this.connections + ", changesFilters=" + this.changesFilters + ", replicationJobs=" + this.replicationJobs + "}";
    }
}

