/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.BpcConnection;
import de.virtimo.bpc.opensearch.plugin.BpcConnections;
import de.virtimo.bpc.opensearch.plugin.BpcPlugin;
import de.virtimo.bpc.opensearch.plugin.BpcPluginModelInitDTO;
import de.virtimo.bpc.opensearch.plugin.ChangesFilter;
import de.virtimo.bpc.opensearch.plugin.ChangesFilters;
import de.virtimo.bpc.opensearch.plugin.ClusterObserver;
import de.virtimo.bpc.opensearch.plugin.MasterServerInfo;
import de.virtimo.bpc.opensearch.plugin.NodesInfo;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartActions;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopActions;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobs;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobsOrchestrator;
import de.virtimo.bpc.opensearch.plugin.WebSocket;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterAddActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveAllActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.IndexOperationDTO;
import de.virtimo.bpc.opensearch.plugin.dto.LoadedModulesDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobForcedStartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRefreshLookupJoinsActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRestartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobStatsGetActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsClearLookupJoinCachesActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsRefreshLookupJoinsActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsWithRuntimeStatsFromAllServersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsWithRuntimeStatsFromServerDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.BpcConnectionAddedOrUpdatedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.BpcConnectionAddedOrUpdatedRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.BpcConnectionAddedOrUpdatedResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.BpcConnectionRemovedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.BpcConnectionRemovedRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.BpcConnectionRemovedResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.BroadcastReceivedWebsocketMessageToAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.BroadcastReceivedWebsocketMessageToRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.BroadcastReceivedWebsocketMessageToResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.BroadcastReceivedWebsocketMessageToAllAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.BroadcastReceivedWebsocketMessageToAllRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.BroadcastReceivedWebsocketMessageToAllResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.BroadcastReceivedWebsocketMessageToAllExceptSenderAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.BroadcastReceivedWebsocketMessageToAllExceptSenderRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.BroadcastReceivedWebsocketMessageToAllExceptSenderResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.ChangesFilterAddAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.ChangesFilterAddRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.ChangesFilterAddResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.ChangesFilterRemoveAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.ChangesFilterRemoveRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.ChangesFilterRemoveResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.ChangesFilterRemoveAllAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.ChangesFilterRemoveAllRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.ChangesFilterRemoveAllResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.IndexOperationAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.IndexOperationRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.IndexOperationResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.InitializeModelAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.InitializeModelRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.InitializeModelResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.MasterServerSetAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.MasterServerSetRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.MasterServerSetResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.forcedstart.ReplicationJobForcedStartAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.forcedstart.ReplicationJobForcedStartRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.forcedstart.ReplicationJobForcedStartResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.restart.ReplicationJobRestartAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.restart.ReplicationJobRestartRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.restart.ReplicationJobRestartResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.start.ReplicationJobStartActionsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.start.ReplicationJobStartActionsRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.start.ReplicationJobStartActionsResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.stop.ReplicationJobStopActionsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.stop.ReplicationJobStopActionsRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.stop.ReplicationJobStopActionsResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.set.ReplicationJobsSetAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.set.ReplicationJobsSetRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.set.ReplicationJobsSetResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.setmodel.ReplicationJobsSetModelAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.setmodel.ReplicationJobsSetModelRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.setmodel.ReplicationJobsSetModelResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.clearcaches.ReplicationJobsClearLookupJoinCachesAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.clearcaches.ReplicationJobsClearLookupJoinCachesRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.clearcaches.ReplicationJobsClearLookupJoinCachesResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refresh.ReplicationJobRefreshLookupJoinsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refresh.ReplicationJobRefreshLookupJoinsRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refresh.ReplicationJobRefreshLookupJoinsResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refreshalll.ReplicationJobsRefreshAllLookupJoinsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refreshalll.ReplicationJobsRefreshAllLookupJoinsRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refreshalll.ReplicationJobsRefreshAllLookupJoinsResponse;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.SetUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllExceptSenderWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ClearLookupJoinCachesOfReplicationJobsWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexCreatedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexDeletedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexOperationWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.PlainTextWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.RefreshLookupJoinsOfReplicationJobWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobForcedStartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobRestartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStartActionWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStatsRequestWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStatsResponseWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStopActionWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerLoadedModulesWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerStateInfoWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.SetAsMasterServerWebsocketMessage;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.websocket.DeploymentException;
import org.apache.logging.log4j.Logger;
import org.glassfish.tyrus.server.Server;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.index.engine.Engine;

public class Manager
extends AbstractLifecycleComponent {
    private static final Logger LOG = Loggers.getLogger(Manager.class, (String[])new String[]{"os-bpc-plugin"});
    public static final int REPLICATION_JOBS_ORCHESTRATION_CHECKER_INITIAL_DELAY_IN_SECONDS = 10;
    public static final int REPLICATION_JOBS_ORCHESTRATION_CHECKER_RUNS_EVERY_SECONDS = 1;
    public static final int PROCESS_UPDATED_CONNECTIONS_DELAY_IN_SECONDS = 15;
    private final Client client;
    private final ClusterService clusterService;
    private final NodesInfo nodesInfo;
    private final ClusterObserver clusterObserver;
    private MasterServerInfo masterServerInfo;
    private BpcConnections connections;
    private ChangesFilters changesFilters;
    private ReplicationJobs currentReplicationJobs;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;
    private long connectionsLastUpdatedProcessedByChecker;
    private boolean replicationJobsOrchestrationRunning;
    private ReplicationJobs queuedReplicationJobs;
    private ReplicationJobStatsRequests replicationJobStatsRequests;
    private final int websocketServerPort;
    private final Server websocketServer;
    private static final Object MASTER_SERVER_LOCK = new Object();

    public Manager(Client client, ClusterService clusterService, Settings settings) {
        LOG.debug("Manager client=" + client + ", clusterService=" + clusterService + ", settings=" + settings);
        this.client = client;
        this.clusterService = clusterService;
        this.nodesInfo = new NodesInfo(client, clusterService);
        this.clusterObserver = new ClusterObserver(clusterService, this);
        this.masterServerInfo = null;
        this.connections = new BpcConnections();
        this.changesFilters = new ChangesFilters();
        this.currentReplicationJobs = new ReplicationJobs();
        this.replicationJobStatsRequests = new ReplicationJobStatsRequests();
        this.connectionsLastUpdatedProcessedByChecker = -1L;
        this.replicationJobsOrchestrationRunning = false;
        this.queuedReplicationJobs = null;
        this.websocketServerPort = BpcPlugin.getSettingsValueAsInt(settings, "os-bpc-plugin.websocket.port", BpcPlugin.DEFAULT_WEBSOCKET_PORT);
        this.websocketServer = new Server("localhost", this.websocketServerPort, "/ws", MapUtil.mapOf((Object[])new Object[]{"manager", this}), new Class[]{WebSocket.class});
    }

    protected void doStart() {
        try {
            LOG.info("Starting WebSocket server");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        Manager.this.websocketServer.start();
                        return null;
                    }
                    catch (DeploymentException e) {
                        throw new RuntimeException("Failed to start server", e);
                    }
                }
            });
            LOG.info("WebSocket server started");
        }
        catch (Exception e) {
            LOG.error("Failed to start WebSocket server. Please restart OpenSearch to try it again or check why it is not possible to start a websocket server on port '" + this.websocketServerPort + "'.", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            this.clusterObserver.doStart();
        }
        catch (Exception ex) {
            LOG.error("Failed to start the cluster observer.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        try {
            this.executorService = Executors.newSingleThreadScheduledExecutor();
            this.checkerHandle = this.executorService.scheduleWithFixedDelay(new ReplicationJobsOrchestrationCheckerRunnable(), 10L, 1L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOG.error("Failed to start the replication jobs orchestration checker.", (Throwable)ex);
        }
    }

    protected void doStop() {
        this.websocketServer.stop();
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOG.debug("Running replications jobs orchestration checker cancelled.");
            } else {
                LOG.warn("Failed to cancel the running replication jobs orchestration checker.");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.clusterObserver.doStop();
    }

    protected void doClose() throws IOException {
    }

    public void initializePluginModel(String sendFromOpenSearchNode, BpcPluginModelInitDTO initPluginModelDTO) {
        LOG.info("initializePluginModel sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", initPluginModelDTO=" + initPluginModelDTO);
        this.masterServerInfo = initPluginModelDTO.getMasterServerInfo();
        this.connections = initPluginModelDTO.getConnections();
        this.changesFilters = initPluginModelDTO.getChangesFilters();
        this.currentReplicationJobs = initPluginModelDTO.getReplicationJobs();
    }

    public NodesInfo getNodesInfo() {
        return this.nodesInfo;
    }

    public MasterServerInfo getMasterServerInfo() {
        return this.masterServerInfo;
    }

    public BpcConnections getConnections() {
        return this.connections;
    }

    public ChangesFilters getChangesFilters() {
        return this.changesFilters;
    }

    public ReplicationJobs getCurrentReplicationJobs() {
        return this.currentReplicationJobs;
    }

    public void setCurrentReplicationJobs(String sendFromOpenSearchNode, ReplicationJobs currentReplicationJobs) {
        LOG.debug("setCurrentReplicationJobs sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", currentReplicationJobs=" + currentReplicationJobs);
        this.currentReplicationJobs = currentReplicationJobs;
    }

    public void registerWebSocket(WebSocket webSocket) {
        LOG.debug("registerWebSocket webSocket=" + webSocket);
        String thisNodeName = this.nodesInfo.getLocalNodeName();
        BpcConnection connection = this.connections.addConnection(thisNodeName, webSocket);
        this.client.execute((ActionType)BpcConnectionAddedOrUpdatedAction.INSTANCE, (ActionRequest)new BpcConnectionAddedOrUpdatedRequest(thisNodeName, connection), (ActionListener)new ActionListener<BpcConnectionAddedOrUpdatedResponse>(){

            public void onResponse(BpcConnectionAddedOrUpdatedResponse bpcConnectionAddedOrUpdatedResponse) {
                if (bpcConnectionAddedOrUpdatedResponse.hasFailures()) {
                    LOG.error("Failed to broadcast a BPC connection added message to all nodes.", (Throwable)bpcConnectionAddedOrUpdatedResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting a BPC connection added message to all nodes. Response: " + bpcConnectionAddedOrUpdatedResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast a BPC connection added message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void unregisterWebSocket(String webSocketId) {
        LOG.debug("unregisterWebSocket webSocketId=" + webSocketId);
        BpcConnection existingConnection = this.connections.getConnectionByWebsocketId(webSocketId);
        this._unregisterConnection(existingConnection);
    }

    private void _unregisterConnection(BpcConnection existingConnection) {
        LOG.info("_unregisterConnection existingConnection=" + existingConnection);
        if (existingConnection != null) {
            this.client.execute((ActionType)BpcConnectionRemovedAction.INSTANCE, (ActionRequest)new BpcConnectionRemovedRequest(this.nodesInfo.getLocalNodeName(), existingConnection), (ActionListener)new ActionListener<BpcConnectionRemovedResponse>(){

                public void onResponse(BpcConnectionRemovedResponse bpcConnectionRemovedResponse) {
                    if (bpcConnectionRemovedResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a BPC connection removed message to all nodes.", (Throwable)bpcConnectionRemovedResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a BPC connection removed message to all nodes. Response: " + bpcConnectionRemovedResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a BPC connection removed message to all nodes.", (Throwable)ex);
                }
            });
        }
    }

    public void unregisterRemovedOpenSearchNodes(Set<String> namesOfRemovedNodes) {
        LOG.debug("unregisterRemovedOpenSearchNodes namesOfRemovedNodes=" + namesOfRemovedNodes);
        List<BpcConnection> connectionsToUnregister = this.connections.getConnectionsByOpenSearchNodeNames(namesOfRemovedNodes);
        for (BpcConnection connectionToUnregister : connectionsToUnregister) {
            this._unregisterConnection(connectionToUnregister);
        }
    }

    public void handleJustAddedOpenSearchNodes(List<DiscoveryNode> addedNodes) {
        LOG.debug("handleJustAddedOpenSearchNodes addedNodes=" + addedNodes);
        this.nodesInfo.ifThisNodeIsTheMasterNodeOrElse(() -> this._handleJustAddedOpenSearchNodes(addedNodes), () -> LOG.debug("Skipping, the plugin model initialization must be processed on the master node only."));
    }

    public void _handleJustAddedOpenSearchNodes(List<DiscoveryNode> addedNodes) {
        LOG.debug("_handleJustAddedOpenSearchNodes addedNodes=" + addedNodes);
        BpcPluginModelInitDTO initPluginModelDTO = new BpcPluginModelInitDTO(this.masterServerInfo, this.connections, this.changesFilters, this.currentReplicationJobs);
        this.client.execute((ActionType)InitializeModelAction.INSTANCE, (ActionRequest)new InitializeModelRequest(this.nodesInfo.getLocalNodeName(), addedNodes, initPluginModelDTO), (ActionListener)new ActionListener<InitializeModelResponse>(){

            public void onResponse(InitializeModelResponse initializeModelResponse) {
                if (initializeModelResponse.hasFailures()) {
                    LOG.error("Failed to broadcast the initialize model message to the just added nodes.", (Throwable)initializeModelResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting the initialize model message to the just added nodes. Response: " + initializeModelResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast the init plugin model message to the just added nodes.", (Throwable)ex);
            }
        });
    }

    public void processReceivedServerStateInfoWebsocketMessage(String websocketId, ServerStateInfoWebsocketMessage serverStateInfoWebsocketMessage) {
        LOG.debug("processReceivedServerStateInfoWebsocketMessage websocketId=" + websocketId + ", serverStateInfoWebsocketMessage=" + serverStateInfoWebsocketMessage);
        BpcConnection connection = this.connections.getConnectionByWebsocketId(websocketId);
        if (connection != null) {
            ServerStateInfoDTO serverStateInfo = serverStateInfoWebsocketMessage.getServerStateInfo();
            connection.setServerStateInfo(serverStateInfo);
            this.client.execute((ActionType)BpcConnectionAddedOrUpdatedAction.INSTANCE, (ActionRequest)new BpcConnectionAddedOrUpdatedRequest(this.nodesInfo.getLocalNodeName(), connection), (ActionListener)new ActionListener<BpcConnectionAddedOrUpdatedResponse>(){

                public void onResponse(BpcConnectionAddedOrUpdatedResponse bpcConnectionAddedOrUpdatedResponse) {
                    if (bpcConnectionAddedOrUpdatedResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)bpcConnectionAddedOrUpdatedResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a BPC connection updated message to all nodes. Response: " + bpcConnectionAddedOrUpdatedResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)ex);
                }
            });
        } else {
            LOG.warn("There must be something wrong. Received a server state info websocket message, but there is no websocket session registered on this node.");
        }
    }

    public void processReceivedServerLoadedModulesWebsocketMessage(String websocketId, ServerLoadedModulesWebsocketMessage serverLoadedModulesWebsocketMessage) {
        LOG.debug("processReceivedServerLoadedModulesWebsocketMessage websocketId=" + websocketId + ", serverLoadedModulesWebsocketMessage=" + serverLoadedModulesWebsocketMessage);
        BpcConnection connection = this.connections.getConnectionByWebsocketId(websocketId);
        if (connection != null) {
            LoadedModulesDTO serverLoadedModules = serverLoadedModulesWebsocketMessage.getServerLoadedModules();
            connection.setServerLoadedModules(serverLoadedModules);
            this.client.execute((ActionType)BpcConnectionAddedOrUpdatedAction.INSTANCE, (ActionRequest)new BpcConnectionAddedOrUpdatedRequest(this.nodesInfo.getLocalNodeName(), connection), (ActionListener)new ActionListener<BpcConnectionAddedOrUpdatedResponse>(){

                public void onResponse(BpcConnectionAddedOrUpdatedResponse bpcConnectionAddedOrUpdatedResponse) {
                    if (bpcConnectionAddedOrUpdatedResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)bpcConnectionAddedOrUpdatedResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a BPC connection updated message to all nodes. Response: " + bpcConnectionAddedOrUpdatedResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)ex);
                }
            });
        } else {
            LOG.warn("There must be something wrong. Received a server loaded modules websocket message, but there is no websocket session registered on this node.");
        }
    }

    private void setNextAvailableServerAsMaster(ActionListener<MasterServerInfo> afterExecution) {
        String nextServerUUID;
        LOG.debug("setNextAvailableServerAsMaster afterExecution=...");
        ServerStateInfoDTO serverStateInfo = this.connections.evaluateNextAvailableMasterServer();
        if (serverStateInfo != null) {
            LOG.debug("setNextAvailableServerAsMaster serverStateInfo=" + serverStateInfo);
            nextServerUUID = serverStateInfo.getServerUUID();
        } else {
            LOG.info("setNextAvailableServerAsMaster: There is no BPC server available");
            nextServerUUID = "<<NONE>>";
        }
        this.setAsMasterServer(nextServerUUID, afterExecution);
    }

    public void setAsMasterServer(String masterServerUUID, final ActionListener<MasterServerInfo> afterExecution) {
        LOG.debug("setAsMasterServer masterServerUUID=" + masterServerUUID + ", afterExecution=" + afterExecution);
        final MasterServerInfo masterServerInfo = new MasterServerInfo(masterServerUUID);
        this.client.execute((ActionType)MasterServerSetAction.INSTANCE, (ActionRequest)new MasterServerSetRequest(this.nodesInfo.getLocalNodeName(), masterServerInfo), (ActionListener)new ActionListener<MasterServerSetResponse>(){

            public void onResponse(MasterServerSetResponse masterServerSetResponse) {
                if (afterExecution != null) {
                    if (masterServerSetResponse.hasFailures()) {
                        OpenSearchException aggregatedException = masterServerSetResponse.createAggregatedException();
                        LOG.error("Failed to set master server on all nodes.", (Throwable)aggregatedException);
                        afterExecution.onFailure((Exception)aggregatedException);
                    } else {
                        afterExecution.onResponse((Object)masterServerInfo);
                    }
                } else if (masterServerSetResponse.hasFailures()) {
                    LOG.error("Failed to set master server on all nodes.", (Throwable)masterServerSetResponse.createAggregatedException());
                }
            }

            public void onFailure(Exception ex) {
                if (afterExecution != null) {
                    afterExecution.onFailure(ex);
                } else {
                    LOG.error("Failed to broadcast the master server info message to all nodes.", (Throwable)ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMasterServerInfoSetting(String sendFromOpenSearchNode, MasterServerInfo masterServerInfo) {
        LOG.debug("processMasterServerInfoSetting sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", masterServerInfo=" + masterServerInfo);
        Object object = MASTER_SERVER_LOCK;
        synchronized (object) {
            if (masterServerInfo == null || !masterServerInfo.isMasterServerSet()) {
                LOG.info("No more BPC master server");
                this.masterServerInfo = null;
            } else if (this.masterServerInfo == null || !this.masterServerInfo.getServerUUID().equals(masterServerInfo.getServerUUID())) {
                LOG.info("Setting the BPC server with the following UUID as master: " + masterServerInfo.getServerUUID());
                this.masterServerInfo = masterServerInfo;
                SetAsMasterServerWebsocketMessage setAsMasterServerWebsocketMessage = new SetAsMasterServerWebsocketMessage(masterServerInfo.getServerUUID());
                this.connections.sendWebsocketMessage((WebsocketMessage)setAsMasterServerWebsocketMessage, null);
            } else {
                LOG.info("The BPC server with the following UUID is already set as master: " + masterServerInfo.getServerUUID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAddedOrUpdatedConnection(String sendFromOpenSearchNode, BpcConnection connection) {
        LOG.debug("processAddedOrUpdatedConnection sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", connection=" + connection);
        if (connection != null) {
            this.connections.addOrUpdateConnection(connection);
            Object object = MASTER_SERVER_LOCK;
            synchronized (object) {
                if (this.masterServerInfo == null && connection.hasServerStateInfo()) {
                    this.nodesInfo.ifThisNodeIsTheMasterNode(() -> this.setNextAvailableServerAsMaster(new ActionListener<MasterServerInfo>(){

                        public void onResponse(MasterServerInfo masterServerInfo) {
                            LOG.info("'" + masterServerInfo.getServerUUID() + "' has been set as the new master server (processAddedOrUpdatedConnection).");
                        }

                        public void onFailure(Exception ex) {
                            LOG.error("Failed to set next available server as the new master server (processAddedOrUpdatedConnection).", (Throwable)ex);
                        }
                    }));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemovedConnection(String sendFromOpenSearchNode, BpcConnection connection) {
        LOG.info("processRemovedConnection sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", connection=" + connection);
        if (connection != null) {
            BpcConnection existingConnection;
            String unregisteredServerUUID;
            ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
            String string = unregisteredServerUUID = serverStateInfo != null ? serverStateInfo.getServerUUID() : null;
            if (unregisteredServerUUID != null) {
                ChangesFilterRemoveAllActionDTO removeAllFiltersAction = new ChangesFilterRemoveAllActionDTO(unregisteredServerUUID);
                this.removeAllChangesFilters(removeAllFiltersAction, true);
            }
            if ((existingConnection = this.connections.getConnectionByWebsocketId(connection.getWebsocketId())) != null) {
                this.connections.removeConnection(existingConnection);
                if (serverStateInfo != null) {
                    this.currentReplicationJobs.setThoseAsStoppedUsingServerUUIDs(SetUtil.setOf((Object[])new String[]{serverStateInfo.getServerUUID()}));
                }
            }
            Object object = MASTER_SERVER_LOCK;
            synchronized (object) {
                if (this.masterServerInfo == null || this.masterServerInfo.getServerUUID().equals(unregisteredServerUUID)) {
                    this.nodesInfo.ifThisNodeIsTheMasterNode(() -> this.setNextAvailableServerAsMaster(new ActionListener<MasterServerInfo>(){

                        public void onResponse(MasterServerInfo masterServerInfo) {
                            LOG.info("'" + masterServerInfo.getServerUUID() + "' has been set as the new master server (processRemovedConnection).");
                        }

                        public void onFailure(Exception ex) {
                            LOG.error("Failed to set next available server as the new master server (processRemovedConnection).", (Throwable)ex);
                        }
                    }));
                }
            }
        }
    }

    public void addChangesFilter(ChangesFilterAddActionDTO addFilterAction, boolean informOtherNodes) {
        List<DiscoveryNode> allOtherNodes;
        LOG.debug("addChangesFilter addFilterAction=" + addFilterAction + ", informOtherNodes=" + informOtherNodes);
        boolean added = this.changesFilters.add(addFilterAction.getServerUUID(), addFilterAction.getIndex(), addFilterAction.isSendIndexEventsOnlyForModifiedSources());
        if (added && informOtherNodes && !(allOtherNodes = this.nodesInfo.getAllOtherNodes()).isEmpty()) {
            this.client.execute((ActionType)ChangesFilterAddAction.INSTANCE, (ActionRequest)new ChangesFilterAddRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, addFilterAction), (ActionListener)new ActionListener<ChangesFilterAddResponse>(){

                public void onResponse(ChangesFilterAddResponse changesFilterAddResponse) {
                    if (changesFilterAddResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a add changes filter message to all other nodes.", (Throwable)changesFilterAddResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a add changes filter message to all other nodes. Response: " + changesFilterAddResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a add changes filter message to all other nodes.", (Throwable)ex);
                }
            });
        }
    }

    public void removeAllChangesFilters(ChangesFilterRemoveAllActionDTO removeAllFilterAction, boolean informOtherNodes) {
        List<DiscoveryNode> allOtherNodes;
        LOG.debug("removeAllChangesFilters removeAllFilterAction=" + removeAllFilterAction + ", informOtherNodes=" + informOtherNodes);
        if (this.changesFilters.removeAll(removeAllFilterAction.getServerUUID()) && informOtherNodes && !(allOtherNodes = this.nodesInfo.getAllOtherNodes()).isEmpty()) {
            this.client.execute((ActionType)ChangesFilterRemoveAllAction.INSTANCE, (ActionRequest)new ChangesFilterRemoveAllRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, removeAllFilterAction), (ActionListener)new ActionListener<ChangesFilterRemoveAllResponse>(){

                public void onResponse(ChangesFilterRemoveAllResponse changesFilterRemoveAllResponse) {
                    if (changesFilterRemoveAllResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a remove all changes filters message to all other nodes.", (Throwable)changesFilterRemoveAllResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a remove all changes filters message to all other nodes. Response: " + changesFilterRemoveAllResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a remove all changes filters message to all other nodes.", (Throwable)ex);
                }
            });
        }
    }

    public boolean removeChangesFilter(ChangesFilterRemoveActionDTO removeFilterAction, boolean informOtherNodes) {
        List<DiscoveryNode> allOtherNodes;
        LOG.debug("removeChangesFilter removeFilterAction=" + removeFilterAction + ", informOtherNodes=" + informOtherNodes);
        boolean removed = this.changesFilters.remove(removeFilterAction.getServerUUID(), removeFilterAction.getIndex());
        if (removed && informOtherNodes && !(allOtherNodes = this.nodesInfo.getAllOtherNodes()).isEmpty()) {
            this.client.execute((ActionType)ChangesFilterRemoveAction.INSTANCE, (ActionRequest)new ChangesFilterRemoveRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, removeFilterAction), (ActionListener)new ActionListener<ChangesFilterRemoveResponse>(){

                public void onResponse(ChangesFilterRemoveResponse changesFilterRemoveResponse) {
                    if (changesFilterRemoveResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a remove changes filter message to all other nodes.", (Throwable)changesFilterRemoveResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a remove changes filter message to all other nodes. Response: " + changesFilterRemoveResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a remove changes filter message to all other nodes.", (Throwable)ex);
                }
            });
        }
        return removed;
    }

    public void processAddChangesFilterActionDTO(String sendFromOpenSearchNode, ChangesFilterAddActionDTO addFilterActionDTO) {
        LOG.debug("processAddChangesFilterActionDTO sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", addFilterActionDTO=" + addFilterActionDTO);
        this.addChangesFilter(addFilterActionDTO, false);
    }

    public void processRemoveAllChangesFilterActionDTO(String sendFromOpenSearchNode, ChangesFilterRemoveAllActionDTO removeAllFilterActionDTO) {
        LOG.debug("processRemoveAllChangesFilterActionDTO sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", removeAllFilterActionDTO=" + removeAllFilterActionDTO);
        this.removeAllChangesFilters(removeAllFilterActionDTO, false);
    }

    public void processRemoveChangesFilterActionDTO(String sendFromOpenSearchNode, ChangesFilterRemoveActionDTO removeFilterActionDTO) {
        LOG.debug("processRemoveChangesFilterActionDTO sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", removeFilterActionDTO=" + removeFilterActionDTO);
        this.removeChangesFilter(removeFilterActionDTO, false);
    }

    private Set<String> getAliasesOfIndex(String indexName) {
        return new HashSet<String>(this.clusterService.state().metadata().index(indexName).getAliases().keySet());
    }

    public void onIndexDeleted(String indexName) {
        LOG.debug("onIndexDeleted indexName=" + indexName);
        if (this.connections.hasEntries()) {
            IndexDeletedWebsocketMessage indexDeletedWebsocketMessage = new IndexDeletedWebsocketMessage(indexName);
            this.connections.sendWebsocketMessage((WebsocketMessage)indexDeletedWebsocketMessage, null);
        }
    }

    public void onIndexCreated(String indexName) {
        LOG.debug("onIndexCreated indexName=" + indexName);
        if (this.connections.hasEntries()) {
            IndexCreatedWebsocketMessage indexCreatedWebsocketMessage = new IndexCreatedWebsocketMessage(indexName);
            this.connections.sendWebsocketMessage((WebsocketMessage)indexCreatedWebsocketMessage, null);
        }
    }

    public Map<Engine.Index, Boolean> onPreIndexDocumentOperation(String indexName, Engine.Index index, Map<Engine.Index, Boolean> identicalSourcesMap) {
        LOG.debug("onPreIndexDocumentOperation indexName=" + indexName + ", index=..., identicalSourcesMap=" + identicalSourcesMap);
        if (this.connections.hasEntries()) {
            Set<String> aliasesOfIndex = this.getAliasesOfIndex(indexName);
            String documentId = index.id();
            ChangesFilter filter = this.changesFilters.getFilter(indexName, aliasesOfIndex);
            if (filter != null && filter.isSendIndexEventsOnlyForModifiedSources()) {
                Map currentSource = null;
                try {
                    currentSource = JsonUtil.asMap((BytesReference)index.source());
                }
                catch (IOException ex) {
                    LOG.error("Failed to convert the OpenSearch SOURCE as JSON. This should not be possible. Index: " + indexName + ", ID: " + documentId, (Throwable)ex);
                }
                Map previousSource = null;
                try {
                    GetResponse getResponse = (GetResponse)this.client.prepareGet(indexName, documentId).execute().actionGet();
                    if (getResponse != null) {
                        previousSource = getResponse.getSource();
                    }
                }
                catch (Exception ex) {
                    LOG.error("Could not get the current document.", (Throwable)ex);
                }
                boolean identicalSources = currentSource == null && previousSource == null ? true : (currentSource != null && previousSource == null ? false : (currentSource == null && previousSource != null ? false : currentSource.equals(previousSource)));
                if (identicalSourcesMap == null) {
                    identicalSourcesMap = new HashMap<Engine.Index, Boolean>();
                }
                identicalSourcesMap.put(index, identicalSources);
            }
        }
        return identicalSourcesMap;
    }

    public void onPostIndexDocumentOperation(String indexName, Engine.Index index, Map<Engine.Index, Boolean> identicalSourcesMap) {
        Set<String> aliasesOfIndex;
        ChangesFilter filter;
        LOG.debug("onPostIndexDocumentOperation indexName=" + indexName + ", index=..., identicalSourcesMap=..." + identicalSourcesMap);
        if (this.connections.hasEntries() && (filter = this.changesFilters.getFilter(indexName, aliasesOfIndex = this.getAliasesOfIndex(indexName))) != null) {
            boolean sendChangesEvent;
            if (filter.isSendIndexEventsOnlyForModifiedSources()) {
                if (identicalSourcesMap != null) {
                    boolean identicalSources = identicalSourcesMap.get(index);
                    identicalSourcesMap.remove(index);
                    sendChangesEvent = !identicalSources;
                } else {
                    sendChangesEvent = false;
                }
            } else {
                sendChangesEvent = true;
            }
            if (sendChangesEvent) {
                IndexOperationDTO indexOperation = new IndexOperationDTO(indexName, aliasesOfIndex, index.id(), IndexOperationDTO.Operation.INDEX, index.version(), (Map)XContentHelper.convertToMap((BytesReference)index.source(), (boolean)false, (XContentType)XContentType.JSON).v2());
                this.processIndexOperation(indexOperation);
            }
        }
    }

    public void onDeleteDocumentOperation(String indexName, String documentId, long documentVersion) {
        Set<String> aliasesOfIndex;
        ChangesFilter filter;
        LOG.debug("onDeleteDocumentOperation indexName=" + indexName + ", documentId=" + documentId + ", documentVersion=" + documentVersion);
        if (this.connections.hasEntries() && (filter = this.changesFilters.getFilter(indexName, aliasesOfIndex = this.getAliasesOfIndex(indexName))) != null) {
            IndexOperationDTO indexOperation = new IndexOperationDTO(indexName, aliasesOfIndex, documentId, IndexOperationDTO.Operation.DELETE, documentVersion, null);
            this.processIndexOperation(indexOperation);
        }
    }

    private void processIndexOperation(IndexOperationDTO indexOperation) {
        LOG.debug("processIndexOperation indexOperation=" + indexOperation);
        this.client.execute((ActionType)IndexOperationAction.INSTANCE, (ActionRequest)new IndexOperationRequest(this.nodesInfo.getLocalNodeName(), indexOperation), (ActionListener)new ActionListener<IndexOperationResponse>(){

            public void onResponse(IndexOperationResponse indexOperationResponse) {
                if (indexOperationResponse.hasFailures()) {
                    LOG.error("Failed to broadcast a index operation message to all nodes.", (Throwable)indexOperationResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting a index operation message to all nodes. Response: " + indexOperationResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast an IndexOperation to all nodes.", (Throwable)ex);
            }
        });
    }

    public void sendIndexOperationToConnectedServers(String sendFromOpenSearchNode, IndexOperationDTO indexOperation) {
        LOG.debug("sendIndexOperationToConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", indexOperation=" + indexOperation);
        IndexOperationWebsocketMessage indexOperationWebsocketMessage = new IndexOperationWebsocketMessage(indexOperation);
        this.connections.sendWebsocketMessage((WebsocketMessage)indexOperationWebsocketMessage, null);
    }

    public void processReceivedBroadcastToAllWebsocketMessage(String websocketId, String serverUUID, BroadcastToAllWebsocketMessage websocketMessage) {
        LOG.debug("processReceivedBroadcastToAllWebsocketMessage websocketId=" + websocketId + ", serverUUID=" + serverUUID + ", websocketMessage=" + websocketMessage);
        this.client.execute((ActionType)BroadcastReceivedWebsocketMessageToAllAction.INSTANCE, (ActionRequest)new BroadcastReceivedWebsocketMessageToAllRequest(this.nodesInfo.getLocalNodeName(), websocketId, serverUUID, websocketMessage), (ActionListener)new ActionListener<BroadcastReceivedWebsocketMessageToAllResponse>(){

            public void onResponse(BroadcastReceivedWebsocketMessageToAllResponse broadcastReceivedWebsocketMessageToAllResponse) {
                if (broadcastReceivedWebsocketMessageToAllResponse.hasFailures()) {
                    LOG.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)broadcastReceivedWebsocketMessageToAllResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting a received websocket message to all nodes. Response: " + broadcastReceivedWebsocketMessageToAllResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void forwardWebsocketMessageToConnectedServers(String sendFromOpenSearchNode, BroadcastToAllWebsocketMessage broadcastToAllWebsocketMessage) {
        LOG.debug("forwardWebsocketMessageToConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", broadcastToAllWebsocketMessage=" + broadcastToAllWebsocketMessage);
        PlainTextWebsocketMessage websocketMessageToSend = new PlainTextWebsocketMessage(broadcastToAllWebsocketMessage.getMessage());
        this.connections.sendWebsocketMessage((WebsocketMessage)websocketMessageToSend, null);
    }

    public void processReceivedBroadcastToAllExceptSenderWebsocketMessage(String websocketId, String serverUUID, BroadcastToAllExceptSenderWebsocketMessage websocketMessage) {
        LOG.debug("processReceivedBroadcastToAllExceptSenderWebsocketMessage websocketId=" + websocketId + ", serverUUID=" + serverUUID + ", websocketMessage=" + websocketMessage);
        this.client.execute((ActionType)BroadcastReceivedWebsocketMessageToAllExceptSenderAction.INSTANCE, (ActionRequest)new BroadcastReceivedWebsocketMessageToAllExceptSenderRequest(this.nodesInfo.getLocalNodeName(), websocketId, serverUUID, websocketMessage), (ActionListener)new ActionListener<BroadcastReceivedWebsocketMessageToAllExceptSenderResponse>(){

            public void onResponse(BroadcastReceivedWebsocketMessageToAllExceptSenderResponse broadcastReceivedWebsocketMessageToAllExceptSenderResponse) {
                if (broadcastReceivedWebsocketMessageToAllExceptSenderResponse.hasFailures()) {
                    LOG.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)broadcastReceivedWebsocketMessageToAllExceptSenderResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting a received websocket message to all nodes. Response: " + broadcastReceivedWebsocketMessageToAllExceptSenderResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to send a broadcast to all except sender websocket message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void forwardWebsocketMessageToConnectedServers(String sendFromOpenSearchNode, BroadcastToAllExceptSenderWebsocketMessage websocketMessage, String senderServerUUID) {
        LOG.debug("forwardWebsocketMessageToConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", websocketMessage=" + websocketMessage + ", senderServerUUID=" + senderServerUUID);
        PlainTextWebsocketMessage websocketMessageToSend = new PlainTextWebsocketMessage(websocketMessage.getMessage());
        this.connections.sendWebsocketMessage((WebsocketMessage)websocketMessageToSend, Collections.singletonList(senderServerUUID));
    }

    public void processReceivedBroadcastToWebsocketMessage(String websocketId, String serverUUID, BroadcastToWebsocketMessage websocketMessage) {
        LOG.debug("processReceivedBroadcastToWebsocketMessage websocketId=" + websocketId + ", serverUUID=" + serverUUID + ", websocketMessage=" + websocketMessage);
        this.client.execute((ActionType)BroadcastReceivedWebsocketMessageToAction.INSTANCE, (ActionRequest)new BroadcastReceivedWebsocketMessageToRequest(this.nodesInfo.getLocalNodeName(), websocketId, serverUUID, websocketMessage), (ActionListener)new ActionListener<BroadcastReceivedWebsocketMessageToResponse>(){

            public void onResponse(BroadcastReceivedWebsocketMessageToResponse broadcastReceivedWebsocketMessageToResponse) {
                if (broadcastReceivedWebsocketMessageToResponse.hasFailures()) {
                    LOG.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)broadcastReceivedWebsocketMessageToResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting a received websocket message to all nodes. Response: " + broadcastReceivedWebsocketMessageToResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to send a broadcast to websocket message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void forwardWebsocketMessageToConnectedServers(String sendFromOpenSearchNode, BroadcastToWebsocketMessage websocketMessage) {
        LOG.debug("forwardWebsocketMessageToConnectedServer sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", websocketMessage=" + websocketMessage);
        PlainTextWebsocketMessage websocketMessageToSend = new PlainTextWebsocketMessage(websocketMessage.getMessage());
        this.connections.sendWebsocketMessageToServerUUIDs((WebsocketMessage)websocketMessageToSend, websocketMessage.getReceivers());
    }

    public void queueAsLatestReplicationJobs(String sendFromOpenSearchNode, ReplicationJobs latestJobs) {
        LOG.debug("queueAsLatestReplicationJobs sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", latestJobs=" + latestJobs);
        if (latestJobs != null) {
            this.queuedReplicationJobs = latestJobs;
        }
    }

    private void sendReplicationJobsToAllOtherNodes(ReplicationJobs replicationJobs, final ActionListener<ReplicationJobsSetModelResponse> afterExecution) {
        LOG.debug("sendReplicationJobsToAllOtherNodes replicationJobs=..., afterExecution=...");
        List<DiscoveryNode> allOtherNodes = this.nodesInfo.getAllOtherNodes();
        if (!allOtherNodes.isEmpty()) {
            this.client.execute((ActionType)ReplicationJobsSetModelAction.INSTANCE, (ActionRequest)new ReplicationJobsSetModelRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, replicationJobs), (ActionListener)new ActionListener<ReplicationJobsSetModelResponse>(){

                public void onResponse(ReplicationJobsSetModelResponse replicationJobsSetModelResponse) {
                    if (afterExecution != null) {
                        if (replicationJobsSetModelResponse.hasFailures()) {
                            OpenSearchException aggregatedException = replicationJobsSetModelResponse.createAggregatedException();
                            LOG.error("Failed to broadcast the replication jobs message to all nodes.", (Throwable)aggregatedException);
                            afterExecution.onFailure((Exception)aggregatedException);
                        } else {
                            afterExecution.onResponse((Object)replicationJobsSetModelResponse);
                        }
                    } else if (replicationJobsSetModelResponse.hasFailures()) {
                        LOG.error("Failed to broadcast the replication jobs message to all nodes.", (Throwable)replicationJobsSetModelResponse.createAggregatedException());
                    }
                }

                public void onFailure(Exception ex) {
                    if (afterExecution != null) {
                        afterExecution.onFailure(ex);
                    } else {
                        LOG.error("Failed to broadcast the replication jobs message to all nodes.", (Throwable)ex);
                    }
                }
            });
        }
    }

    public void processReceivedReplicationJobs(ReplicationJobs latestJobs, final ActionListener<ReplicationJobsSetResponse> afterExecution) {
        LOG.debug("processReceivedReplicationJobs latestJobs=" + latestJobs + ", afterExecution=" + afterExecution);
        this.client.execute((ActionType)ReplicationJobsSetAction.INSTANCE, (ActionRequest)new ReplicationJobsSetRequest(this.nodesInfo.getLocalNodeName(), latestJobs), (ActionListener)new ActionListener<ReplicationJobsSetResponse>(){

            public void onResponse(ReplicationJobsSetResponse replicationJobsSetResponse) {
                if (replicationJobsSetResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobsSetResponse.createAggregatedException();
                    LOG.error("Failed to broadcast the replication jobs to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobsSetResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast the replication jobs to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void stopReplicationJobsOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobStopActions stopActions) {
        LOG.debug("stopReplicationJobsOnConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", stopActions=" + stopActions);
        for (ReplicationJobStopAction stopAction : stopActions) {
            ReplicationJobStopActionWebsocketMessage replicationJobActionWebsocketMessage = new ReplicationJobStopActionWebsocketMessage(stopAction.getReplicationJobId(), stopAction.getServerUUID());
            LOG.info("Sending a websocket message to the BPC server with the UUID '" + replicationJobActionWebsocketMessage.getServerUUID() + "' to stop the replication job with the ID '" + replicationJobActionWebsocketMessage.getJobId() + "'.");
            this.connections.sendWebsocketMessageToServerUUID((WebsocketMessage)replicationJobActionWebsocketMessage, replicationJobActionWebsocketMessage.getServerUUID());
        }
    }

    public void startReplicationJobsOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobStartActions startActions) {
        LOG.debug("startReplicationJobsOnConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", startActions=" + startActions);
        for (ReplicationJobStartAction startAction : startActions) {
            ReplicationJobStartActionWebsocketMessage replicationJobActionWebsocketMessage = new ReplicationJobStartActionWebsocketMessage(startAction.getReplicationJobId(), startAction.getServerUUID());
            LOG.info("Sending a websocket message to the BPC server with the UUID '" + replicationJobActionWebsocketMessage.getServerUUID() + "' to start the replication job with the ID '" + replicationJobActionWebsocketMessage.getJobId() + "'.");
            this.connections.sendWebsocketMessageToServerUUID((WebsocketMessage)replicationJobActionWebsocketMessage, replicationJobActionWebsocketMessage.getServerUUID());
        }
    }

    public void onForcedStartOfReplicationJobAction(ReplicationJobForcedStartActionDTO forcedStartAction, final ActionListener<ReplicationJobForcedStartResponse> afterExecution) {
        LOG.debug("onForcedStartOfReplicationJobAction forcedStartAction=" + forcedStartAction + ", afterExecution=" + afterExecution);
        this.client.execute((ActionType)ReplicationJobForcedStartAction.INSTANCE, (ActionRequest)new ReplicationJobForcedStartRequest(this.nodesInfo.getLocalNodeName(), forcedStartAction), (ActionListener)new ActionListener<ReplicationJobForcedStartResponse>(){

            public void onResponse(ReplicationJobForcedStartResponse replicationJobForcedStartResponse) {
                if (replicationJobForcedStartResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobForcedStartResponse.createAggregatedException();
                    LOG.error("Failed to broadcast the forced start of a replication job action to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobForcedStartResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast the forced start of a replication job action to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void forcedStartOfReplicationJobOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobForcedStartActionDTO forcedStartAction) {
        LOG.debug("forcedStartOfReplicationJobOnConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", forcedStartAction=" + forcedStartAction);
        ReplicationJobForcedStartWebsocketMessage replicationJobForcedStartWebsocketMessage = new ReplicationJobForcedStartWebsocketMessage(forcedStartAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)replicationJobForcedStartWebsocketMessage, null);
    }

    public void onRestartOfReplicationJobAction(ReplicationJobRestartActionDTO restartAction, final ActionListener<ReplicationJobRestartResponse> afterExecution) {
        LOG.debug("onRestartOfReplicationJobAction restartAction=" + restartAction + ", afterExecution=" + afterExecution);
        this.client.execute((ActionType)ReplicationJobRestartAction.INSTANCE, (ActionRequest)new ReplicationJobRestartRequest(this.nodesInfo.getLocalNodeName(), restartAction), (ActionListener)new ActionListener<ReplicationJobRestartResponse>(){

            public void onResponse(ReplicationJobRestartResponse replicationJobRestartResponse) {
                if (replicationJobRestartResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobRestartResponse.createAggregatedException();
                    LOG.error("Failed to broadcast the replication job restart action to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobRestartResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast the replication job restart action to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void restartOfReplicationJobOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobRestartActionDTO restartAction) {
        LOG.debug("restartOfReplicationJobOnConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", restartAction=" + restartAction);
        ReplicationJobRestartWebsocketMessage replicationJobRestartWebsocketMessage = new ReplicationJobRestartWebsocketMessage(restartAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)replicationJobRestartWebsocketMessage, null);
    }

    public void onRefreshLookupJoinsOfReplicationJobAction(ReplicationJobRefreshLookupJoinsActionDTO refreshLookupJoinsAction, final ActionListener<ReplicationJobRefreshLookupJoinsResponse> afterExecution) {
        LOG.debug("onRefreshLookupJoinsOfReplicationJobAction refreshLookupJoinsAction=" + refreshLookupJoinsAction + ", afterExecution=" + afterExecution);
        this.client.execute((ActionType)ReplicationJobRefreshLookupJoinsAction.INSTANCE, (ActionRequest)new ReplicationJobRefreshLookupJoinsRequest(this.nodesInfo.getLocalNodeName(), refreshLookupJoinsAction), (ActionListener)new ActionListener<ReplicationJobRefreshLookupJoinsResponse>(){

            public void onResponse(ReplicationJobRefreshLookupJoinsResponse replicationJobRefreshLookupJoinsResponse) {
                if (replicationJobRefreshLookupJoinsResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobRefreshLookupJoinsResponse.createAggregatedException();
                    LOG.error("Failed to broadcast the refresh lookup joins of replication job action to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobRefreshLookupJoinsResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast the refresh lookup joins of replication job action to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void refreshLookupJoinsOfReplicationJobOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobRefreshLookupJoinsActionDTO refreshLookupJoinsAction) {
        LOG.debug("restartOfReplicationJobOnConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", refreshLookupJoinsAction=" + refreshLookupJoinsAction);
        RefreshLookupJoinsOfReplicationJobWebsocketMessage refreshLookupJoinsOfReplicationJobWebsocketMessage = new RefreshLookupJoinsOfReplicationJobWebsocketMessage(refreshLookupJoinsAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)refreshLookupJoinsOfReplicationJobWebsocketMessage, null);
    }

    public void onRefreshLookupJoinsOfAllReplicationJobsAction(ReplicationJobsRefreshLookupJoinsActionDTO refreshLookupJoinsAction, final ActionListener<ReplicationJobsRefreshAllLookupJoinsResponse> afterExecution) {
        LOG.debug("onRefreshLookupJoinsOfAllReplicationJobsAction refreshLookupJoinsAction=" + refreshLookupJoinsAction + ", afterExecution=" + afterExecution);
        this.client.execute((ActionType)ReplicationJobsRefreshAllLookupJoinsAction.INSTANCE, (ActionRequest)new ReplicationJobsRefreshAllLookupJoinsRequest(this.nodesInfo.getLocalNodeName(), refreshLookupJoinsAction), (ActionListener)new ActionListener<ReplicationJobsRefreshAllLookupJoinsResponse>(){

            public void onResponse(ReplicationJobsRefreshAllLookupJoinsResponse replicationJobsRefreshAllLookupJoinsResponse) {
                if (replicationJobsRefreshAllLookupJoinsResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobsRefreshAllLookupJoinsResponse.createAggregatedException();
                    LOG.error("Failed to broadcast the refresh lookup joins of all replication jobs to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobsRefreshAllLookupJoinsResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast the refresh lookup joins of all replication jobs to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void refreshLookupJoinsOfAllReplicationJobsOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobsRefreshLookupJoinsActionDTO refreshLookupJoinsAction) {
        LOG.debug("refreshLookupJoinsOfAllReplicationJobsOnConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", refreshLookupJoinsAction=" + refreshLookupJoinsAction);
        RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage refreshLookupJoinsOfAllReplicationJobsWebsocketMessage = new RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage(refreshLookupJoinsAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)refreshLookupJoinsOfAllReplicationJobsWebsocketMessage, null);
    }

    public void onClearLookupJoinCachesOfReplicationJobsAction(ReplicationJobsClearLookupJoinCachesActionDTO clearLookupJoinCachesAction, final ActionListener<ReplicationJobsClearLookupJoinCachesResponse> afterExecution) {
        LOG.debug("onClearLookupJoinCachesOfReplicationJobsAction clearLookupJoinCachesAction=" + clearLookupJoinCachesAction + ", afterExecution=" + afterExecution);
        this.client.execute((ActionType)ReplicationJobsClearLookupJoinCachesAction.INSTANCE, (ActionRequest)new ReplicationJobsClearLookupJoinCachesRequest(this.nodesInfo.getLocalNodeName(), clearLookupJoinCachesAction), (ActionListener)new ActionListener<ReplicationJobsClearLookupJoinCachesResponse>(){

            public void onResponse(ReplicationJobsClearLookupJoinCachesResponse replicationJobsClearLookupJoinCachesResponse) {
                if (replicationJobsClearLookupJoinCachesResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobsClearLookupJoinCachesResponse.createAggregatedException();
                    LOG.error("Failed to broadcast the clear lookup join caches of replication jobs action to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobsClearLookupJoinCachesResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast the clear lookup join caches of replication jobs action to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void clearLookupJoinCachesOfReplicationJobsOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobsClearLookupJoinCachesActionDTO clearLookupJoinCachesAction) {
        LOG.debug("clearLookupJoinCachesOfReplicationJobsOnConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", clearLookupJoinCachesAction=" + clearLookupJoinCachesAction);
        ClearLookupJoinCachesOfReplicationJobsWebsocketMessage clearLookupJoinCachesOfReplicationJobsWebsocketMessage = new ClearLookupJoinCachesOfReplicationJobsWebsocketMessage(clearLookupJoinCachesAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)clearLookupJoinCachesOfReplicationJobsWebsocketMessage, null);
    }

    public ReplicationJobsWithRuntimeStatsFromAllServersDTO getReplicationJobStatsFromConnectedServers(String sendFromOpenSearchNode, ReplicationJobStatsGetActionDTO replicationJobStatsGetAction) {
        LOG.debug("getReplicationJobStatsFromConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", replicationJobStatsGetAction=" + replicationJobStatsGetAction);
        final String communicationId = replicationJobStatsGetAction.getCommunicationId();
        ReplicationJobStatsRequestWebsocketMessage requestWebsocketMessage = new ReplicationJobStatsRequestWebsocketMessage(communicationId);
        try {
            this.connections.sendWebsocketMessage((WebsocketMessage)requestWebsocketMessage, null, new BpcConnections.PreSendWebsocketMessagesCallback(){

                @Override
                public void goingToSendNumberOfWebsocketMessages(int numberOfWebsocketMessages) {
                    Manager.this.replicationJobStatsRequests.prepareFor(communicationId, numberOfWebsocketMessages);
                }
            }, new BpcConnections.PostSendWebsocketMessagesCallback(){

                @Override
                public void websocketMessagesSent(int successful, int failed) {
                    Manager.this.replicationJobStatsRequests.updateForSentWebsocketMessages(communicationId, successful, failed);
                }
            });
            this.replicationJobStatsRequests.await(communicationId);
            ReplicationJobsWithRuntimeStatsFromAllServersDTO replicationJobStatsFromConnectedServers = this.replicationJobStatsRequests.getAndRemove(communicationId);
            return replicationJobStatsFromConnectedServers;
        }
        catch (Exception ex) {
            this.replicationJobStatsRequests.remove(communicationId);
            throw new OpenSearchException((Throwable)ex);
        }
    }

    public void processReceivedReplicationJobStatsResponseWebsocketMessage(String websocketId, ReplicationJobStatsResponseWebsocketMessage replicationJobStatsResponseWebsocketMessage) {
        LOG.debug("processReceivedReplicationJobStatsResponseWebsocketMessage websocketId=" + websocketId + ", replicationJobStatsResponseWebsocketMessage=" + replicationJobStatsResponseWebsocketMessage);
        if (replicationJobStatsResponseWebsocketMessage != null) {
            this.replicationJobStatsRequests.handleReceivedReplicationJobStats(replicationJobStatsResponseWebsocketMessage.getCommunicationId(), replicationJobStatsResponseWebsocketMessage.getReplicationJobStats());
        }
    }

    private static class ReplicationJobStatsRequest {
        private final CountDownLatch websocketMessagesCountDownLatch;
        private final ReplicationJobsWithRuntimeStatsFromAllServersDTO replicationJobStatsFromServers;

        public ReplicationJobStatsRequest(int numberOfExpectedWebsocketMessages) {
            LOG.debug(this.getClass().getSimpleName() + " numberOfExpectedWebsocketMessages=" + numberOfExpectedWebsocketMessages);
            this.websocketMessagesCountDownLatch = new CountDownLatch(numberOfExpectedWebsocketMessages);
            this.replicationJobStatsFromServers = new ReplicationJobsWithRuntimeStatsFromAllServersDTO();
        }

        public void updateForSentWebsocketMessages(int successful, int failed) {
            LOG.debug(this.getClass().getSimpleName() + ".updateForSentWebsocketMessages successful=" + successful + ", failed=" + failed);
            for (int i = 0; i < failed; ++i) {
                this.websocketMessagesCountDownLatch.countDown();
            }
        }

        public void handleReceivedReplicationJobStats(ReplicationJobsWithRuntimeStatsFromServerDTO replicationJobsWithRuntimeStatsFromServer) {
            LOG.debug(this.getClass().getSimpleName() + ".handleReceivedReplicationJobsStats replicationJobsWithRuntimeStatsFromServer=" + replicationJobsWithRuntimeStatsFromServer);
            this.replicationJobStatsFromServers.add(replicationJobsWithRuntimeStatsFromServer);
            this.websocketMessagesCountDownLatch.countDown();
        }

        public void await() throws InterruptedException {
            LOG.debug(this.getClass().getSimpleName() + ".await");
            this.websocketMessagesCountDownLatch.await(30L, TimeUnit.SECONDS);
        }

        public ReplicationJobsWithRuntimeStatsFromAllServersDTO getReplicationJobStatsFromServers() {
            LOG.debug(this.getClass().getSimpleName() + ".getReplicationJobStatsFromServers");
            return this.replicationJobStatsFromServers;
        }
    }

    private static class ReplicationJobStatsRequests {
        private final Map<String, ReplicationJobStatsRequest> entries = new HashMap<String, ReplicationJobStatsRequest>();

        public void prepareFor(String communicationId, int numberOfExpectedWebsocketMessages) {
            LOG.debug(this.getClass().getSimpleName() + ".prepareFor communicationId=" + communicationId + ", numberOfExpectedWebsocketMessages=" + numberOfExpectedWebsocketMessages);
            this.entries.put(communicationId, new ReplicationJobStatsRequest(numberOfExpectedWebsocketMessages));
        }

        public void updateForSentWebsocketMessages(String communicationId, int successful, int failed) {
            LOG.debug(this.getClass().getSimpleName() + ".updateForSentWebsocketMessages communicationId=" + communicationId + ", successful=" + successful + ", failed=" + failed);
            this.entries.get(communicationId).updateForSentWebsocketMessages(successful, failed);
        }

        public void handleReceivedReplicationJobStats(String communicationId, ReplicationJobsWithRuntimeStatsFromServerDTO replicationJobsWithRuntimeStatsFromServer) {
            LOG.debug(this.getClass().getSimpleName() + ".handleReceivedReplicationJobsStats communicationId=" + communicationId + ", replicationJobsWithRuntimeStatsFromServer=" + replicationJobsWithRuntimeStatsFromServer);
            this.entries.get(communicationId).handleReceivedReplicationJobStats(replicationJobsWithRuntimeStatsFromServer);
        }

        public void await(String communicationId) throws InterruptedException {
            LOG.debug(this.getClass().getSimpleName() + ".await communicationId=" + communicationId);
            this.entries.get(communicationId).await();
        }

        public ReplicationJobsWithRuntimeStatsFromAllServersDTO getAndRemove(String communicationId) {
            LOG.debug(this.getClass().getSimpleName() + ".getAndRemove communicationId=" + communicationId);
            ReplicationJobStatsRequest replicationJobStatsRequest = this.entries.remove(communicationId);
            return replicationJobStatsRequest.getReplicationJobStatsFromServers();
        }

        public void remove(String communicationId) {
            LOG.debug(this.getClass().getSimpleName() + ".remove communicationId=" + communicationId);
            this.entries.remove(communicationId);
        }
    }

    private class ReplicationJobsOrchestrationCheckerRunnable
    implements Runnable {
        private final Logger LOG = Loggers.getLogger(ReplicationJobsOrchestrationCheckerRunnable.class, (String[])new String[]{"os-bpc-plugin"});

        private ReplicationJobsOrchestrationCheckerRunnable() {
        }

        @Override
        public void run() {
            this.LOG.debug("Running ...");
            if (!Manager.this.connections.hasEntries()) {
                if (!Manager.this.currentReplicationJobs.isEmpty()) {
                    Manager.this.currentReplicationJobs.clear();
                    Manager.this.connectionsLastUpdatedProcessedByChecker = -1L;
                    Manager.this.queuedReplicationJobs = null;
                    this.LOG.debug("Nothing to do ... there are no BPC connections (cleared the replication jobs)");
                } else {
                    this.LOG.debug("Nothing to do ... there are no BPC connections");
                }
                return;
            }
            Manager.this.nodesInfo.ifThisNodeIsTheMasterNodeOrElse(() -> this.doTheOrchestration(true), () -> this.LOG.debug("Nothing to do ... only the master node runs the replication jobs orchestration"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doTheOrchestration(boolean thisIsTheMasterNode) {
            this.LOG.debug("doTheOrchestration thisIsTheMasterNode=" + thisIsTheMasterNode);
            if (Manager.this.replicationJobsOrchestrationRunning) {
                this.LOG.debug("Nothing to do ... an replication jobs orchestration is already running");
            } else {
                Manager.this.replicationJobsOrchestrationRunning = true;
                try {
                    if (Manager.this.queuedReplicationJobs != null) {
                        ReplicationJobs replicationJobsToProcess = Manager.this.queuedReplicationJobs;
                        Manager.this.queuedReplicationJobs = null;
                        this.processReplicationJobs(replicationJobsToProcess, thisIsTheMasterNode);
                    } else {
                        long connectionsLastUpdated = Manager.this.connections.getLastUpdated();
                        if (connectionsLastUpdated == -1L) {
                            this.LOG.debug("Nothing to do ... the BPC connections are not initialized yet");
                            return;
                        }
                        if (connectionsLastUpdated == Manager.this.connectionsLastUpdatedProcessedByChecker) {
                            this.LOG.debug("Nothing to do ... the BPC connections are already processed");
                            return;
                        }
                        long millisecondsPassedSinceLastConnectionUpdate = System.currentTimeMillis() - connectionsLastUpdated;
                        if (millisecondsPassedSinceLastConnectionUpdate < 15000L) {
                            this.LOG.debug("Nothing to do ... it is too early to run an replication jobs orchestration. Gets done in " + (15000L - millisecondsPassedSinceLastConnectionUpdate) / 1000L + " seconds.");
                            return;
                        }
                        this.redistributeReplicationJobsOnChangedConnections(thisIsTheMasterNode);
                        Manager.this.connectionsLastUpdatedProcessedByChecker = connectionsLastUpdated;
                    }
                }
                catch (Throwable t) {
                    this.LOG.error("Failed to perform the replication jobs orchestration check.", t);
                }
                finally {
                    Manager.this.replicationJobsOrchestrationRunning = false;
                }
            }
        }

        private void redistributeReplicationJobsOnChangedConnections(boolean thisIsTheMasterNode) {
            this.LOG.debug("redistributeReplicationJobsOnChangedConnections thisIsTheMasterNode=" + thisIsTheMasterNode);
            if (!thisIsTheMasterNode) {
                return;
            }
            Set<String> serversAvailable = Manager.this.connections.getServerUUIDsOfServersAvailableForReplication();
            ReplicationJobsOrchestrator orchestrator = new ReplicationJobsOrchestrator(Manager.this.currentReplicationJobs);
            orchestrator.updateStateOfReplicationJobsOfNoLongerConnectedServers(serversAvailable);
            if (orchestrator.areJobsEquallyDistributed(serversAvailable)) {
                this.LOG.debug("Nothing to do ... the replication jobs are already equally distributed.");
                return;
            }
            ReplicationJobStopActions stopActions = orchestrator.getReplicationJobStopActions(serversAvailable);
            if (!stopActions.isEmpty()) {
                Manager.this.client.execute((ActionType)ReplicationJobStopActionsAction.INSTANCE, (ActionRequest)new ReplicationJobStopActionsRequest(Manager.this.nodesInfo.getLocalNodeName(), stopActions), (ActionListener)new ActionListener<ReplicationJobStopActionsResponse>(){

                    public void onResponse(ReplicationJobStopActionsResponse replicationJobStopActionsResponse) {
                        if (replicationJobStopActionsResponse.hasFailures()) {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOG.error("Failed to broadcast the replication job stop actions to all nodes.", (Throwable)replicationJobStopActionsResponse.createAggregatedException());
                        } else {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOG.debug("Done broadcasting the replication job stop actions to all nodes. Response: " + replicationJobStopActionsResponse);
                        }
                    }

                    public void onFailure(Exception ex) {
                        ReplicationJobsOrchestrationCheckerRunnable.this.LOG.error("Failed to broadcast the replication job stop actions to all nodes.", (Throwable)ex);
                    }
                });
            } else {
                this.LOG.debug("Nothing to do ... there are no replication job stop actions to send to all nodes.");
            }
            Manager.this.currentReplicationJobs.updateWithStopActions(stopActions, null);
            ReplicationJobStartActions startActions = orchestrator.getReplicationJobStartActions(serversAvailable);
            if (!startActions.isEmpty()) {
                Manager.this.client.execute((ActionType)ReplicationJobStartActionsAction.INSTANCE, (ActionRequest)new ReplicationJobStartActionsRequest(Manager.this.nodesInfo.getLocalNodeName(), startActions), (ActionListener)new ActionListener<ReplicationJobStartActionsResponse>(){

                    public void onResponse(ReplicationJobStartActionsResponse replicationJobStartActionsResponse) {
                        if (replicationJobStartActionsResponse.hasFailures()) {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOG.error("Failed to broadcast the replication job start actions to all nodes.", (Throwable)replicationJobStartActionsResponse.createAggregatedException());
                        } else {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOG.debug("Done broadcasting the replication job start actions to all nodes. Response: " + replicationJobStartActionsResponse);
                        }
                    }

                    public void onFailure(Exception ex) {
                        ReplicationJobsOrchestrationCheckerRunnable.this.LOG.error("Failed to broadcast the replication job start actions to all nodes.", (Throwable)ex);
                    }
                });
            } else {
                this.LOG.debug("Nothing to do ... there are no replication job start actions to send to all nodes.");
            }
            Manager.this.currentReplicationJobs.updateWithStartActions(startActions, null);
            Manager.this.sendReplicationJobsToAllOtherNodes(Manager.this.currentReplicationJobs, null);
        }

        private void processReplicationJobs(ReplicationJobs latestJobs, boolean thisIsTheMasterNode) {
            this.LOG.debug("processReplicationJobs latestJobs=" + latestJobs + ", thisIsTheMasterNode=" + thisIsTheMasterNode);
            if (!thisIsTheMasterNode) {
                return;
            }
            Set<String> serversAvailable = Manager.this.connections.getServerUUIDsOfServersAvailableForReplication();
            ReplicationJobsOrchestrator orchestrator = new ReplicationJobsOrchestrator(Manager.this.currentReplicationJobs);
            orchestrator.updateStateOfReplicationJobsOfNoLongerConnectedServers(serversAvailable);
            ReplicationJobStopActions stopActions = orchestrator.getReplicationJobStopActions(latestJobs, serversAvailable);
            if (!stopActions.isEmpty()) {
                Manager.this.client.execute((ActionType)ReplicationJobStopActionsAction.INSTANCE, (ActionRequest)new ReplicationJobStopActionsRequest(Manager.this.nodesInfo.getLocalNodeName(), stopActions), (ActionListener)new ActionListener<ReplicationJobStopActionsResponse>(){

                    public void onResponse(ReplicationJobStopActionsResponse replicationJobStopActionsResponse) {
                        if (replicationJobStopActionsResponse.hasFailures()) {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOG.error("Failed to broadcast the replication job stop actions to all nodes.", (Throwable)replicationJobStopActionsResponse.createAggregatedException());
                        } else {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOG.debug("Done broadcasting the replication job stop actions to all nodes. Response: " + replicationJobStopActionsResponse);
                        }
                    }

                    public void onFailure(Exception ex) {
                        ReplicationJobsOrchestrationCheckerRunnable.this.LOG.error("Failed to broadcast the replication job stop actions to all nodes.", (Throwable)ex);
                    }
                });
            } else {
                this.LOG.debug("Nothing to do ... there are no replication job stop actions to send to all nodes.");
            }
            Manager.this.currentReplicationJobs.updateWithStopActions(stopActions, latestJobs);
            ReplicationJobStartActions startActions = orchestrator.getReplicationJobStartActions(latestJobs, serversAvailable);
            if (!startActions.isEmpty()) {
                Manager.this.client.execute((ActionType)ReplicationJobStartActionsAction.INSTANCE, (ActionRequest)new ReplicationJobStartActionsRequest(Manager.this.nodesInfo.getLocalNodeName(), startActions), (ActionListener)new ActionListener<ReplicationJobStartActionsResponse>(){

                    public void onResponse(ReplicationJobStartActionsResponse replicationJobStartActionsResponse) {
                        if (replicationJobStartActionsResponse.hasFailures()) {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOG.error("Failed to broadcast the replication job start actions to all nodes.", (Throwable)replicationJobStartActionsResponse.createAggregatedException());
                        } else {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOG.debug("Done broadcasting the replication job start actions to all nodes. Response: " + replicationJobStartActionsResponse);
                        }
                    }

                    public void onFailure(Exception ex) {
                        ReplicationJobsOrchestrationCheckerRunnable.this.LOG.error("Failed to broadcast the replication job start actions to all nodes.", (Throwable)ex);
                    }
                });
            } else {
                this.LOG.debug("Nothing to do ... there are no replication job start actions to send to all nodes.");
            }
            Manager.this.currentReplicationJobs.updateWithStartActions(startActions, latestJobs);
            Manager.this.sendReplicationJobsToAllOtherNodes(Manager.this.currentReplicationJobs, null);
        }
    }
}

