/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJob
implements OpenSearchPluginDTO {
    private static final Logger LOG = Loggers.getLogger(ReplicationJob.class, (String[])new String[]{"os-bpc-plugin"});
    private final String id;
    private boolean enabled;
    private int settingsHash;
    private String serverUUID;
    private State state;

    public ReplicationJob(ReplicationJob fromJob) {
        this(fromJob.id, fromJob.enabled, fromJob.settingsHash, fromJob.serverUUID, fromJob.state);
    }

    public ReplicationJob(Map<String, Object> replicationJobData) {
        this(MapUtil.getValueAsString(replicationJobData, (String)"id", null), MapUtil.getValueAsBoolean(replicationJobData, (String)"enabled", (boolean)true), MapUtil.getValueAsInteger(replicationJobData, (String)"settingsHash", null), MapUtil.getValueAsString(replicationJobData, (String)"serverUUID", null), State.valueOf(MapUtil.getValueAsString(replicationJobData, (String)"state", (String)"STOPPED")));
    }

    public ReplicationJob(String id, boolean enabled, int settingsHash) {
        this(id, enabled, settingsHash, null, State.STOPPED);
    }

    public ReplicationJob(String id, boolean enabled, Integer settingsHash, String serverUUID, State state) {
        if (StringUtil.isNullOrEmpty((String)id)) {
            throw new NullPointerException("The 'id' cannot be null or empty");
        }
        Objects.requireNonNull(settingsHash, "settingsHash must not be null");
        this.id = id;
        this.enabled = enabled;
        this.settingsHash = settingsHash;
        this.serverUUID = enabled ? serverUUID : null;
        this.state = enabled ? state : State.STOPPED;
    }

    public ReplicationJob(StreamInput in) throws IOException {
        this.id = in.readString();
        this.enabled = in.readBoolean();
        this.settingsHash = in.readInt();
        this.serverUUID = in.readOptionalString();
        this.state = (State)in.readEnum(State.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBoolean(this.enabled);
        out.writeInt(this.settingsHash);
        out.writeOptionalString(this.serverUUID);
        out.writeEnum((Enum)this.state);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("enabled", this.enabled);
        builder.field("settingsHash", this.settingsHash);
        builder.field("serverUUID", this.serverUUID);
        builder.field("state", this.state.name());
        builder.endObject();
        return builder;
    }

    public static ReplicationJob fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJob(parser.map());
    }

    public boolean isRunningOnSomeServer() {
        if (this.state == State.STARTING || this.state == State.RUNNING) {
            return !StringUtil.isNullOrEmpty((String)this.serverUUID);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.setAsStopped();
        }
    }

    public int getSettingsHash() {
        return this.settingsHash;
    }

    public void setSettingsHash(int settingsHash) {
        this.settingsHash = settingsHash;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public void setServerUUID(String serverUUID) {
        this.serverUUID = serverUUID;
    }

    public State getState() {
        return this.state;
    }

    public void setAsStopped() {
        this.state = State.STOPPED;
        this.serverUUID = null;
    }

    public void setAsRunningOnServer(String serverUUID) {
        if (StringUtil.isNullOrEmpty((String)serverUUID)) {
            this.setAsStopped();
        } else {
            this.state = State.RUNNING;
            this.serverUUID = serverUUID;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJob that = (ReplicationJob)o;
        return this.enabled == that.enabled && this.settingsHash == that.settingsHash && Objects.equals(this.id, that.id) && Objects.equals(this.serverUUID, that.serverUUID) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ReplicationJob{id='" + this.id + "', enabled=" + this.enabled + ", settingsHash=" + this.settingsHash + ", serverUUID='" + this.serverUUID + "', state=" + this.state + "}";
    }

    public static enum State {
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

