/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopAction;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class ReplicationJobStopActions
implements Iterable<ReplicationJobStopAction>,
OpenSearchPluginDTO {
    private static final Logger LOG = Loggers.getLogger(ReplicationJobStopActions.class, (String[])new String[]{"os-bpc-plugin"});
    private final List<ReplicationJobStopAction> actions = new ArrayList<ReplicationJobStopAction>();

    public ReplicationJobStopActions() {
    }

    public ReplicationJobStopActions(Map<String, Object> replicationJobActionsMap) {
        this();
        this.actions.addAll(MapUtil.getArrayValueAsListOfObjects(replicationJobActionsMap, (String)"entries", ReplicationJobStopAction.class));
    }

    public ReplicationJobStopActions(StreamInput in) throws IOException {
        this();
        this.actions.addAll(in.readList(ReplicationJobStopAction::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.actions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("entries");
        for (ReplicationJobStopAction action : this.actions) {
            action.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public int size() {
        return this.actions.size();
    }

    public void add(ReplicationJobStopAction action) {
        if (action != null && !this.existsForReplicationJobId(action.getReplicationJobId())) {
            this.actions.add(action);
        }
    }

    public boolean existsForReplicationJobId(String replicationJobId) {
        return this.getByReplicationJobId(replicationJobId) != null;
    }

    public ReplicationJobStopAction getByReplicationJobId(String replicationJobId) {
        if (!StringUtil.isNullOrEmpty((String)replicationJobId)) {
            for (ReplicationJobStopAction action : this.actions) {
                if (!replicationJobId.equals(action.getReplicationJobId())) continue;
                return action;
            }
        }
        return null;
    }

    public List<ReplicationJobStopAction> getByServerUUID(String serverUUID) {
        ArrayList<ReplicationJobStopAction> result = new ArrayList<ReplicationJobStopAction>();
        if (!StringUtil.isNullOrEmpty((String)serverUUID)) {
            for (ReplicationJobStopAction action : this.actions) {
                if (!serverUUID.equals(action.getServerUUID())) continue;
                result.add(action);
            }
        }
        return result;
    }

    @Override
    public Iterator<ReplicationJobStopAction> iterator() {
        return this.actions.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobStopActions actions1 = (ReplicationJobStopActions)o;
        return Objects.equals(this.actions, actions1.actions);
    }

    public int hashCode() {
        return Objects.hash(this.actions);
    }

    public String toString() {
        return "ReplicationJobStopActions{actions=" + this.actions + "}";
    }
}

