/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.ReplicationJob;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartActions;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopActions;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobs
implements Iterable<ReplicationJob>,
OpenSearchPluginDTO {
    private static final Logger LOG = Loggers.getLogger(ReplicationJobs.class, (String[])new String[]{"os-bpc-plugin"});
    private final Map<String, ReplicationJob> replicationJobs = new TreeMap<String, ReplicationJob>();
    private static final Object REPLICATION_JOBS_LOCK = new Object();

    public ReplicationJobs() {
    }

    public ReplicationJobs(ReplicationJobsDTO replicationJobsDTO) {
        this();
        if (replicationJobsDTO != null) {
            for (ReplicationJobDTO replicationJobDTO : replicationJobsDTO) {
                ReplicationJob job = new ReplicationJob(replicationJobDTO.getId(), replicationJobDTO.isEnabled(), replicationJobDTO.getSettingsHash());
                this.replicationJobs.put(job.getId(), job);
            }
        }
    }

    public ReplicationJobs(Map<String, Object> replicationJobsMap) {
        this();
        Set jobs = MapUtil.getArrayValueAsSetOfObjects(replicationJobsMap, (String)"entries", ReplicationJob.class);
        for (ReplicationJob job : jobs) {
            this.replicationJobs.put(job.getId(), job);
        }
    }

    public ReplicationJobs(StreamInput in) throws IOException {
        this();
        this.replicationJobs.putAll(in.readMap(StreamInput::readString, ReplicationJob::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.replicationJobs, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            builder.startObject();
            builder.startArray("entries");
            for (ReplicationJob replicationJob : this.replicationJobs.values()) {
                replicationJob.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }
    }

    public static ReplicationJobs fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobs(parser.map());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return this.replicationJobs.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return this.replicationJobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            this.replicationJobs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ReplicationJob replicationJob) {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            if (replicationJob != null) {
                this.replicationJobs.put(replicationJob.getId(), replicationJob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationJob getById(String replicationJobId) {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return this.replicationJobs.get(replicationJobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getReplicationJobIDs() {
        LOG.debug("getReplicationJobIDs");
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return new HashSet<String>(this.replicationJobs.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUsedServerUUIDs() {
        LOG.debug("getUsedServerUUIDs");
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return this._getUsedServerUUIDs();
        }
    }

    private Set<String> _getUsedServerUUIDs() {
        LOG.debug("_getUsedServerUUIDs");
        HashSet<String> result = new HashSet<String>();
        for (ReplicationJob replicationJob : this.replicationJobs.values()) {
            String serverUUID = replicationJob.getServerUUID();
            if (serverUUID == null) continue;
            result.add(serverUUID);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReplicationJob> getReplicationJobsByServerUUIDs(Set<String> serverUUIDs) {
        LOG.debug("getReplicationJobsByServerUUIDs serverUUIDs=" + serverUUIDs);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return this._getReplicationJobsByServerUUIDs(serverUUIDs);
        }
    }

    private Set<ReplicationJob> _getReplicationJobsByServerUUIDs(Set<String> serverUUIDs) {
        LOG.debug("_getReplicationJobsByServerUUIDs serverUUIDs=" + serverUUIDs);
        HashSet<ReplicationJob> result = new HashSet<ReplicationJob>();
        if (serverUUIDs != null && !serverUUIDs.isEmpty()) {
            for (ReplicationJob replicationJob : this.replicationJobs.values()) {
                if (!serverUUIDs.contains(replicationJob.getServerUUID())) continue;
                result.add(replicationJob);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReplicationJob> getReplicationJobsByServerUUID(String serverUUID) {
        LOG.debug("getReplicationJobsByServerUUID serverUUID=" + serverUUID);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            HashSet<ReplicationJob> result = new HashSet<ReplicationJob>();
            if (!StringUtil.isNullOrEmpty((String)serverUUID)) {
                for (ReplicationJob replicationJob : this.replicationJobs.values()) {
                    if (!serverUUID.equals(replicationJob.getServerUUID())) continue;
                    result.add(replicationJob);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReplicationJob> getReplicationJobsByState(ReplicationJob.State state) {
        LOG.debug("getReplicationJobsByState state=" + state);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            ArrayList<ReplicationJob> result = new ArrayList<ReplicationJob>();
            for (ReplicationJob replicationJob : this.replicationJobs.values()) {
                if (replicationJob.getState() != state) continue;
                result.add(replicationJob);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> evaluateRemovedServerUUIDs(Set<String> serverUUIDs) {
        LOG.debug("evaluateRemovedServerUUIDs serverUUIDs=" + serverUUIDs);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            Set<String> currentlyUsedServerUUIDs = this._getUsedServerUUIDs();
            HashSet<String> removedServerUUIDs = new HashSet<String>();
            for (String currentlyUsedServerUUID : currentlyUsedServerUUIDs) {
                if (serverUUIDs != null && serverUUIDs.contains(currentlyUsedServerUUID)) continue;
                removedServerUUIDs.add(currentlyUsedServerUUID);
            }
            return removedServerUUIDs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThoseAsStoppedUsingServerUUIDs(Set<String> removedServerUUIDs) {
        LOG.debug("setThoseAsStoppedUsingServerUUIDs removedServerUUIDs=" + removedServerUUIDs);
        if (removedServerUUIDs == null || removedServerUUIDs.isEmpty()) {
            return;
        }
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            Set<ReplicationJob> replicationJobsOfRemovedServerUUIDs = this._getReplicationJobsByServerUUIDs(removedServerUUIDs);
            for (ReplicationJob replicationJob : replicationJobsOfRemovedServerUUIDs) {
                replicationJob.setAsStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithStopActions(ReplicationJobStopActions stopActions, ReplicationJobs latestJobs) {
        LOG.debug("updateWithStopActions stopActions=" + stopActions + ", latestJobs=" + latestJobs);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            if (stopActions != null) {
                for (ReplicationJobStopAction stopAction : stopActions) {
                    this._stopActionDone(stopAction);
                }
            }
            this._update(latestJobs);
        }
    }

    private void _stopActionDone(ReplicationJobStopAction jobAction) {
        ReplicationJob stoppedReplicationJob;
        LOG.debug("_stopActionDone jobAction=" + jobAction);
        if (jobAction != null && (stoppedReplicationJob = this.replicationJobs.get(jobAction.getReplicationJobId())) != null) {
            stoppedReplicationJob.setAsStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithStartActions(ReplicationJobStartActions startActions, ReplicationJobs latestJobs) {
        LOG.debug("updateWithStartActions startActions=" + startActions + ", latestJobs=" + latestJobs);
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            if (startActions != null) {
                for (ReplicationJobStartAction startAction : startActions) {
                    this._startActionDone(startAction);
                }
            }
            this._update(latestJobs);
        }
    }

    private void _startActionDone(ReplicationJobStartAction jobAction) {
        ReplicationJob startedReplicationJob;
        LOG.debug("_startActionDone jobAction=" + jobAction);
        if (jobAction != null && (startedReplicationJob = this.replicationJobs.get(jobAction.getReplicationJobId())) != null) {
            startedReplicationJob.setAsRunningOnServer(jobAction.getServerUUID());
        }
    }

    private void _update(ReplicationJobs fromReplicationJobs) {
        LOG.debug("_update fromReplicationJobs=" + fromReplicationJobs);
        if (fromReplicationJobs != null) {
            for (ReplicationJob fromJob : fromReplicationJobs) {
                ReplicationJob existingJob = this.replicationJobs.get(fromJob.getId());
                if (existingJob != null) {
                    existingJob.setEnabled(fromJob.isEnabled());
                    existingJob.setSettingsHash(fromJob.getSettingsHash());
                    continue;
                }
                ReplicationJob duplicatedFromJob = new ReplicationJob(fromJob);
                duplicatedFromJob.setAsStopped();
                this.replicationJobs.put(duplicatedFromJob.getId(), duplicatedFromJob);
            }
            for (String replicationJobId : new HashSet<String>(this.replicationJobs.keySet())) {
                if (fromReplicationJobs.getById(replicationJobId) != null) continue;
                this.replicationJobs.remove(replicationJobId);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobs that = (ReplicationJobs)o;
        return Objects.equals(this.replicationJobs, that.replicationJobs);
    }

    public int hashCode() {
        return Objects.hash(this.replicationJobs);
    }

    @Override
    public Iterator<ReplicationJob> iterator() {
        return this.replicationJobs.values().iterator();
    }

    public String toString() {
        return "ReplicationJobs{replicationJobs=" + this.replicationJobs + "}";
    }
}

