/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.ReplicationJob;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobs;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;

public class ReplicationJobsComputator {
    private static final Logger LOG = Loggers.getLogger(ReplicationJobsComputator.class, (String[])new String[]{"os-bpc-plugin"});
    private final int numberOfRunnableJobs;
    private final int maxJobsPerServer;
    private final int numberOfServersWhichMustHaveMaxJobs;

    public ReplicationJobsComputator(ReplicationJobs replicationJobs, Set<String> serverUUIDs) {
        this.numberOfRunnableJobs = ReplicationJobsComputator.computeNumberOfRunnableJobs(replicationJobs);
        this.maxJobsPerServer = ReplicationJobsComputator.computeMaxJobsPerServer(serverUUIDs, this.numberOfRunnableJobs);
        this.numberOfServersWhichMustHaveMaxJobs = ReplicationJobsComputator.computeNumberOfServersWhichMustHaveMaxJobs(serverUUIDs, this.numberOfRunnableJobs);
    }

    public int getNumberOfRunnableJobs() {
        return this.numberOfRunnableJobs;
    }

    public int getMaxJobsPerServer() {
        return this.maxJobsPerServer;
    }

    public int getNumberOfServersWhichMustHaveMaxJobs() {
        return this.numberOfServersWhichMustHaveMaxJobs;
    }

    private static int computeNumberOfRunnableJobs(ReplicationJobs replicationJobs) {
        int result = 0;
        if (replicationJobs != null) {
            for (ReplicationJob replicationJob : replicationJobs) {
                if (!replicationJob.isEnabled()) continue;
                ++result;
            }
        }
        return result;
    }

    private static int computeMaxJobsPerServer(Set<String> serverUUIDs, int numberOfRunnableJobs) {
        if (serverUUIDs == null || serverUUIDs.isEmpty()) {
            return 0;
        }
        return (int)Math.ceil((float)numberOfRunnableJobs / (float)serverUUIDs.size());
    }

    private static int computeNumberOfServersWhichMustHaveMaxJobs(Set<String> serverUUIDs, int numberOfRunnableJobs) {
        if (serverUUIDs == null || serverUUIDs.isEmpty()) {
            return 0;
        }
        int result = numberOfRunnableJobs % serverUUIDs.size();
        if (result == 0) {
            result = serverUUIDs.size();
        }
        return result;
    }
}

