/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.ReplicationJob;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartActions;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopActions;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobs;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobsComputator;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobsPerServerDistributor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;

public class ReplicationJobsOrchestrator {
    private static final Logger LOG = Loggers.getLogger(ReplicationJobsOrchestrator.class, (String[])new String[]{"os-bpc-plugin"});
    private final ReplicationJobs currentReplicationJobs;

    public ReplicationJobsOrchestrator(ReplicationJobs currentReplicationJobs) {
        this.currentReplicationJobs = currentReplicationJobs;
    }

    public void updateStateOfReplicationJobsOfNoLongerConnectedServers(Set<String> connectedServerUUIDs) {
        LOG.debug("updateStateOfReplicationJobsOfNoLongerConnectedServers connectedServerUUIDs=" + connectedServerUUIDs);
        Set<String> removedServerUUIDs = this.currentReplicationJobs.evaluateRemovedServerUUIDs(connectedServerUUIDs);
        this.currentReplicationJobs.setThoseAsStoppedUsingServerUUIDs(removedServerUUIDs);
    }

    public boolean areJobsEquallyDistributed(Set<String> serverUUIDs) {
        LOG.debug("areJobsEquallyDistributed serverUUIDs=" + serverUUIDs);
        for (ReplicationJob job : this.currentReplicationJobs.getReplicationJobsByState(ReplicationJob.State.STOPPED)) {
            if (!job.isEnabled()) continue;
            return false;
        }
        if (!serverUUIDs.containsAll(this.currentReplicationJobs.getUsedServerUUIDs())) {
            return false;
        }
        ReplicationJobsComputator jobsComputator = new ReplicationJobsComputator(this.currentReplicationJobs, serverUUIDs);
        ReplicationJobsPerServerDistributor jobsDistributor = new ReplicationJobsPerServerDistributor(serverUUIDs, this.currentReplicationJobs);
        int lowestNumberOfJobsOnServer = -1;
        int highestNumberOfJobsOnServer = -1;
        int processedServersWithMaxJobs = 0;
        for (String serverUUID : serverUUIDs) {
            int numberOfJobsOnServer = jobsDistributor.getNumberOfJobsOnServer(serverUUID);
            if (lowestNumberOfJobsOnServer == -1 || numberOfJobsOnServer < lowestNumberOfJobsOnServer) {
                lowestNumberOfJobsOnServer = numberOfJobsOnServer;
            }
            if (highestNumberOfJobsOnServer == -1 || numberOfJobsOnServer > highestNumberOfJobsOnServer) {
                highestNumberOfJobsOnServer = numberOfJobsOnServer;
            }
            if (numberOfJobsOnServer > jobsComputator.getMaxJobsPerServer()) {
                return false;
            }
            if (numberOfJobsOnServer == jobsComputator.getMaxJobsPerServer()) {
                ++processedServersWithMaxJobs;
            }
            if (processedServersWithMaxJobs <= jobsComputator.getNumberOfServersWhichMustHaveMaxJobs()) continue;
            return false;
        }
        return highestNumberOfJobsOnServer - lowestNumberOfJobsOnServer <= 1;
    }

    public ReplicationJobStopActions getReplicationJobStopActions(Set<String> serverUUIDs) {
        LOG.debug("getReplicationJobStopActions serverUUIDs=" + serverUUIDs);
        ReplicationJobStopActions actions = new ReplicationJobStopActions();
        Set<String> currentlyUsedServerUUIDs = this.currentReplicationJobs.getUsedServerUUIDs();
        if (serverUUIDs != null && !serverUUIDs.isEmpty()) {
            Set<String> removedServerUUIDs = this.currentReplicationJobs.evaluateRemovedServerUUIDs(serverUUIDs);
            if (!removedServerUUIDs.isEmpty()) {
                for (String removedServerUUID : removedServerUUIDs) {
                    Set<ReplicationJob> replicationJobs = this.currentReplicationJobs.getReplicationJobsByServerUUID(removedServerUUID);
                    for (ReplicationJob replicationJobToStop : replicationJobs) {
                        ReplicationJobStopAction stopAction = new ReplicationJobStopAction(replicationJobToStop.getId(), removedServerUUID);
                        LOG.info("The replication job with the ID '" + stopAction.getReplicationJobId() + "' belongs to a stopped server '" + stopAction.getServerUUID() + "' and must be stopped.");
                        actions.add(stopAction);
                    }
                }
            }
            ReplicationJobsComputator jobsComputator = new ReplicationJobsComputator(this.currentReplicationJobs, serverUUIDs);
            int processedServersWithMaxJobs = 0;
            for (String serverUUID : serverUUIDs) {
                Set<ReplicationJob> replicationJobs = this.currentReplicationJobs.getReplicationJobsByServerUUID(serverUUID);
                int maxJobsOnServer = jobsComputator.getMaxJobsPerServer();
                if (processedServersWithMaxJobs >= jobsComputator.getNumberOfServersWhichMustHaveMaxJobs()) {
                    maxJobsOnServer = jobsComputator.getMaxJobsPerServer() - 1;
                }
                if (replicationJobs.size() <= maxJobsOnServer) continue;
                int numberOfJobsToStop = replicationJobs.size() - maxJobsOnServer;
                ArrayList<ReplicationJob> jobs = new ArrayList<ReplicationJob>(replicationJobs);
                for (int i = 0; i < numberOfJobsToStop; ++i) {
                    ReplicationJob replicationJobToStop = (ReplicationJob)jobs.get(i);
                    ReplicationJobStopAction stopAction = new ReplicationJobStopAction(replicationJobToStop.getId(), serverUUID);
                    LOG.info("The replication job with the ID '" + stopAction.getReplicationJobId() + "' belongs to a maxed-out server '" + stopAction.getServerUUID() + "' and must be stopped.");
                    actions.add(stopAction);
                }
                ++processedServersWithMaxJobs;
            }
        } else {
            for (String usedServerUUID : currentlyUsedServerUUIDs) {
                Set<ReplicationJob> replicationJobs = this.currentReplicationJobs.getReplicationJobsByServerUUID(usedServerUUID);
                for (ReplicationJob replicationJobToStop : replicationJobs) {
                    ReplicationJobStopAction stopAction = new ReplicationJobStopAction(replicationJobToStop.getId(), usedServerUUID);
                    LOG.info("The replication job with the ID '" + stopAction.getReplicationJobId() + "' belongs to a no longer existing server '" + stopAction.getServerUUID() + "' and must be stopped.");
                    actions.add(stopAction);
                }
            }
        }
        return actions;
    }

    public ReplicationJobStartActions getReplicationJobStartActions(Set<String> serverUUIDs) {
        LOG.debug("getReplicationJobStartActions serverUUIDs=" + serverUUIDs);
        ReplicationJobStartActions actions = new ReplicationJobStartActions();
        if (serverUUIDs != null && !serverUUIDs.isEmpty()) {
            ArrayList<ReplicationJob> replicationJobsToStart = new ArrayList<ReplicationJob>();
            List<ReplicationJob> stoppedReplicationJobs = this.currentReplicationJobs.getReplicationJobsByState(ReplicationJob.State.STOPPED);
            for (ReplicationJob stoppedReplicationJob : stoppedReplicationJobs) {
                if (!stoppedReplicationJob.isEnabled()) continue;
                replicationJobsToStart.add(stoppedReplicationJob);
            }
            if (!replicationJobsToStart.isEmpty()) {
                ReplicationJobsPerServerDistributor jobsPerServerDistributor = new ReplicationJobsPerServerDistributor(serverUUIDs, this.currentReplicationJobs);
                for (ReplicationJob replicationJobToStart : replicationJobsToStart) {
                    String serverUuidWithFewestNumberOfJobs = jobsPerServerDistributor.getNextServerUuidWithFewestNumberOfJobs();
                    ReplicationJobStartAction startAction = new ReplicationJobStartAction(replicationJobToStart.getId(), serverUuidWithFewestNumberOfJobs);
                    LOG.info("The replication job with the ID '" + startAction.getReplicationJobId() + "' gets started on server '" + startAction.getServerUUID() + "'.");
                    actions.add(startAction);
                }
            }
        }
        return actions;
    }

    public ReplicationJobStopActions getReplicationJobStopActions(ReplicationJobs latestReplicationJobs, Set<String> serverUUIDs) {
        ReplicationJobStopAction stopAction;
        ReplicationJob latestReplicationJob;
        ReplicationJob currentReplicationJob;
        LOG.debug("getReplicationJobStopActions latestReplicationJobs=" + latestReplicationJobs + ", serverUUIDs=" + serverUUIDs);
        ReplicationJobStopActions stopActions = new ReplicationJobStopActions();
        Set<String> currentJobIDs = this.currentReplicationJobs.getReplicationJobIDs();
        Set<String> latestJobIDs = latestReplicationJobs.getReplicationJobIDs();
        HashSet<String> removedJobIDs = new HashSet<String>(currentJobIDs);
        removedJobIDs.removeAll(latestJobIDs);
        for (String string : removedJobIDs) {
            if (stopActions.existsForReplicationJobId(string) || (currentReplicationJob = this.currentReplicationJobs.getById(string)) == null || !currentReplicationJob.isRunningOnSomeServer()) continue;
            ReplicationJobStopAction stopAction2 = new ReplicationJobStopAction(string, currentReplicationJob.getServerUUID());
            LOG.info("The replication job with the ID '" + stopAction2.getReplicationJobId() + "' does no longer exist and must be stopped on server '" + stopAction2.getServerUUID() + "'.");
            stopActions.add(stopAction2);
        }
        for (String string : latestJobIDs) {
            if (stopActions.existsForReplicationJobId(string)) continue;
            currentReplicationJob = this.currentReplicationJobs.getById(string);
            latestReplicationJob = latestReplicationJobs.getById(string);
            if (currentReplicationJob == null || latestReplicationJob == null || !currentReplicationJob.isEnabled() || latestReplicationJob.isEnabled() || !currentReplicationJob.isRunningOnSomeServer()) continue;
            stopAction = new ReplicationJobStopAction(string, currentReplicationJob.getServerUUID());
            LOG.info("The replication job with the ID '" + stopAction.getReplicationJobId() + "' is now disabled and must be stopped on server '" + stopAction.getServerUUID() + "'.");
            stopActions.add(stopAction);
        }
        for (String string : latestJobIDs) {
            if (stopActions.existsForReplicationJobId(string)) continue;
            currentReplicationJob = this.currentReplicationJobs.getById(string);
            latestReplicationJob = latestReplicationJobs.getById(string);
            if (currentReplicationJob == null || latestReplicationJob == null || currentReplicationJob.getSettingsHash() == latestReplicationJob.getSettingsHash() || !currentReplicationJob.isRunningOnSomeServer()) continue;
            stopAction = new ReplicationJobStopAction(string, currentReplicationJob.getServerUUID());
            LOG.info("The replication job with the ID '" + stopAction.getReplicationJobId() + "' has been updated and must be stopped on server '" + stopAction.getServerUUID() + "'.");
            stopActions.add(stopAction);
        }
        if (stopActions.size() > 0) {
            ReplicationJobs tmpReplicationJobs = new ReplicationJobs();
            for (ReplicationJob job : this.currentReplicationJobs) {
                tmpReplicationJobs.add(new ReplicationJob(job));
            }
            tmpReplicationJobs.updateWithStopActions(stopActions, latestReplicationJobs);
            ReplicationJobsComputator replicationJobsComputator = new ReplicationJobsComputator(tmpReplicationJobs, serverUUIDs);
            int processedServersWithMaxJobs = 0;
            for (String serverUUID : serverUUIDs) {
                Set<ReplicationJob> replicationJobsByServerUUID = tmpReplicationJobs.getReplicationJobsByServerUUID(serverUUID);
                int maxJobsOnServer = replicationJobsComputator.getMaxJobsPerServer();
                if (processedServersWithMaxJobs >= replicationJobsComputator.getNumberOfServersWhichMustHaveMaxJobs()) {
                    maxJobsOnServer = replicationJobsComputator.getMaxJobsPerServer() - 1;
                }
                if (replicationJobsByServerUUID.size() > maxJobsOnServer) {
                    ++processedServersWithMaxJobs;
                    int numberOfJobsToStop = replicationJobsByServerUUID.size() - maxJobsOnServer;
                    ArrayList<ReplicationJob> jobs = new ArrayList<ReplicationJob>(replicationJobsByServerUUID);
                    for (int i = 0; i < numberOfJobsToStop; ++i) {
                        ReplicationJob replicationJobToStop = (ReplicationJob)jobs.get(i);
                        ReplicationJobStopAction stopAction3 = new ReplicationJobStopAction(replicationJobToStop.getId(), serverUUID);
                        LOG.info("The replication job with the ID '" + stopAction3.getReplicationJobId() + "' runs on a maxed-out server '" + stopAction3.getServerUUID() + "' and must be stopped.");
                        stopActions.add(stopAction3);
                    }
                    continue;
                }
                if (replicationJobsByServerUUID.size() != maxJobsOnServer) continue;
                ++processedServersWithMaxJobs;
            }
        }
        return stopActions;
    }

    public ReplicationJobStartActions getReplicationJobStartActions(ReplicationJobs latestReplicationJobs, Set<String> serverUUIDs) {
        LOG.debug("getReplicationJobStartActions latestReplicationJobs=" + latestReplicationJobs + ", serverUUIDs=" + serverUUIDs);
        ReplicationJobStartActions actions = new ReplicationJobStartActions();
        if (serverUUIDs != null && !serverUUIDs.isEmpty()) {
            ReplicationJob replicationJob;
            ReplicationJobStartAction startAction;
            String serverUuidWithFewestNumberOfJobs;
            ReplicationJob latestReplicationJob;
            ReplicationJob currentReplicationJob;
            Set<String> currentJobIDs = this.currentReplicationJobs.getReplicationJobIDs();
            Set<String> latestJobIDs = latestReplicationJobs.getReplicationJobIDs();
            ReplicationJobsPerServerDistributor jobsPerServerDistributor = new ReplicationJobsPerServerDistributor(serverUUIDs, this.currentReplicationJobs);
            for (String jobID : latestJobIDs) {
                currentReplicationJob = this.currentReplicationJobs.getById(jobID);
                latestReplicationJob = latestReplicationJobs.getById(jobID);
                if (currentReplicationJob == null || latestReplicationJob == null || currentReplicationJob.isEnabled() || !latestReplicationJob.isEnabled()) continue;
                serverUuidWithFewestNumberOfJobs = jobsPerServerDistributor.getNextServerUuidWithFewestNumberOfJobs();
                startAction = new ReplicationJobStartAction(jobID, serverUuidWithFewestNumberOfJobs);
                LOG.info("The replication job with the ID '" + startAction.getReplicationJobId() + "' is now enabled and must be started on server '" + startAction.getServerUUID() + "'.");
                actions.add(startAction);
            }
            for (String jobID : latestJobIDs) {
                currentReplicationJob = this.currentReplicationJobs.getById(jobID);
                latestReplicationJob = latestReplicationJobs.getById(jobID);
                if (currentReplicationJob == null || latestReplicationJob == null || currentReplicationJob.getSettingsHash() == latestReplicationJob.getSettingsHash()) continue;
                serverUuidWithFewestNumberOfJobs = jobsPerServerDistributor.getNextServerUuidWithFewestNumberOfJobs();
                startAction = new ReplicationJobStartAction(jobID, serverUuidWithFewestNumberOfJobs);
                LOG.info("The replication job with the ID '" + startAction.getReplicationJobId() + "' has been updated and must be started on server '" + startAction.getServerUUID() + "'.");
                actions.add(startAction);
            }
            HashSet<String> newJobIDs = new HashSet<String>(latestJobIDs);
            newJobIDs.removeAll(currentJobIDs);
            for (String jobID : newJobIDs) {
                replicationJob = latestReplicationJobs.getById(jobID);
                if (!replicationJob.isEnabled()) continue;
                serverUuidWithFewestNumberOfJobs = jobsPerServerDistributor.getNextServerUuidWithFewestNumberOfJobs();
                startAction = new ReplicationJobStartAction(jobID, serverUuidWithFewestNumberOfJobs);
                LOG.info("The replication job with the ID '" + startAction.getReplicationJobId() + "' is new (+ enabled) and must be started on server '" + startAction.getServerUUID() + "'.");
                actions.add(startAction);
            }
            for (String jobID : currentJobIDs) {
                replicationJob = this.currentReplicationJobs.getById(jobID);
                if (replicationJob.isEnabled()) {
                    if (replicationJob.getState() == ReplicationJob.State.STOPPED) {
                        serverUuidWithFewestNumberOfJobs = jobsPerServerDistributor.getNextServerUuidWithFewestNumberOfJobs();
                        startAction = new ReplicationJobStartAction(jobID, serverUuidWithFewestNumberOfJobs);
                        LOG.info("The replication job with the ID '" + startAction.getReplicationJobId() + "' is stopped (+ enabled) and must be started on server '" + startAction.getServerUUID() + "'.");
                        actions.add(startAction);
                        continue;
                    }
                    LOG.info("The replication job with the ID '" + replicationJob.getId() + "' is enabled and already running on server '" + replicationJob.getServerUUID() + "'.");
                    continue;
                }
                LOG.info("The replication job with the ID '" + replicationJob.getId() + "' is disabled and must not be started on any server.");
            }
        }
        return actions;
    }
}

