/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobRefreshLookupJoinsActionDTO
implements OpenSearchPluginDTO {
    private final String replicationJobId;
    private final String initiatedOnServerUUID;
    private final String initiatedByUser;

    public ReplicationJobRefreshLookupJoinsActionDTO(String replicationJobId, String initiatedOnServerUUID, String initiatedByUser) {
        if (StringUtil.isNullOrEmpty((String)replicationJobId)) {
            throw new NullPointerException("The 'replicationJobId' cannot be null or empty");
        }
        if (StringUtil.isNullOrEmpty((String)initiatedOnServerUUID)) {
            throw new NullPointerException("The 'initiatedOnServerUUID' cannot be null or empty");
        }
        this.replicationJobId = replicationJobId;
        this.initiatedOnServerUUID = initiatedOnServerUUID;
        this.initiatedByUser = initiatedByUser;
    }

    public ReplicationJobRefreshLookupJoinsActionDTO(Map<String, Object> actionMap) {
        this(MapUtil.getValueAsString(actionMap, (String)"replicationJobId", null), MapUtil.getValueAsString(actionMap, (String)"initiatedOnServerUUID", null), MapUtil.getValueAsString(actionMap, (String)"initiatedByUser", null));
    }

    public ReplicationJobRefreshLookupJoinsActionDTO(StreamInput in) throws IOException {
        this.replicationJobId = in.readString();
        this.initiatedOnServerUUID = in.readString();
        this.initiatedByUser = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.replicationJobId);
        out.writeString(this.initiatedOnServerUUID);
        out.writeOptionalString(this.initiatedByUser);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("replicationJobId", this.replicationJobId);
        builder.field("initiatedOnServerUUID", this.initiatedOnServerUUID);
        builder.field("initiatedByUser", this.initiatedByUser);
        builder.endObject();
        return builder;
    }

    public static ReplicationJobRefreshLookupJoinsActionDTO fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobRefreshLookupJoinsActionDTO(parser.map());
    }

    public String getReplicationJobId() {
        return this.replicationJobId;
    }

    public String getInitiatedOnServerUUID() {
        return this.initiatedOnServerUUID;
    }

    public boolean isInitiatedByUser() {
        return !StringUtil.isNullOrEmpty((String)this.initiatedByUser);
    }

    public String getInitiatedByUser() {
        return this.initiatedByUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobRefreshLookupJoinsActionDTO that = (ReplicationJobRefreshLookupJoinsActionDTO)o;
        return Objects.equals(this.replicationJobId, that.replicationJobId) && Objects.equals(this.initiatedOnServerUUID, that.initiatedOnServerUUID) && Objects.equals(this.initiatedByUser, that.initiatedByUser);
    }

    public int hashCode() {
        return Objects.hash(this.replicationJobId, this.initiatedOnServerUUID, this.initiatedByUser);
    }

    public String toString() {
        return "ReplicationJobRefreshLookupJoinsActionDTO{replicationJobId='" + this.replicationJobId + "', initiatedOnServerUUID='" + this.initiatedOnServerUUID + "', initiatedByUser='" + this.initiatedByUser + "'}";
    }
}

