/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobRuntimeStatsDTO
implements OpenSearchPluginDTO {
    private final String serverUUID;
    private final String id;
    private final String name;
    private final Replication replication;
    private final ShadowCopy shadowCopy;
    private final TailSync tailSync;
    private final ConsistencyCheck consistencyCheck;
    private final LookupJoins lookupJoins;

    public ReplicationJobRuntimeStatsDTO(String serverUUID, String id, String name, Replication replication, ShadowCopy shadowCopy, TailSync tailSync, ConsistencyCheck consistencyCheck, LookupJoins lookupJoins) {
        Objects.requireNonNull(id, "'id' must not be null");
        Objects.requireNonNull(name, "'name' must not be null");
        this.serverUUID = serverUUID;
        this.id = id;
        this.name = name;
        this.replication = replication;
        this.shadowCopy = shadowCopy;
        this.tailSync = tailSync;
        this.consistencyCheck = consistencyCheck;
        this.lookupJoins = lookupJoins;
    }

    public ReplicationJobRuntimeStatsDTO(Map<String, Object> dataMap) {
        this(MapUtil.getValueAsString(dataMap, (String)"serverUUID", null), MapUtil.getValueAsString(dataMap, (String)"id", null), MapUtil.getValueAsString(dataMap, (String)"name", null), ReplicationJobRuntimeStatsDTO.exists(dataMap, "replication") ? new Replication(MapUtil.getValueAsMap(dataMap, (String)"replication", null)) : null, ReplicationJobRuntimeStatsDTO.exists(dataMap, "shadowCopy") ? new ShadowCopy(MapUtil.getValueAsMap(dataMap, (String)"shadowCopy", null)) : null, ReplicationJobRuntimeStatsDTO.exists(dataMap, "tailSync") ? new TailSync(MapUtil.getValueAsMap(dataMap, (String)"tailSync", null)) : null, ReplicationJobRuntimeStatsDTO.exists(dataMap, "consistencyCheck") ? new ConsistencyCheck(MapUtil.getValueAsMap(dataMap, (String)"consistencyCheck", null)) : null, ReplicationJobRuntimeStatsDTO.exists(dataMap, "joins") ? new LookupJoins(MapUtil.getValueAsList(dataMap, (String)"joins", null)) : null);
    }

    private static boolean exists(Map<String, Object> dataMap, String fieldName) {
        return dataMap != null && fieldName != null && dataMap.containsKey(fieldName);
    }

    public ReplicationJobRuntimeStatsDTO(StreamInput in) throws IOException {
        this.serverUUID = in.readOptionalString();
        this.id = in.readString();
        this.name = in.readString();
        this.replication = (Replication)in.readOptionalWriteable(Replication::new);
        this.shadowCopy = (ShadowCopy)in.readOptionalWriteable(ShadowCopy::new);
        this.tailSync = (TailSync)in.readOptionalWriteable(TailSync::new);
        this.consistencyCheck = (ConsistencyCheck)in.readOptionalWriteable(ConsistencyCheck::new);
        this.lookupJoins = (LookupJoins)in.readOptionalWriteable(LookupJoins::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.serverUUID);
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeOptionalWriteable((Writeable)this.replication);
        out.writeOptionalWriteable((Writeable)this.shadowCopy);
        out.writeOptionalWriteable((Writeable)this.tailSync);
        out.writeOptionalWriteable((Writeable)this.consistencyCheck);
        out.writeOptionalWriteable((Writeable)this.lookupJoins);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.serverUUID != null) {
            builder.field("serverUUID", this.serverUUID);
        }
        builder.field("id", this.id);
        builder.field("name", this.name);
        if (this.replication != null) {
            builder.field("replication", (ToXContent)this.replication);
        }
        if (this.shadowCopy != null) {
            builder.field("shadowCopy", (ToXContent)this.shadowCopy);
        }
        if (this.tailSync != null) {
            builder.field("tailSync", (ToXContent)this.tailSync);
        }
        if (this.consistencyCheck != null) {
            builder.field("consistencyCheck", (ToXContent)this.consistencyCheck);
        }
        if (this.lookupJoins != null) {
            builder.field("joins", (ToXContent)this.lookupJoins);
        }
        builder.endObject();
        return builder;
    }

    public static ReplicationJobRuntimeStatsDTO fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobRuntimeStatsDTO(parser.map());
    }

    public boolean hasServerUUID() {
        return this.serverUUID != null;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Replication getReplication() {
        return this.replication;
    }

    public ShadowCopy getShadowCopy() {
        return this.shadowCopy;
    }

    public TailSync getTailSync() {
        return this.tailSync;
    }

    public ConsistencyCheck getConsistencyCheck() {
        return this.consistencyCheck;
    }

    public LookupJoins getLookupJoins() {
        return this.lookupJoins;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobRuntimeStatsDTO that = (ReplicationJobRuntimeStatsDTO)o;
        return Objects.equals(this.serverUUID, that.serverUUID) && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.replication, that.replication) && Objects.equals(this.shadowCopy, that.shadowCopy) && Objects.equals(this.tailSync, that.tailSync) && Objects.equals(this.consistencyCheck, that.consistencyCheck) && Objects.equals(this.lookupJoins, that.lookupJoins);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ReplicationJobRuntimeStatsDTO{serverUUID='" + this.serverUUID + "', id='" + this.id + "', name='" + this.name + "', replication=" + this.replication + ", shadowCopy=" + this.shadowCopy + ", tailSync=" + this.tailSync + ", consistencyCheck=" + this.consistencyCheck + ", lookupJoins=" + this.lookupJoins + "}";
    }

    public static class LookupJoin
    implements OpenSearchPluginDTO {
        private final String key;
        private final String keyValuesSeparator;
        private final String lookup;

        public LookupJoin(String key, String keyValuesSeparator, String lookup) {
            this.key = key;
            this.keyValuesSeparator = keyValuesSeparator;
            this.lookup = lookup;
        }

        public LookupJoin(Map<String, Object> dataMap) {
            this(MapUtil.getValueAsString(dataMap, (String)"key", null), MapUtil.getValueAsString(dataMap, (String)"keyValuesSeparator", null), MapUtil.getValueAsString(dataMap, (String)"lookup", null));
        }

        public LookupJoin(StreamInput in) throws IOException {
            this.key = in.readString();
            this.keyValuesSeparator = in.readString();
            this.lookup = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeString(this.keyValuesSeparator);
            out.writeString(this.lookup);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("key", this.key);
            builder.field("keyValuesSeparator", this.keyValuesSeparator);
            builder.field("lookup", this.lookup);
            builder.endObject();
            return builder;
        }

        public String getKey() {
            return this.key;
        }

        public String getKeyValuesSeparator() {
            return this.keyValuesSeparator;
        }

        public String getLookup() {
            return this.lookup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupJoin that = (LookupJoin)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.keyValuesSeparator, that.keyValuesSeparator) && Objects.equals(this.lookup, that.lookup);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public String toString() {
            return "LookupJoin{key='" + this.key + "', keyValuesSeparator='" + this.keyValuesSeparator + "', lookup='" + this.lookup + "'}";
        }
    }

    public static class LookupJoins
    implements OpenSearchPluginDTO {
        private final List<LookupJoin> entries = new ArrayList<LookupJoin>();

        public LookupJoins() {
        }

        public LookupJoins(List<Map<String, Object>> dataList) {
            this();
            if (dataList != null) {
                for (Map<String, Object> entryMap : dataList) {
                    this.entries.add(new LookupJoin(entryMap));
                }
            }
        }

        public LookupJoins(StreamInput in) throws IOException {
            this();
            this.entries.addAll(in.readList(LookupJoin::new));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.entries);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (LookupJoin entry : this.entries) {
                entry.toXContent(builder, params);
            }
            builder.endArray();
            return builder;
        }

        public void add(LookupJoin lookupJoin) {
            this.entries.add(lookupJoin);
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public List<LookupJoin> getEntries() {
            return this.entries;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupJoins that = (LookupJoins)o;
            return Objects.equals(this.entries, that.entries);
        }

        public int hashCode() {
            return Objects.hash(this.entries);
        }

        public String toString() {
            return "LookupJoins{entries=" + this.entries + "}";
        }
    }

    public static class ConsistencyCheck
    implements OpenSearchPluginDTO {
        private final boolean enabled;
        private final boolean sourceAndTargetConsistent;
        private final int consistencyCheckFrequency;
        private final boolean running;
        private final long runCount;
        private final long errorCount;
        private final String lastRunStart;
        private final String lastRunEnd;
        private final long lastRunSourceDocsCount;
        private final long lastRunTargetDocsCount;

        public ConsistencyCheck(boolean enabled, boolean sourceAndTargetConsistent, int consistencyCheckFrequency, boolean running, long runCount, long errorCount, String lastRunStart, String lastRunEnd, long lastRunSourceDocsCount, long lastRunTargetDocsCount) {
            this.enabled = enabled;
            this.sourceAndTargetConsistent = sourceAndTargetConsistent;
            this.consistencyCheckFrequency = consistencyCheckFrequency;
            this.running = running;
            this.runCount = runCount;
            this.errorCount = errorCount;
            this.lastRunStart = lastRunStart;
            this.lastRunEnd = lastRunEnd;
            this.lastRunSourceDocsCount = lastRunSourceDocsCount;
            this.lastRunTargetDocsCount = lastRunTargetDocsCount;
        }

        public ConsistencyCheck(Map<String, Object> dataMap) {
            this(MapUtil.getValueAsBoolean(dataMap, (String)"enabled", (boolean)false), MapUtil.getValueAsBoolean(dataMap, (String)"sourceAndTargetConsistent", (boolean)true), MapUtil.getValueAsInt(dataMap, (String)"consistencyCheckFrequency", (int)0), MapUtil.getValueAsBoolean(dataMap, (String)"isRunning", (boolean)false), MapUtil.getValueAsLong(dataMap, (String)"runCount", (long)0L), MapUtil.getValueAsLong(dataMap, (String)"errorCount", (long)0L), MapUtil.getValueAsString(dataMap, (String)"lastRunStart", null), MapUtil.getValueAsString(dataMap, (String)"lastRunEnd", null), MapUtil.getValueAsLong(dataMap, (String)"lastRunSourceDocsCount", (long)0L), MapUtil.getValueAsLong(dataMap, (String)"lastRunTargetDocsCount", (long)0L));
        }

        public ConsistencyCheck(StreamInput in) throws IOException {
            this.enabled = in.readBoolean();
            this.sourceAndTargetConsistent = in.readBoolean();
            this.consistencyCheckFrequency = in.readVInt();
            this.running = in.readBoolean();
            this.runCount = in.readVLong();
            this.errorCount = in.readVLong();
            this.lastRunStart = in.readOptionalString();
            this.lastRunEnd = in.readOptionalString();
            this.lastRunSourceDocsCount = in.readVLong();
            this.lastRunTargetDocsCount = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.enabled);
            out.writeBoolean(this.sourceAndTargetConsistent);
            out.writeVInt(this.consistencyCheckFrequency);
            out.writeBoolean(this.running);
            out.writeVLong(this.runCount);
            out.writeVLong(this.errorCount);
            out.writeOptionalString(this.lastRunStart);
            out.writeOptionalString(this.lastRunEnd);
            out.writeVLong(this.lastRunSourceDocsCount);
            out.writeVLong(this.lastRunTargetDocsCount);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("enabled", this.enabled);
            if (this.enabled) {
                builder.field("sourceAndTargetConsistent", this.sourceAndTargetConsistent);
                builder.field("consistencyCheckFrequency", this.consistencyCheckFrequency);
                builder.field("isRunning", this.running);
                builder.field("runCount", this.runCount);
                builder.field("errorCount", this.errorCount);
                builder.field("lastRunStart", this.lastRunStart);
                builder.field("lastRunEnd", this.lastRunEnd);
                builder.field("lastRunSourceDocsCount", this.lastRunSourceDocsCount);
                builder.field("lastRunTargetDocsCount", this.lastRunTargetDocsCount);
            }
            builder.endObject();
            return builder;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isSourceAndTargetConsistent() {
            return this.sourceAndTargetConsistent;
        }

        public int getConsistencyCheckFrequency() {
            return this.consistencyCheckFrequency;
        }

        public boolean isRunning() {
            return this.running;
        }

        public long getRunCount() {
            return this.runCount;
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public String getLastRunStart() {
            return this.lastRunStart;
        }

        public String getLastRunEnd() {
            return this.lastRunEnd;
        }

        public long getLastRunSourceDocsCount() {
            return this.lastRunSourceDocsCount;
        }

        public long getLastRunTargetDocsCount() {
            return this.lastRunTargetDocsCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsistencyCheck that = (ConsistencyCheck)o;
            return this.enabled == that.enabled && this.sourceAndTargetConsistent == that.sourceAndTargetConsistent && this.consistencyCheckFrequency == that.consistencyCheckFrequency && this.running == that.running && this.runCount == that.runCount && this.errorCount == that.errorCount && this.lastRunSourceDocsCount == that.lastRunSourceDocsCount && this.lastRunTargetDocsCount == that.lastRunTargetDocsCount && Objects.equals(this.lastRunStart, that.lastRunStart) && Objects.equals(this.lastRunEnd, that.lastRunEnd);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.sourceAndTargetConsistent, this.consistencyCheckFrequency, this.running, this.runCount, this.errorCount, this.lastRunStart, this.lastRunEnd, this.lastRunSourceDocsCount, this.lastRunTargetDocsCount);
        }

        public String toString() {
            return "ConsistencyCheck{enabled=" + this.enabled + ", sourceAndTargetConsistent=" + this.sourceAndTargetConsistent + ", consistencyCheckFrequency=" + this.consistencyCheckFrequency + ", running=" + this.running + ", runCount=" + this.runCount + ", errorCount=" + this.errorCount + ", lastRunStart='" + this.lastRunStart + "', lastRunEnd='" + this.lastRunEnd + "', lastRunSourceDocsCount=" + this.lastRunSourceDocsCount + ", lastRunTargetDocsCount=" + this.lastRunTargetDocsCount + "}";
        }
    }

    public static class TailSync
    implements OpenSearchPluginDTO {
        private final boolean enabled;
        private final boolean running;
        private final long runCount;
        private final long errorCount;
        private final String cronPattern;
        private final String relativeStartDate;
        private final String relativeEndDate;
        private final String relativeDeleteOlderThanDate;
        private final String lastRunStart;
        private final String lastRunEnd;
        private final long newRecords;
        private final long updatedRecords;
        private final long deletedRecords;

        public TailSync(boolean enabled, boolean running, long runCount, long errorCount, String cronPattern, String relativeStartDate, String relativeEndDate, String relativeDeleteOlderThanDate, String lastRunStart, String lastRunEnd, long newRecords, long updatedRecords, long deletedRecords) {
            this.enabled = enabled;
            this.running = running;
            this.runCount = runCount;
            this.errorCount = errorCount;
            this.cronPattern = cronPattern;
            this.relativeStartDate = relativeStartDate;
            this.relativeEndDate = relativeEndDate;
            this.relativeDeleteOlderThanDate = relativeDeleteOlderThanDate;
            this.lastRunStart = lastRunStart;
            this.lastRunEnd = lastRunEnd;
            this.newRecords = newRecords;
            this.updatedRecords = updatedRecords;
            this.deletedRecords = deletedRecords;
        }

        public TailSync(Map<String, Object> dataMap) {
            this(MapUtil.getValueAsBoolean(dataMap, (String)"enabled", (boolean)false), MapUtil.getValueAsBoolean(dataMap, (String)"isRunning", (boolean)false), MapUtil.getValueAsLong(dataMap, (String)"runCount", (long)0L), MapUtil.getValueAsLong(dataMap, (String)"errorCount", (long)0L), MapUtil.getValueAsString(dataMap, (String)"cronPattern", null), MapUtil.getValueAsString(dataMap, (String)"relativeStartDate", null), MapUtil.getValueAsString(dataMap, (String)"relativeEndDate", null), MapUtil.getValueAsString(dataMap, (String)"relativeDeleteOlderThanDate", null), MapUtil.getValueAsString(dataMap, (String)"lastRunStart", null), MapUtil.getValueAsString(dataMap, (String)"lastRunEnd", null), MapUtil.getValueAsLong(dataMap, (String)"newRecords", (long)0L), MapUtil.getValueAsLong(dataMap, (String)"updatedRecords", (long)0L), MapUtil.getValueAsLong(dataMap, (String)"deletedRecords", (long)0L));
        }

        public TailSync(StreamInput in) throws IOException {
            this.enabled = in.readBoolean();
            this.running = in.readBoolean();
            this.runCount = in.readVLong();
            this.errorCount = in.readVLong();
            this.cronPattern = in.readOptionalString();
            this.relativeStartDate = in.readOptionalString();
            this.relativeEndDate = in.readOptionalString();
            this.relativeDeleteOlderThanDate = in.readOptionalString();
            this.lastRunStart = in.readOptionalString();
            this.lastRunEnd = in.readOptionalString();
            this.newRecords = in.readVLong();
            this.updatedRecords = in.readVLong();
            this.deletedRecords = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.enabled);
            out.writeBoolean(this.running);
            out.writeVLong(this.runCount);
            out.writeVLong(this.errorCount);
            out.writeOptionalString(this.cronPattern);
            out.writeOptionalString(this.relativeStartDate);
            out.writeOptionalString(this.relativeEndDate);
            out.writeOptionalString(this.relativeDeleteOlderThanDate);
            out.writeOptionalString(this.lastRunStart);
            out.writeOptionalString(this.lastRunEnd);
            out.writeVLong(this.newRecords);
            out.writeVLong(this.updatedRecords);
            out.writeVLong(this.deletedRecords);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("enabled", this.enabled);
            if (this.enabled) {
                builder.field("isRunning", this.running);
                builder.field("runCount", this.runCount);
                builder.field("errorCount", this.errorCount);
                builder.field("cronPattern", this.cronPattern);
                builder.field("relativeStartDate", this.relativeStartDate);
                builder.field("relativeEndDate", this.relativeEndDate);
                builder.field("relativeDeleteOlderThanDate", this.relativeDeleteOlderThanDate);
                builder.field("lastRunStart", this.lastRunStart);
                builder.field("lastRunEnd", this.lastRunEnd);
                builder.field("newRecords", this.newRecords);
                builder.field("updatedRecords", this.updatedRecords);
                builder.field("deletedRecords", this.deletedRecords);
            }
            builder.endObject();
            return builder;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isRunning() {
            return this.running;
        }

        public long getRunCount() {
            return this.runCount;
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public String getCronPattern() {
            return this.cronPattern;
        }

        public String getRelativeStartDate() {
            return this.relativeStartDate;
        }

        public String getRelativeEndDate() {
            return this.relativeEndDate;
        }

        public String getRelativeDeleteOlderThanDate() {
            return this.relativeDeleteOlderThanDate;
        }

        public String getLastRunStart() {
            return this.lastRunStart;
        }

        public String getLastRunEnd() {
            return this.lastRunEnd;
        }

        public long getNewRecords() {
            return this.newRecords;
        }

        public long getUpdatedRecords() {
            return this.updatedRecords;
        }

        public long getDeletedRecords() {
            return this.deletedRecords;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TailSync tailSync = (TailSync)o;
            return this.enabled == tailSync.enabled && this.running == tailSync.running && this.runCount == tailSync.runCount && this.errorCount == tailSync.errorCount && this.newRecords == tailSync.newRecords && this.updatedRecords == tailSync.updatedRecords && this.deletedRecords == tailSync.deletedRecords && Objects.equals(this.cronPattern, tailSync.cronPattern) && Objects.equals(this.relativeStartDate, tailSync.relativeStartDate) && Objects.equals(this.relativeEndDate, tailSync.relativeEndDate) && Objects.equals(this.relativeDeleteOlderThanDate, tailSync.relativeDeleteOlderThanDate) && Objects.equals(this.lastRunStart, tailSync.lastRunStart) && Objects.equals(this.lastRunEnd, tailSync.lastRunEnd);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.running, this.runCount, this.errorCount, this.cronPattern, this.relativeStartDate, this.relativeEndDate, this.relativeDeleteOlderThanDate, this.lastRunStart, this.lastRunEnd, this.newRecords, this.updatedRecords, this.deletedRecords);
        }

        public String toString() {
            return "TailSync{enabled=" + this.enabled + ", running=" + this.running + ", runCount=" + this.runCount + ", errorCount=" + this.errorCount + ", cronPattern='" + this.cronPattern + "', relativeStartDate='" + this.relativeStartDate + "', relativeEndDate='" + this.relativeEndDate + "', relativeDeleteOlderThanDate='" + this.relativeDeleteOlderThanDate + "', lastRunStart='" + this.lastRunStart + "', lastRunEnd='" + this.lastRunEnd + "', newRecords=" + this.newRecords + ", updatedRecords=" + this.updatedRecords + ", deletedRecords=" + this.deletedRecords + "}";
        }
    }

    public static class ShadowCopy
    implements OpenSearchPluginDTO {
        private final boolean enabled;
        private final boolean running;
        private final String cronPattern;
        private final int keepCopiesCount;
        private final String lastRunStart;
        private final String lastRunEnd;

        public ShadowCopy(boolean enabled, boolean running, String cronPattern, int keepCopiesCount, String lastRunStart, String lastRunEnd) {
            this.enabled = enabled;
            this.running = running;
            this.cronPattern = cronPattern;
            this.keepCopiesCount = keepCopiesCount;
            this.lastRunStart = lastRunStart;
            this.lastRunEnd = lastRunEnd;
        }

        public ShadowCopy(Map<String, Object> dataMap) {
            this(MapUtil.getValueAsBoolean(dataMap, (String)"enabled", (boolean)false), MapUtil.getValueAsBoolean(dataMap, (String)"isRunning", (boolean)false), MapUtil.getValueAsString(dataMap, (String)"cronPattern", null), MapUtil.getValueAsInt(dataMap, (String)"keepCopiesCount", (int)0), MapUtil.getValueAsString(dataMap, (String)"lastRunStart", null), MapUtil.getValueAsString(dataMap, (String)"lastRunEnd", null));
        }

        public ShadowCopy(StreamInput in) throws IOException {
            this.enabled = in.readBoolean();
            this.running = in.readBoolean();
            this.cronPattern = in.readOptionalString();
            this.keepCopiesCount = in.readVInt();
            this.lastRunStart = in.readOptionalString();
            this.lastRunEnd = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.enabled);
            out.writeBoolean(this.running);
            out.writeOptionalString(this.cronPattern);
            out.writeVInt(this.keepCopiesCount);
            out.writeOptionalString(this.lastRunStart);
            out.writeOptionalString(this.lastRunEnd);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("enabled", this.enabled);
            if (this.enabled) {
                builder.field("isRunning", this.running);
                builder.field("cronPattern", this.cronPattern);
                builder.field("keepCopiesCount", this.keepCopiesCount);
                builder.field("lastRunStart", this.lastRunStart);
                builder.field("lastRunEnd", this.lastRunEnd);
            }
            builder.endObject();
            return builder;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isRunning() {
            return this.running;
        }

        public String getCronPattern() {
            return this.cronPattern;
        }

        public int getKeepCopiesCount() {
            return this.keepCopiesCount;
        }

        public String getLastRunStart() {
            return this.lastRunStart;
        }

        public String getLastRunEnd() {
            return this.lastRunEnd;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShadowCopy that = (ShadowCopy)o;
            return this.enabled == that.enabled && this.running == that.running && this.keepCopiesCount == that.keepCopiesCount && Objects.equals(this.cronPattern, that.cronPattern) && Objects.equals(this.lastRunStart, that.lastRunStart) && Objects.equals(this.lastRunEnd, that.lastRunEnd);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.running, this.cronPattern, this.keepCopiesCount, this.lastRunStart, this.lastRunEnd);
        }

        public String toString() {
            return "ShadowCopy{enabled=" + this.enabled + ", running=" + this.running + ", cronPattern='" + this.cronPattern + "', keepCopiesCount=" + this.keepCopiesCount + ", lastRunStart='" + this.lastRunStart + "', lastRunEnd='" + this.lastRunEnd + "'}";
        }
    }

    public static class Replication
    implements OpenSearchPluginDTO {
        private final boolean enabled;
        private final boolean running;
        private final int replicationInterval;
        private final int runCount;
        private final int errorCount;
        private final String currentErrorMessage;
        private final String oldestDataSet;
        private final String currentLowerDateLimit;
        private final String lastRunStart;
        private final String lastRunEnd;
        private final String lastUpdateTimestampOnRestart;
        private final int replicatedRecords;
        private final String rdmsDataSourceName;
        private final boolean rdmsDataSourceRegisteredWithKaraf;

        public Replication(boolean enabled, boolean running, int replicationInterval, int runCount, int errorCount, String currentErrorMessage, String oldestDataSet, String currentLowerDateLimit, String lastRunStart, String lastRunEnd, String lastUpdateTimestampOnRestart, int replicatedRecords, String rdmsDataSourceName, boolean rdmsDataSourceRegisteredWithKaraf) {
            this.enabled = enabled;
            this.running = running;
            this.replicationInterval = replicationInterval;
            this.runCount = runCount;
            this.errorCount = errorCount;
            this.currentErrorMessage = currentErrorMessage;
            this.oldestDataSet = oldestDataSet;
            this.currentLowerDateLimit = currentLowerDateLimit;
            this.lastRunStart = lastRunStart;
            this.lastRunEnd = lastRunEnd;
            this.lastUpdateTimestampOnRestart = lastUpdateTimestampOnRestart;
            this.replicatedRecords = replicatedRecords;
            this.rdmsDataSourceName = rdmsDataSourceName;
            this.rdmsDataSourceRegisteredWithKaraf = rdmsDataSourceRegisteredWithKaraf;
        }

        public Replication(Map<String, Object> dataMap) {
            this(MapUtil.getValueAsBoolean(dataMap, (String)"enabled", (boolean)false), MapUtil.getValueAsBoolean(dataMap, (String)"isRunning", (boolean)false), MapUtil.getValueAsInt(dataMap, (String)"replicationInterval", (int)0), MapUtil.getValueAsInt(dataMap, (String)"runCount", (int)0), MapUtil.getValueAsInt(dataMap, (String)"errorCount", (int)0), MapUtil.getValueAsString(dataMap, (String)"currentErrorMessage", null), MapUtil.getValueAsString(dataMap, (String)"oldestDataSet", null), MapUtil.getValueAsString(dataMap, (String)"currentLowerDateLimit", null), MapUtil.getValueAsString(dataMap, (String)"lastRunStart", null), MapUtil.getValueAsString(dataMap, (String)"lastRunEnd", null), MapUtil.getValueAsString(dataMap, (String)"lastUpdateTimestampOnRestart", null), MapUtil.getValueAsInt(dataMap, (String)"replicatedRecords", (int)0), MapUtil.getValueAsString(dataMap, (String)"rdmsDataSourceName", null), MapUtil.getValueAsBoolean(dataMap, (String)"rdmsDataSourceRegisteredWithKaraf", (boolean)false));
        }

        public Replication(StreamInput in) throws IOException {
            this.enabled = in.readBoolean();
            this.running = in.readBoolean();
            this.replicationInterval = in.readVInt();
            this.runCount = in.readVInt();
            this.errorCount = in.readVInt();
            this.currentErrorMessage = in.readOptionalString();
            this.oldestDataSet = in.readOptionalString();
            this.currentLowerDateLimit = in.readOptionalString();
            this.lastRunStart = in.readOptionalString();
            this.lastRunEnd = in.readOptionalString();
            this.lastUpdateTimestampOnRestart = in.readOptionalString();
            this.replicatedRecords = in.readVInt();
            this.rdmsDataSourceName = in.readString();
            this.rdmsDataSourceRegisteredWithKaraf = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.enabled);
            out.writeBoolean(this.running);
            out.writeVInt(this.replicationInterval);
            out.writeVInt(this.runCount);
            out.writeVInt(this.errorCount);
            out.writeOptionalString(this.currentErrorMessage);
            out.writeOptionalString(this.oldestDataSet);
            out.writeOptionalString(this.currentLowerDateLimit);
            out.writeOptionalString(this.lastRunStart);
            out.writeOptionalString(this.lastRunEnd);
            out.writeOptionalString(this.lastUpdateTimestampOnRestart);
            out.writeVInt(this.replicatedRecords);
            out.writeString(this.rdmsDataSourceName);
            out.writeBoolean(this.rdmsDataSourceRegisteredWithKaraf);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("enabled", this.enabled);
            builder.field("isRunning", this.running);
            builder.field("replicationInterval", this.replicationInterval);
            builder.field("runCount", this.runCount);
            builder.field("errorCount", this.errorCount);
            builder.field("currentErrorMessage", this.currentErrorMessage);
            builder.field("oldestDataSet", this.oldestDataSet);
            builder.field("currentLowerDateLimit", this.currentLowerDateLimit);
            builder.field("lastRunStart", this.lastRunStart);
            builder.field("lastRunEnd", this.lastRunEnd);
            builder.field("lastUpdateTimestampOnRestart", this.lastUpdateTimestampOnRestart);
            builder.field("replicatedRecords", this.replicatedRecords);
            builder.field("rdmsDataSourceName", this.rdmsDataSourceName);
            builder.field("rdmsDataSourceRegisteredWithKaraf", this.rdmsDataSourceRegisteredWithKaraf);
            builder.endObject();
            return builder;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isRunning() {
            return this.running;
        }

        public int getReplicationInterval() {
            return this.replicationInterval;
        }

        public int getRunCount() {
            return this.runCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public String getCurrentErrorMessage() {
            return this.currentErrorMessage;
        }

        public String getOldestDataSet() {
            return this.oldestDataSet;
        }

        public String getCurrentLowerDateLimit() {
            return this.currentLowerDateLimit;
        }

        public String getLastRunStart() {
            return this.lastRunStart;
        }

        public String getLastRunEnd() {
            return this.lastRunEnd;
        }

        public String getLastUpdateTimestampOnRestart() {
            return this.lastUpdateTimestampOnRestart;
        }

        public int getReplicatedRecords() {
            return this.replicatedRecords;
        }

        public String getRdmsDataSourceName() {
            return this.rdmsDataSourceName;
        }

        public boolean isRdmsDataSourceRegisteredWithKaraf() {
            return this.rdmsDataSourceRegisteredWithKaraf;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Replication that = (Replication)o;
            return this.enabled == that.enabled && this.running == that.running && this.replicationInterval == that.replicationInterval && this.runCount == that.runCount && this.errorCount == that.errorCount && this.replicatedRecords == that.replicatedRecords && this.rdmsDataSourceRegisteredWithKaraf == that.rdmsDataSourceRegisteredWithKaraf && Objects.equals(this.currentErrorMessage, that.currentErrorMessage) && Objects.equals(this.oldestDataSet, that.oldestDataSet) && Objects.equals(this.currentLowerDateLimit, that.currentLowerDateLimit) && Objects.equals(this.lastRunStart, that.lastRunStart) && Objects.equals(this.lastRunEnd, that.lastRunEnd) && Objects.equals(this.lastUpdateTimestampOnRestart, that.lastUpdateTimestampOnRestart) && Objects.equals(this.rdmsDataSourceName, that.rdmsDataSourceName);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.running, this.replicationInterval, this.runCount, this.errorCount, this.currentErrorMessage, this.oldestDataSet, this.currentLowerDateLimit, this.lastRunStart, this.lastRunEnd, this.lastUpdateTimestampOnRestart, this.replicatedRecords, this.rdmsDataSourceName, this.rdmsDataSourceRegisteredWithKaraf);
        }

        public String toString() {
            return "Replication{enabled=" + this.enabled + ", running=" + this.running + ", replicationInterval=" + this.replicationInterval + ", runCount=" + this.runCount + ", errorCount=" + this.errorCount + ", currentErrorMessage='" + this.currentErrorMessage + "', oldestDataSet='" + this.oldestDataSet + "', currentLowerDateLimit='" + this.currentLowerDateLimit + "', lastRunStart='" + this.lastRunStart + "', lastRunEnd='" + this.lastRunEnd + "', lastUpdateTimestampOnRestart='" + this.lastUpdateTimestampOnRestart + "', replicatedRecords=" + this.replicatedRecords + ", rdmsDataSourceName='" + this.rdmsDataSourceName + "', rdmsDataSourceRegisteredWithKaraf=" + this.rdmsDataSourceRegisteredWithKaraf + "}";
        }
    }
}

