/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobsDetailsDTO
implements OpenSearchPluginDTO {
    private boolean equallyDistributed = false;
    private final List<Server> servers = new ArrayList<Server>();
    private final List<Job> jobs = new ArrayList<Job>();

    private ReplicationJobsDetailsDTO() {
    }

    public ReplicationJobsDetailsDTO(boolean equallyDistributed, List<Server> servers, List<Job> jobs) {
        this();
        this.equallyDistributed = equallyDistributed;
        if (servers != null) {
            this.servers.addAll(servers);
        }
        if (jobs != null) {
            this.jobs.addAll(jobs);
        }
    }

    public ReplicationJobsDetailsDTO(Map<String, Object> detailsMap) {
        this();
        this.equallyDistributed = MapUtil.getValueAsBoolean(detailsMap, (String)"equallyDistributed", (boolean)false);
        this.servers.addAll(MapUtil.getArrayValueAsListOfObjects(detailsMap, (String)"servers", Server.class));
        this.jobs.addAll(MapUtil.getArrayValueAsListOfObjects(detailsMap, (String)"jobs", Job.class));
    }

    public ReplicationJobsDetailsDTO(StreamInput in) throws IOException {
        this();
        this.equallyDistributed = in.readBoolean();
        this.servers.addAll(in.readList(Server::new));
        this.jobs.addAll(in.readList(Job::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.equallyDistributed);
        out.writeList(this.servers);
        out.writeList(this.jobs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("equallyDistributed", this.equallyDistributed);
        builder.startArray("servers");
        for (Server server : this.servers) {
            server.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray("jobs");
        for (Job job : this.jobs) {
            job.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static ReplicationJobsDetailsDTO fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobsDetailsDTO(parser.map());
    }

    public boolean isEquallyDistributed() {
        return this.equallyDistributed;
    }

    public Server getServerByUUID(String serverUUID) {
        if (serverUUID != null) {
            for (Server server : this.servers) {
                if (!serverUUID.equals(server.getServerUUID())) continue;
                return server;
            }
        }
        return null;
    }

    public List<Server> getServers() {
        return new ArrayList<Server>(this.servers);
    }

    public List<Job> getJobs() {
        return new ArrayList<Job>(this.jobs);
    }

    public int getTotalNumberOfJobs() {
        return this.jobs.size();
    }

    public int getNumberOfEnabledJobs() {
        int numberOfEnabledJobs = 0;
        for (Job job : this.jobs) {
            if (!job.isEnabled()) continue;
            ++numberOfEnabledJobs;
        }
        return numberOfEnabledJobs;
    }

    public int getNumberOfDisabledJobs() {
        int numberOfDisabledJobs = 0;
        for (Job job : this.jobs) {
            if (job.isEnabled()) continue;
            ++numberOfDisabledJobs;
        }
        return numberOfDisabledJobs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobsDetailsDTO that = (ReplicationJobsDetailsDTO)o;
        return this.equallyDistributed == that.equallyDistributed && Objects.equals(this.servers, that.servers) && Objects.equals(this.jobs, that.jobs);
    }

    public int hashCode() {
        return Objects.hash(this.equallyDistributed, this.servers, this.jobs);
    }

    public String toString() {
        return "ReplicationJobsDetailsDTO{equallyDistributed=" + this.equallyDistributed + ", servers=" + this.servers + ", jobs=" + this.jobs + "}";
    }

    public static class Job
    implements OpenSearchPluginDTO {
        private final String id;
        private final boolean enabled;
        private final int settingsHash;
        private final String serverUUID;
        private final String state;

        public Job(String id, boolean enabled, int settingsHash, String serverUUID, String state) {
            this.id = id;
            this.enabled = enabled;
            this.settingsHash = settingsHash;
            this.serverUUID = serverUUID;
            this.state = state;
        }

        public Job(Map<String, Object> jobMap) {
            this.id = MapUtil.getValueAsString(jobMap, (String)"id", null);
            this.enabled = MapUtil.getValueAsBoolean(jobMap, (String)"enabled", (boolean)true);
            this.settingsHash = MapUtil.getValueAsInt(jobMap, (String)"settingsHash", (int)-1);
            this.serverUUID = MapUtil.getValueAsString(jobMap, (String)"serverUUID", null);
            this.state = MapUtil.getValueAsString(jobMap, (String)"state", null);
        }

        public Job(StreamInput in) throws IOException {
            this.id = in.readString();
            this.enabled = in.readBoolean();
            this.settingsHash = in.readVInt();
            this.serverUUID = in.readOptionalString();
            this.state = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            out.writeBoolean(this.enabled);
            out.writeVInt(this.settingsHash);
            out.writeOptionalString(this.serverUUID);
            out.writeOptionalString(this.state);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("id", this.id);
            builder.field("enabled", this.enabled);
            builder.field("settingsHash", this.settingsHash);
            builder.field("serverUUID", this.serverUUID);
            builder.field("state", this.state);
            builder.endObject();
            return builder;
        }

        public String getId() {
            return this.id;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getSettingsHash() {
            return this.settingsHash;
        }

        public String getServerUUID() {
            return this.serverUUID;
        }

        public String getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Job job = (Job)o;
            return this.enabled == job.enabled && this.settingsHash == job.settingsHash && Objects.equals(this.id, job.id) && Objects.equals(this.serverUUID, job.serverUUID) && Objects.equals(this.state, job.state);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return "Job{id='" + this.id + "', enabled=" + this.enabled + ", settingsHash=" + this.settingsHash + ", serverUUID='" + this.serverUUID + "', state='" + this.state + "'}";
        }
    }

    public static class Server
    implements OpenSearchPluginDTO {
        private final String serverUUID;
        private final boolean availableForReplication;
        private final int jobs;

        public Server(String serverUUID, boolean availableForReplication, int jobs) {
            this.serverUUID = serverUUID;
            this.availableForReplication = availableForReplication;
            this.jobs = jobs;
        }

        public Server(Map<String, Object> serverMap) {
            this.serverUUID = MapUtil.getValueAsString(serverMap, (String)"serverUUID", null);
            this.availableForReplication = MapUtil.getValueAsBoolean(serverMap, (String)"availableForReplication", (boolean)true);
            this.jobs = MapUtil.getValueAsInt(serverMap, (String)"jobs", (int)0);
        }

        public Server(StreamInput in) throws IOException {
            this.serverUUID = in.readString();
            this.availableForReplication = in.readBoolean();
            this.jobs = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.serverUUID);
            out.writeBoolean(this.availableForReplication);
            out.writeVInt(this.jobs);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("serverUUID", this.serverUUID);
            builder.field("availableForReplication", this.availableForReplication);
            builder.field("jobs", this.jobs);
            builder.endObject();
            return builder;
        }

        public String getServerUUID() {
            return this.serverUUID;
        }

        public boolean isAvailableForReplication() {
            return this.availableForReplication;
        }

        public int getJobs() {
            return this.jobs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Server server = (Server)o;
            return this.availableForReplication == server.availableForReplication && this.jobs == server.jobs && Objects.equals(this.serverUUID, server.serverUUID);
        }

        public int hashCode() {
            return Objects.hash(this.serverUUID, this.availableForReplication, this.jobs);
        }

        public String toString() {
            return "Server{serverUUID='" + this.serverUUID + "', availableForReplication=" + this.availableForReplication + ", jobs=" + this.jobs + "}";
        }
    }
}

