/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobsRefreshLookupJoinsActionDTO
implements OpenSearchPluginDTO {
    private final String initiatedOnServerUUID;
    private final String initiatedByUser;

    public ReplicationJobsRefreshLookupJoinsActionDTO(String initiatedOnServerUUID, String initiatedByUser) {
        if (StringUtil.isNullOrEmpty((String)initiatedOnServerUUID)) {
            throw new NullPointerException("The 'initiatedOnServerUUID' cannot be null or empty");
        }
        this.initiatedOnServerUUID = initiatedOnServerUUID;
        this.initiatedByUser = initiatedByUser;
    }

    public ReplicationJobsRefreshLookupJoinsActionDTO(Map<String, Object> actionMap) {
        this(MapUtil.getValueAsString(actionMap, (String)"initiatedOnServerUUID", null), MapUtil.getValueAsString(actionMap, (String)"initiatedByUser", null));
    }

    public ReplicationJobsRefreshLookupJoinsActionDTO(StreamInput in) throws IOException {
        this.initiatedOnServerUUID = in.readString();
        this.initiatedByUser = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.initiatedOnServerUUID);
        out.writeOptionalString(this.initiatedByUser);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("initiatedOnServerUUID", this.initiatedOnServerUUID);
        builder.field("initiatedByUser", this.initiatedByUser);
        builder.endObject();
        return builder;
    }

    public static ReplicationJobsRefreshLookupJoinsActionDTO fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobsRefreshLookupJoinsActionDTO(parser.map());
    }

    public String getInitiatedOnServerUUID() {
        return this.initiatedOnServerUUID;
    }

    public boolean isInitiatedByUser() {
        return !StringUtil.isNullOrEmpty((String)this.initiatedByUser);
    }

    public String getInitiatedByUser() {
        return this.initiatedByUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobsRefreshLookupJoinsActionDTO that = (ReplicationJobsRefreshLookupJoinsActionDTO)o;
        return Objects.equals(this.initiatedOnServerUUID, that.initiatedOnServerUUID) && Objects.equals(this.initiatedByUser, that.initiatedByUser);
    }

    public int hashCode() {
        return Objects.hash(this.initiatedOnServerUUID, this.initiatedByUser);
    }

    public String toString() {
        return "ReplicationJobsRefreshLookupJoinsActionDTO{initiatedOnServerUUID='" + this.initiatedOnServerUUID + "', initiatedByUser='" + this.initiatedByUser + "'}";
    }
}

