/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRuntimeStatsDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobsWithRuntimeStatsFromServerDTO
implements OpenSearchPluginDTO {
    private String serverUUID = null;
    private final List<ReplicationJobRuntimeStatsDTO> replicationJobs = new ArrayList<ReplicationJobRuntimeStatsDTO>();

    private ReplicationJobsWithRuntimeStatsFromServerDTO() {
    }

    public ReplicationJobsWithRuntimeStatsFromServerDTO(String serverUUID) {
        this();
        Objects.requireNonNull(serverUUID, "'serverUUID' must not be null");
        this.serverUUID = serverUUID;
        this.replicationJobs.addAll(new ArrayList());
    }

    public ReplicationJobsWithRuntimeStatsFromServerDTO(String serverUUID, List<ReplicationJobRuntimeStatsDTO> replicationJobs) {
        this();
        Objects.requireNonNull(serverUUID, "'serverUUID' must not be null");
        this.serverUUID = serverUUID;
        if (replicationJobs != null) {
            this.replicationJobs.addAll(replicationJobs);
        }
    }

    public ReplicationJobsWithRuntimeStatsFromServerDTO(Map<String, Object> dataMap) {
        this();
        this.serverUUID = MapUtil.getValueAsString(dataMap, (String)"serverUUID", null);
        this.replicationJobs.addAll(MapUtil.getArrayValueAsListOfObjects(dataMap, (String)"replicationJobs", ReplicationJobRuntimeStatsDTO.class));
    }

    public ReplicationJobsWithRuntimeStatsFromServerDTO(StreamInput in) throws IOException {
        this();
        this.serverUUID = in.readString();
        this.replicationJobs.addAll(in.readList(ReplicationJobRuntimeStatsDTO::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.serverUUID);
        out.writeList(this.replicationJobs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("serverUUID", this.serverUUID);
        builder.startArray("replicationJobs");
        for (ReplicationJobRuntimeStatsDTO replicationJobRuntimeStats : this.replicationJobs) {
            replicationJobRuntimeStats.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static ReplicationJobsWithRuntimeStatsFromServerDTO fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobsWithRuntimeStatsFromServerDTO(parser.map());
    }

    public void add(ReplicationJobRuntimeStatsDTO replicationJobRuntimeStats) {
        this.replicationJobs.add(replicationJobRuntimeStats);
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public List<ReplicationJobRuntimeStatsDTO> getReplicationJobs() {
        return this.replicationJobs;
    }

    public boolean hasReplicationJob(String replicationJobId) {
        for (ReplicationJobRuntimeStatsDTO replicationJob : this.replicationJobs) {
            if (!replicationJobId.equals(replicationJob.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobsWithRuntimeStatsFromServerDTO that = (ReplicationJobsWithRuntimeStatsFromServerDTO)o;
        return Objects.equals(this.serverUUID, that.serverUUID) && Objects.equals(this.replicationJobs, that.replicationJobs);
    }

    public int hashCode() {
        return Objects.hash(this.serverUUID);
    }

    public String toString() {
        return "ReplicationJobsWithRuntimeStatsFromServerDTO{serverUUID='" + this.serverUUID + "', replicationJobs=" + this.replicationJobs + "}";
    }
}

