/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRefreshLookupJoinsActionDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import org.opensearch.core.xcontent.ToXContent;

public class RefreshLookupJoinsOfReplicationJobWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "RefreshLookupJoinsOfReplicationJobMessage:::";
    private final ReplicationJobRefreshLookupJoinsActionDTO refreshLookupJoinsAction;
    private final Instant sendedAtInUtc;

    public RefreshLookupJoinsOfReplicationJobWebsocketMessage(ReplicationJobRefreshLookupJoinsActionDTO restartAction) {
        this(restartAction, TimestampUtil.nowInUtc());
    }

    public RefreshLookupJoinsOfReplicationJobWebsocketMessage(ReplicationJobRefreshLookupJoinsActionDTO restartAction, Instant sendedAtInUtc) {
        this.refreshLookupJoinsAction = restartAction;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public RefreshLookupJoinsOfReplicationJobWebsocketMessage(Map<String, Object> msgMap) {
        this(new ReplicationJobRefreshLookupJoinsActionDTO(MapUtil.getValueAsMap(msgMap, (String)"action", null)), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
    }

    private Map<String, Object> asMap() throws IOException {
        return MapUtil.mapOf((Object[])new Object[]{"action", JsonUtil.asMap((ToXContent)this.refreshLookupJoinsAction), "sendedAt", this.sendedAtInUtc});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static RefreshLookupJoinsOfReplicationJobWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new RefreshLookupJoinsOfReplicationJobWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + RefreshLookupJoinsOfReplicationJobWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public ReplicationJobRefreshLookupJoinsActionDTO getRefreshLookupJoinsAction() {
        return this.refreshLookupJoinsAction;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "RefreshLookupJoinsOfReplicationJobWebsocketMessage{refreshLookupJoinsAction=" + this.refreshLookupJoinsAction + ", sendedAtInUtc=" + this.sendedAtInUtc + "}";
    }
}

