/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRestartActionDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import org.opensearch.core.xcontent.ToXContent;

public class ReplicationJobRestartWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "RestartOfReplicationJobMessage:::";
    private final ReplicationJobRestartActionDTO restartAction;
    private final Instant sendedAtInUtc;

    public ReplicationJobRestartWebsocketMessage(ReplicationJobRestartActionDTO restartAction) {
        this(restartAction, TimestampUtil.nowInUtc());
    }

    public ReplicationJobRestartWebsocketMessage(ReplicationJobRestartActionDTO restartAction, Instant sendedAtInUtc) {
        this.restartAction = restartAction;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public ReplicationJobRestartWebsocketMessage(Map<String, Object> msgMap) {
        this(new ReplicationJobRestartActionDTO(MapUtil.getValueAsMap(msgMap, (String)"action", null)), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
    }

    private Map<String, Object> asMap() throws IOException {
        return MapUtil.mapOf((Object[])new Object[]{"action", JsonUtil.asMap((ToXContent)this.restartAction), "sendedAt", this.sendedAtInUtc});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static ReplicationJobRestartWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new ReplicationJobRestartWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + ReplicationJobRestartWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public ReplicationJobRestartActionDTO getRestartAction() {
        return this.restartAction;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "RestartOfReplicationJobWebsocketMessage{restartAction=" + this.restartAction + ", sendedAtInUtc=" + this.sendedAtInUtc + "}";
    }
}

