/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;

public class SetAsMasterServerWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "SetAsMasterServer:::";
    private final String serverUUID;
    private final Instant sendedAtInUtc;

    public SetAsMasterServerWebsocketMessage(String serverUUID) {
        this(serverUUID, TimestampUtil.nowInUtc());
    }

    public SetAsMasterServerWebsocketMessage(String serverUUID, Instant sendedAtInUtc) {
        this.serverUUID = serverUUID;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public SetAsMasterServerWebsocketMessage(Map<String, Object> msgMap) {
        this(MapUtil.getValueAsString(msgMap, (String)"serverUUID", null), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
    }

    private Map<String, Object> asMap() {
        return MapUtil.mapOf((Object[])new Object[]{"serverUUID", this.serverUUID, "sendedAt", TimestampUtil.formatAsIsoInstantString((Instant)this.sendedAtInUtc)});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static SetAsMasterServerWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new SetAsMasterServerWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + SetAsMasterServerWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "SetAsMasterWebsocketMessage{serverUUID='" + this.serverUUID + "', sendedAtInUtc=" + this.sendedAtInUtc + "}";
    }
}

